/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import jclass.chart.JCChartBundle;

public abstract class BaseEditor
extends Panel
implements PropertyEditor {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    Object valueObj;

    public BaseEditor() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        Panel panel = this.makePropertyPanel();
        if (panel != null) {
            this.add("Center", panel);
        }
    }

    protected abstract Panel makePropertyPanel();

    public void setValue(Object object) {
        this.valueObj = object;
    }

    public Object getValue() {
        return this.valueObj;
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return "Click to edit...";
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        return "\"" + this.valueObj + "\"";
    }

    public Dimension preferredSize() {
        Dimension dimension = new Dimension(200, 0);
        return dimension;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

