/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import jclass.chart.AxisRelationshipWrapper;
import jclass.chart.JCChartBundle;
import jclass.chart.MultiChart;
import jclass.chart.bean.GroupPanel;
import jclass.chart.bean.RadioEditor;

public class AxisRelationshipEditor
extends RadioEditor
implements ItemListener,
ActionListener,
FocusListener {
    protected Label raxis_lb;
    protected Choice raxis_ch;
    protected TextField constant_tf;
    protected TextField multiplier_tf;
    String[] raxis_names;
    AxisRelationshipWrapper wrap;

    public AxisRelationshipEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    protected void setEnumArrays() {
        this.raxis_names = new String[MultiChart.AXIS_RADIO_NAMES.length];
        System.arraycopy(MultiChart.AXIS_RADIO_NAMES, 0, this.raxis_names, 0, MultiChart.AXIS_RADIO_NAMES.length);
    }

    protected Panel makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel(JCChartBundle.string("jclass.chart.Key229"));
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.raxis_ch = new Choice();
        this.setEnumArrays();
        int n = 0;
        while (n < this.raxis_names.length) {
            this.raxis_ch.addItem(this.raxis_names[n]);
            ++n;
        }
        this.raxis_ch.addItem(JCChartBundle.string("jclass.chart.Key215"));
        this.raxis_lb = new Label(JCChartBundle.string("jclass.chart.Key230"));
        Label label = new Label(JCChartBundle.string("jclass.chart.Key231"));
        Label label2 = new Label(JCChartBundle.string("jclass.chart.Key232"));
        this.multiplier_tf = new TextField(5);
        this.constant_tf = new TextField(5);
        groupPanel.add((Component)this.raxis_lb, gridBagConstraints);
        groupPanel.add((Component)this.raxis_ch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)label, gridBagConstraints);
        groupPanel.add((Component)this.multiplier_tf, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)label2, gridBagConstraints);
        groupPanel.add((Component)this.constant_tf, gridBagConstraints);
        this.add("Center", groupPanel);
        this.raxis_ch.addItemListener(this);
        this.multiplier_tf.addActionListener(this);
        this.multiplier_tf.addFocusListener(this);
        this.constant_tf.addActionListener(this);
        this.constant_tf.addFocusListener(this);
        return groupPanel;
    }

    public void setValue(Object object) {
        this.wrap = (AxisRelationshipWrapper)object;
        if (this.wrap == null) {
            this.wrap = new AxisRelationshipWrapper();
        }
        Checkbox checkbox = this.radioG.getSelectedCheckbox();
        this.switchItem(checkbox);
    }

    protected void switchValues(int n) {
        if (n < 0 || this.wrap == null) {
            return;
        }
        this.setRAxis(this.wrap.raxis, n, this.raxis_names, this.raxis_ch);
        ((TextComponent)this.multiplier_tf).setText(String.valueOf(this.wrap.multiplier[n]));
        ((TextComponent)this.constant_tf).setText(String.valueOf(this.wrap.constant[n]));
        this.validate();
    }

    public void setRAxis(int[] nArray, int n, String[] stringArray, Choice choice) {
        if (this.wrap.raxis[n] == -1) {
            choice.select(choice.getItemCount() - 1);
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (MultiChart.AXIS_RADIO_NAMES[nArray[n]].equals(stringArray[n2])) {
                choice.select(n2);
            }
            ++n2;
        }
    }

    public Object getValue() {
        return this.wrap;
    }

    public String getJavaInitializationString() {
        return "new jclass.chart.AxisRelationshipWrapper(" + this.wrap + ")";
    }

    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width = Math.max(dimension.width, 400);
        dimension.height += 250;
        return dimension;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object instanceof Choice) {
            this.checkProperties(object);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.checkProperties(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.checkProperties(object);
    }

    public void checkProperties(Object object) {
        try {
            if (object == this.constant_tf) {
                this.setDoubleProperty(this.constant_tf.getText(), this.wrap.constant, this.radioSel, this.wrap.constant_def);
                this.switchValues(this.radioSel);
                return;
            }
            if (object == this.multiplier_tf) {
                this.setDoubleProperty(this.multiplier_tf.getText(), this.wrap.multiplier, this.radioSel, this.wrap.multiplier_def);
                this.switchValues(this.radioSel);
                return;
            }
            if (object == this.raxis_ch) {
                int n = this.raxis_ch.getSelectedIndex();
                this.wrap.raxis[this.radioSel] = n == this.raxis_names.length ? -1 : n;
                this.support.firePropertyChange("", null, null);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public static void main(String[] stringArray) {
        Frame frame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            frame = (Frame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            frame = new Frame();
        }
        serializable = new AxisRelationshipEditor();
        ((Component)serializable).setBackground(Color.lightGray);
        AxisRelationshipWrapper axisRelationshipWrapper = new AxisRelationshipWrapper("", "", "");
        ((AxisRelationshipEditor)serializable).setValue(axisRelationshipWrapper);
        frame.add((Component)serializable);
        frame.pack();
        Dimension dimension = ((Container)serializable).getPreferredSize();
        ((Component)frame).setSize(dimension.width + 100, dimension.height + 50);
        frame.show();
    }
}

