/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import jclass.chart.AxisPlacementWrapper;
import jclass.chart.JCAxis;
import jclass.chart.JCChartBundle;
import jclass.chart.MultiChart;
import jclass.chart.bean.GroupPanel;
import jclass.chart.bean.RadioEditor;

public class AxisPlacementEditor
extends RadioEditor
implements ItemListener,
ActionListener,
FocusListener {
    protected Choice placement_ch;
    protected TextField location_tf;
    protected Label paxis_lb;
    protected Choice paxis_ch;
    String[] placement_names;
    int[] placement_vals;
    String[] paxis_names;
    AxisPlacementWrapper wrap;

    public AxisPlacementEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    protected void setEnumArrays() {
        this.placement_names = new String[JCAxis.placement_strings.length];
        System.arraycopy(JCAxis.placement_strings, 0, this.placement_names, 0, JCAxis.placement_strings.length);
        this.placement_vals = JCAxis.placement_values;
        this.paxis_names = new String[MultiChart.AXIS_RADIO_NAMES.length];
        System.arraycopy(MultiChart.AXIS_RADIO_NAMES, 0, this.paxis_names, 0, MultiChart.AXIS_RADIO_NAMES.length);
    }

    protected Panel makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel(JCChartBundle.string("jclass.chart.Key221"));
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.placement_ch = new Choice();
        this.paxis_ch = new Choice();
        this.setEnumArrays();
        int n = 0;
        while (n < this.placement_names.length) {
            this.placement_ch.addItem(this.placement_names[n]);
            ++n;
        }
        this.placement_ch.addItem(JCChartBundle.string("jclass.chart.Key219"));
        int n2 = 0;
        while (n2 < this.paxis_names.length) {
            this.paxis_ch.addItem(this.paxis_names[n2]);
            ++n2;
        }
        this.paxis_ch.addItem(JCChartBundle.string("jclass.chart.Key215"));
        Label label = new Label(JCChartBundle.string("jclass.chart.Key222"));
        this.paxis_lb = new Label(JCChartBundle.string("jclass.chart.Key223"));
        Label label2 = new Label(JCChartBundle.string("jclass.chart.Key224"));
        this.location_tf = new TextField(5);
        groupPanel.add((Component)label, gridBagConstraints);
        groupPanel.add((Component)this.placement_ch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)this.paxis_lb, gridBagConstraints);
        groupPanel.add((Component)this.paxis_ch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)label2, gridBagConstraints);
        groupPanel.add((Component)this.location_tf, gridBagConstraints);
        this.add("Center", groupPanel);
        this.placement_ch.addItemListener(this);
        this.paxis_ch.addItemListener(this);
        this.location_tf.addActionListener(this);
        this.location_tf.addFocusListener(this);
        return groupPanel;
    }

    public void setValue(Object object) {
        this.wrap = (AxisPlacementWrapper)object;
        if (this.wrap == null) {
            this.wrap = new AxisPlacementWrapper();
        }
        Checkbox checkbox = this.radioG.getSelectedCheckbox();
        this.switchItem(checkbox);
    }

    protected void switchValues(int n) {
        if (n < 0 || this.wrap == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.placement_vals.length) {
            if (this.wrap.placement[n] == this.placement_vals[n2]) {
                this.placement_ch.select(n2);
                break;
            }
            ++n2;
        }
        this.setPAxis(this.wrap.paxis, n, this.paxis_names, this.paxis_ch);
        this.paxis_ch.setEnabled(!this.wrap.placement_isdef[n]);
        ((TextComponent)this.location_tf).setText(String.valueOf(this.wrap.location[n]));
        this.location_tf.setEnabled(!this.wrap.placement_isdef[n] && this.wrap.placement[n] == 4);
        this.validate();
    }

    public void setPAxis(int[] nArray, int n, String[] stringArray, Choice choice) {
        if (this.wrap.paxis[n] == -1) {
            choice.select(choice.getItemCount() - 1);
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (MultiChart.AXIS_RADIO_NAMES[nArray[n]].equals(stringArray[n2])) {
                choice.select(n2);
            }
            ++n2;
        }
    }

    public Object getValue() {
        return this.wrap;
    }

    public String getJavaInitializationString() {
        return "new jclass.chart.AxisPlacementWrapper(" + this.wrap + ")";
    }

    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width = Math.max(dimension.width, 400);
        dimension.height += 200;
        return dimension;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object instanceof Choice) {
            this.checkProperties(object);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.checkProperties(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.checkProperties(object);
    }

    public void checkProperties(Object object) {
        try {
            if (object == this.placement_ch) {
                int n = 0;
                boolean bl = false;
                if (bl) {
                    this.placement_ch.select(n);
                }
                if ((n = this.placement_ch.getSelectedIndex()) >= this.placement_vals.length) {
                    if (!this.wrap.placement_isdef[this.radioSel]) {
                        this.wrap.placement_isdef[this.radioSel] = true;
                        this.support.firePropertyChange("", null, null);
                    }
                } else if (this.wrap.placement[this.radioSel] != this.placement_vals[n]) {
                    this.wrap.placement[this.radioSel] = this.placement_vals[n];
                    this.wrap.placement_isdef[this.radioSel] = false;
                    this.support.firePropertyChange("", null, null);
                }
                this.switchValues(this.radioSel);
                return;
            }
            if (object == this.paxis_ch) {
                int n = this.paxis_ch.getSelectedIndex();
                this.wrap.paxis[this.radioSel] = n == this.paxis_names.length ? -1 : n;
                this.support.firePropertyChange("", null, null);
                return;
            }
            if (object == this.location_tf) {
                this.setDoubleProperty(this.location_tf.getText(), this.wrap.location, this.radioSel, this.wrap.location_def);
                this.switchValues(this.radioSel);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public static void main(String[] stringArray) {
        Frame frame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            frame = (Frame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            frame = new Frame();
        }
        serializable = new AxisPlacementEditor();
        ((Component)serializable).setBackground(Color.lightGray);
        AxisPlacementWrapper axisPlacementWrapper = new AxisPlacementWrapper("", "", "(x1 0.0)(x2 0.0)(y1 0.0)(y2 0.0)");
        ((AxisPlacementEditor)serializable).setValue(axisPlacementWrapper);
        frame.add((Component)serializable);
        frame.pack();
        Dimension dimension = ((Container)serializable).getPreferredSize();
        ((Component)frame).setSize(dimension.width + 100, dimension.height + 50);
        frame.show();
    }
}

