/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jclass.chart.AxisMiscWrapper;
import jclass.chart.JCChartBundle;
import jclass.chart.MultiChart;
import jclass.chart.bean.GroupPanel;
import jclass.chart.bean.RadioEditor;

public class AxisMiscEditor
extends RadioEditor
implements ItemListener {
    protected Checkbox show_cb;
    protected Checkbox edit_cb;
    protected Checkbox log_cb;
    AxisMiscWrapper wrap;

    public AxisMiscEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    protected Panel makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel(JCChartBundle.string("jclass.chart.Key210"));
        groupPanel.setLayout(new GridLayout(1, 3));
        this.show_cb = new Checkbox(JCChartBundle.string("jclass.chart.Key191"));
        this.edit_cb = new Checkbox(JCChartBundle.string("jclass.chart.Key211"));
        this.log_cb = new Checkbox(JCChartBundle.string("jclass.chart.Key212"));
        groupPanel.add(this.show_cb);
        groupPanel.add(this.edit_cb);
        groupPanel.add(this.log_cb);
        this.add("Center", groupPanel);
        this.show_cb.addItemListener(this);
        this.edit_cb.addItemListener(this);
        this.log_cb.addItemListener(this);
        return groupPanel;
    }

    public void setValue(Object object) {
        this.wrap = (AxisMiscWrapper)object;
        if (this.wrap == null) {
            this.wrap = new AxisMiscWrapper();
        }
        Checkbox checkbox = this.radioG.getSelectedCheckbox();
        this.switchItem(checkbox);
    }

    protected void switchValues(int n) {
        if (n < 0 || this.wrap == null) {
            return;
        }
        this.show_cb.setState(this.wrap.showing[n]);
        this.edit_cb.setState(this.wrap.editable[n]);
        this.log_cb.setState(this.wrap.logarithmic[n]);
    }

    public Object getValue() {
        return this.wrap;
    }

    public String getJavaInitializationString() {
        return "new jclass.chart.AxisMiscWrapper(" + this.wrap + ")";
    }

    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width = Math.max(dimension.width, 400);
        dimension.height += 200;
        return dimension;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            if (object == this.show_cb) {
                this.wrap.showing[this.radioSel] = this.show_cb.getState();
                this.support.firePropertyChange("", null, null);
                return;
            }
            if (object == this.edit_cb) {
                this.wrap.editable[this.radioSel] = this.edit_cb.getState();
                this.support.firePropertyChange("", null, null);
                return;
            }
            if (object == this.log_cb) {
                this.wrap.logarithmic[this.radioSel] = this.log_cb.getState();
                this.support.firePropertyChange("", null, null);
            }
        }
    }
}

