/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import jclass.chart.BarPoint;
import jclass.chart.ChartDraw;
import jclass.chart.ChartDrawUtil;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.SBarVal;

class SBarChartDraw
extends ChartDraw {
    public static final int OUTLINE_SENSITIVITY = 3;
    Point firstLast;
    Color outlineColor = Color.black;
    int x_reversed;
    int y_reversed;
    int delta_x;
    int delta_y;
    boolean is_3d = false;
    double xAxisPos = Double.MAX_VALUE;
    double[] xGridLineList;
    JCLineStyle gridLineStyle;
    boolean fastAction = false;
    boolean inAction = false;
    double yOrigin;
    BarPoint[][] pts;
    double bar_base;
    int left;
    int right;
    int top;
    int bottom;
    int height;
    MinMax x;
    MinMax y;
    MinMax datax;
    MinMax datay;
    boolean is_100_percent;
    boolean drawOutline = true;
    SBarVal[][] set_pos;
    SBarVal[][] set_neg;
    double[] ytotal;
    double[] ysum;
    double[] ysum_neg;
    double[][] ywork;
    int opp_x;
    int opp_y;
    Rectangle r;
    boolean editInverted = false;
    Point start;
    Point end;

    public void recalc() {
        Object object;
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        double d;
        double d2;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        block58: {
            super.recalc();
            JCBarChartFormat jCBarChartFormat = this.dataObject.getBarChartFormat();
            this.is_100_percent = jCBarChartFormat.get100Percent();
            if (jCBarChartFormat == null || jCBarChartFormat.clusterWidth == 0) {
                return;
            }
            this.outlineColor = this.dataObject.getOutlineColor();
            this.holeValue = this.dataObject.holeValue;
            this.datax = new MinMax(this.dataObject.xLimits.min, this.dataObject.xLimits.max);
            this.datay = new MinMax(this.dataObject.yLimits.min, this.dataObject.yLimits.max);
            this.dataObject.getDataBounds(this.datax, this.datay);
            this.xaxis = this.dataObject.xaxis;
            this.yaxis = this.dataObject.yaxis;
            this.bar_base = this.xaxis.step * (double)jCBarChartFormat.clusterWidth / 100.0;
            this.inverted = this.xaxis.isVertical;
            this.x = new MinMax();
            this.y = new MinMax();
            this.x.min = this.datax.min - this.bar_base / 2.0;
            this.x.max = this.datax.max + this.bar_base / 2.0;
            this.xaxis.setLimits(this.x);
            this.xaxis.calcTransformation();
            this.xaxis.layoutAnnotations();
            this.xaxis.checkAnnotations();
            this.x = this.xaxis.dataLimits;
            this.y = this.yaxis.dataLimits;
            this.drawOutline = Math.abs(this.xaxis.toPixel(this.xaxis.min.value + this.bar_base, this.drawFront) - this.xaxis.toPixel(this.xaxis.min.value, this.drawFront)) > 3;
            int n13 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
            int n14 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
            this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
            this.right = this.left + n13 - 1;
            int n15 = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
            this.yOrigin = this.yaxis.origin.value;
            n12 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
            this.firstLast = this.dataObject.getFirstLast();
            this.x_reversed = this.xaxis.isReversed ? 1 : 0;
            this.y_reversed = this.yaxis.isReversed ? 1 : 0;
            this.delta_x = this.chartArea.deltaX;
            this.delta_y = this.chartArea.deltaY;
            this.is_3d = this.delta_x != 0 || this.delta_y != 0;
            this.seriesList = this.dataObject.getSeries();
            int n16 = this.seriesList.length;
            if (n16 == 0 || this.firstLast == null) {
                return;
            }
            int n17 = this.firstLast.y - this.firstLast.x + 1;
            this.fastAction = this.chartArea.fastAction;
            this.inAction = this.chartArea.inAction;
            if (!this.fastAction || !this.inAction) {
                this.xAxisPos = this.xaxis.getRealPlacementLocation();
                this.xGridLineList = this.xaxis.getGridLineList();
                if (this.xGridLineList == null) {
                    this.xGridLineList = new double[0];
                }
                this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
            }
            this.set_pos = new SBarVal[n17][n16];
            this.set_neg = new SBarVal[n17][n16];
            this.ytotal = new double[n17];
            this.ysum = new double[n17];
            this.ysum_neg = new double[n17];
            this.ywork = new double[n16][n17];
            ChartDrawUtil.calcStackingInfo(this.ysum, this.ysum_neg, this.ytotal, this.ywork, this.firstLast.x, this.firstLast.y, this.seriesList, this.is_100_percent, this.holeValue, this.y, this.yaxis);
            Point[] pointArray = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
            Point[] pointArray2 = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
            n11 = 0;
            n10 = 0;
            int n18 = 0;
            int n19 = 0;
            n9 = 0;
            n8 = 0;
            this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n16];
            if (!this.is_3d) break block58;
            if (this.inverted) {
                this.opp_x = (this.delta_y > 0 ? 1 : 0) ^ this.x_reversed;
                this.opp_y = (this.delta_x <= 0 ? 1 : 0) ^ this.y_reversed;
            } else {
                this.opp_x = (this.delta_x <= 0 ? 1 : 0) ^ this.x_reversed;
                this.opp_y = (this.delta_y > 0 ? 1 : 0) ^ this.y_reversed;
            }
            n7 = this.firstLast.x;
            while (n7 <= this.firstLast.y) {
                block59: {
                    int n20;
                    int n21;
                    int n22;
                    n6 = n7 - this.firstLast.x;
                    d2 = this.seriesList[0].getX(n7) - this.bar_base / 2.0;
                    d = d2 + this.bar_base;
                    if (d < this.datax.min || d2 > this.datax.max) break block59;
                    if (d2 < this.x.min) {
                        d2 = this.x.min;
                    }
                    if (d > this.x.max) {
                        d = this.x.max;
                    }
                    if (this.inverted) {
                        n10 = this.xaxis.toPixel(d2, this.drawFront);
                        n8 = n10 - this.xaxis.toPixel(d, this.drawFront);
                        pointArray[0].y = n18 = this.opp_x != 0 ? n10 : n10 - n8;
                        pointArray2[0].y = n10 - n8;
                        pointArray2[2].y = n8;
                    } else {
                        n11 = this.xaxis.toPixel(d2, this.drawFront);
                        n9 = this.xaxis.toPixel(d, this.drawFront) - n11;
                        pointArray2[0].x = n19 = this.opp_x != 0 ? n11 : n11 + n9;
                        pointArray[0].x = n11;
                        pointArray[2].x = n9;
                    }
                    n5 = 0;
                    n4 = 0;
                    n3 = n12;
                    n2 = n12;
                    n = 0;
                    int n23 = 0;
                    bl = false;
                    int n24 = 0;
                    while (n24 < n16) {
                        block60: {
                            block62: {
                                block61: {
                                    if (this.ywork[n24][n6] == this.holeValue) break block60;
                                    boolean bl2 = bl = this.ywork[n24][n6] < 0.0;
                                    if (!bl) break block61;
                                    if (this.ywork[n24][n6] > this.y.max) break block60;
                                    n = this.yaxis.toPixel(Math.max(this.ywork[n24][n6], this.y.min), this.drawFront);
                                    n23 = n2;
                                    break block62;
                                }
                                if (this.ywork[n24][n6] < this.y.min) break block60;
                                n = this.yaxis.toPixel(Math.min(this.ywork[n24][n6], this.y.max), this.drawFront);
                                n23 = n3;
                            }
                            if (this.inverted) {
                                if (bl) {
                                    SBarVal sBarVal = new SBarVal();
                                    this.set_neg[n6][n4] = sBarVal;
                                    object = sBarVal;
                                    ++n4;
                                } else {
                                    SBarVal sBarVal = new SBarVal();
                                    this.set_pos[n6][n5] = sBarVal;
                                    object = sBarVal;
                                    ++n5;
                                }
                                object.nset_index = n24;
                                object.side_point0.x = n;
                                object.side_point2.x = n23 - n;
                                object.top_point.x = this.opp_y == 0 && !bl || this.opp_y != 0 && bl ? n : n23;
                            } else {
                                if (bl) {
                                    SBarVal sBarVal = new SBarVal();
                                    this.set_neg[n6][n4] = sBarVal;
                                    object = sBarVal;
                                    ++n4;
                                } else {
                                    SBarVal sBarVal = new SBarVal();
                                    this.set_pos[n6][n5] = sBarVal;
                                    object = sBarVal;
                                    ++n5;
                                }
                                object.nset_index = n24;
                                object.side_point0.y = n23;
                                object.side_point2.y = n - n23;
                                object.top_point.y = this.opp_y == 0 && !bl || this.opp_y != 0 && bl ? n : n23;
                            }
                            if (bl) {
                                n2 = n;
                            } else {
                                n3 = n;
                            }
                        }
                        ++n24;
                    }
                    if (this.opp_y != 0) {
                        n22 = n5 - 1;
                        n21 = n4;
                    } else {
                        n22 = n4 - 1;
                        n21 = n5;
                    }
                    BarPoint[] barPointArray = this.pts[n6];
                    int n25 = n22;
                    while (n25 >= 0) {
                        object = this.opp_y != 0 ? this.set_pos[n6][n25] : this.set_neg[n6][n25];
                        n20 = object.nset_index;
                        if (barPointArray[n20] == null) {
                            barPointArray[n20] = new BarPoint();
                        }
                        BarPoint barPoint = barPointArray[n20];
                        if (this.inverted) {
                            pointArray[0].x = object.side_point0.x;
                            pointArray[2].x = object.side_point2.x;
                            barPoint.top = this.copyPointArray(pointArray);
                            pointArray2[0].x = object.top_point.x;
                            barPoint.side = this.copyPointArray(pointArray2);
                        } else {
                            pointArray2[0].y = object.side_point0.y;
                            pointArray2[2].y = object.side_point2.y;
                            barPoint.side = this.copyPointArray(pointArray2);
                            pointArray[0].y = object.top_point.y;
                            barPoint.top = this.copyPointArray(pointArray);
                        }
                        --n25;
                    }
                    n20 = 0;
                    while (n20 < n21) {
                        object = this.opp_y != 0 ? this.set_neg[n6][n20] : this.set_pos[n6][n20];
                        int n26 = object.nset_index;
                        if (barPointArray[n26] == null) {
                            barPointArray[n26] = new BarPoint();
                        }
                        BarPoint barPoint = barPointArray[n26];
                        if (this.inverted) {
                            pointArray[0].x = object.side_point0.x;
                            pointArray[2].x = object.side_point2.x;
                            barPoint.top = this.copyPointArray(pointArray);
                            pointArray2[0].x = object.top_point.x;
                            barPoint.side = this.copyPointArray(pointArray2);
                        } else {
                            pointArray2[0].y = object.side_point0.y;
                            pointArray2[2].y = object.side_point2.y;
                            barPoint.side = this.copyPointArray(pointArray2);
                            pointArray[0].y = object.top_point.y;
                            barPoint.top = this.copyPointArray(pointArray);
                        }
                        ++n20;
                    }
                }
                ++n7;
            }
            if (this.is_3d) {
                if (this.inverted) {
                    n10 = this.delta_y > 0 ? n15 + n14 - 1 : n15;
                } else {
                    n11 = this.delta_x <= 0 ? this.left : this.right;
                }
            }
        }
        n7 = this.firstLast.x;
        while (n7 <= this.firstLast.y) {
            block63: {
                if (this.seriesList.length == 0) break;
                n6 = n7 - this.firstLast.x;
                d2 = this.seriesList[0].getX(n7) - this.bar_base / 2.0;
                d = d2 + this.bar_base;
                if (d < this.x.min || d2 > this.x.max) break block63;
                if (d2 < this.x.min) {
                    d2 = this.x.min;
                }
                if (d > this.x.max) {
                    d = this.x.max;
                }
                if (this.inverted) {
                    n10 = this.xaxis.toPixel(d2, this.drawFront);
                    n8 = Math.abs(this.xaxis.toPixel(d, this.drawFront) - n10);
                    if (this.x_reversed == 0) {
                        n10 -= n8;
                    }
                } else {
                    n11 = this.xaxis.toPixel(d2, this.drawFront);
                    n9 = Math.abs(this.xaxis.toPixel(d, this.drawFront) - n11);
                    if (this.x_reversed != 0) {
                        n11 -= n9;
                    }
                }
                n5 = n12;
                n4 = n12;
                n3 = 0;
                n2 = 0;
                object = this.pts[n6];
                n = 0;
                while (n < this.seriesList.length) {
                    block64: {
                        block66: {
                            block65: {
                                if (this.ywork[n][n6] == this.holeValue) break block64;
                                if (object[n] == null) {
                                    object[n] = new BarPoint();
                                }
                                BarPoint barPoint = object[n];
                                double d3 = this.seriesList[n].getY(n7);
                                barPoint.x = d2;
                                barPoint.y = d3;
                                boolean bl3 = bl = this.ywork[n][n6] < 0.0;
                                if (!bl) break block65;
                                if (this.ywork[n][n6] > this.y.max) break block64;
                                n3 = this.yaxis.toPixel(Math.max(this.ywork[n][n6], this.y.min), this.drawFront);
                                n2 = n4;
                                break block66;
                            }
                            if (this.ywork[n][n6] < this.y.min) break block64;
                            n3 = this.yaxis.toPixel(Math.min(this.ywork[n][n6], this.y.max), this.drawFront);
                            n2 = n5;
                        }
                        if (this.inverted) {
                            if ((this.y_reversed ^ (bl ? 1 : 0)) != 0) {
                                n9 = n2 - n3;
                                n11 = n3;
                            } else {
                                n11 = n2;
                                n9 = n3 - n2;
                            }
                        } else if ((this.y_reversed ^ (bl ? 1 : 0)) != 0) {
                            n10 = n2;
                            n8 = n3 - n2;
                        } else {
                            n10 = n3;
                            n8 = n2 - n3;
                        }
                        barPoint.front = new Rectangle(n11, n10, n9, n8);
                        if (bl) {
                            n4 = n3;
                        } else {
                            n5 = n3;
                        }
                    }
                    ++n;
                }
            }
            ++n7;
        }
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.pts == null) {
            return;
        }
        int n4 = this.seriesList.length;
        if (n4 == 0 || this.firstLast == null) {
            return;
        }
        if (this.is_3d || this.is_100_percent) {
            boolean bl = false;
            boolean bl2 = false;
            int n5 = 0;
            if (this.opp_x != 0) {
                n3 = this.firstLast.y;
                n2 = -1;
                n = n3 < this.firstLast.x ? 0 : 1;
                n5 = this.xGridLineList.length - 1;
            } else {
                n3 = this.firstLast.x;
                n2 = 1;
                n = n3 > this.firstLast.y ? 0 : 1;
                n5 = 0;
            }
            int n6 = n3;
            while (n != 0) {
                int n7;
                int n8;
                SBarVal[][] sBarValArray;
                n = this.opp_x != 0 ? (n6 <= this.firstLast.x ? 0 : 1) : (n6 >= this.firstLast.y ? 0 : 1);
                int n9 = n6 - this.firstLast.x;
                if (!this.fastAction || !this.inAction) {
                    sBarValArray = null;
                    n8 = this.set_neg[n9].length - 1;
                    while (n8 >= 0) {
                        if (this.set_neg[n9][n8] != null) {
                            n7 = this.set_neg[n9][n8].nset_index;
                            BarPoint barPoint = null;
                            try {
                                barPoint = this.pts[n9][n7];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            if (barPoint != null) {
                                sBarValArray = barPoint;
                                break;
                            }
                        }
                        --n8;
                    }
                    if (sBarValArray == null) {
                        n7 = 0;
                        while (n7 < this.set_pos[n9].length && this.set_pos[n9][n7] != null) {
                            int n10 = this.set_pos[n9][n7].nset_index;
                            BarPoint barPoint = null;
                            try {
                                barPoint = this.pts[n9][n10];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            if (barPoint != null) {
                                sBarValArray = barPoint;
                            }
                            ++n7;
                        }
                    }
                    if (sBarValArray != null) {
                        n7 = 0;
                        int n11 = 0;
                        if (this.inverted) {
                            n11 = sBarValArray.front.y + sBarValArray.front.height;
                            n7 = sBarValArray.front.y;
                        } else {
                            n7 = sBarValArray.front.x;
                            n11 = sBarValArray.front.x + sBarValArray.front.width;
                        }
                        if (!bl) {
                            int n12 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n7, n11);
                            if (n12 == 1) {
                                bl = true;
                            } else if (n12 == 2) {
                                bl2 = true;
                                bl = true;
                            }
                        }
                        if (this.xaxis.gridIsShowing) {
                            n5 = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n7, n11, this.ysum[n9], this.ysum_neg[n9], this.xGridLineList, n5, n2, this.gridLineStyle);
                        }
                    }
                }
                sBarValArray = this.opp_y != 0 ? this.set_pos : this.set_neg;
                n8 = sBarValArray[n9].length - 1;
                while (n8 >= 0) {
                    if (sBarValArray[n9][n8] != null) {
                        n7 = sBarValArray[n9][n8].nset_index;
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n9][n7];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null && this.seriesList[n7].getStyle().getFillStyle().getImage() == null) {
                            if (this.inverted) {
                                this.DrawBarFace(graphics, barPoint.top, n7, true, this.drawOutline);
                                this.DrawBarFace(graphics, barPoint.side, n7, false, this.drawOutline);
                            } else {
                                this.DrawBarFace(graphics, barPoint.side, n7, false, this.drawOutline);
                                this.DrawBarFace(graphics, barPoint.top, n7, true, this.drawOutline);
                            }
                        }
                    }
                    --n8;
                }
                sBarValArray = this.opp_y != 0 ? this.set_neg : this.set_pos;
                n7 = 0;
                while (n7 < sBarValArray[n9].length && sBarValArray[n9][n7] != null) {
                    int n13 = sBarValArray[n9][n7].nset_index;
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n9][n13];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (barPoint != null && this.seriesList[n13].getStyle().getFillStyle().getImage() == null) {
                        if (this.inverted) {
                            this.DrawBarFace(graphics, barPoint.top, n13, true, this.drawOutline);
                            this.DrawBarFace(graphics, barPoint.side, n13, false, this.drawOutline);
                        } else {
                            this.DrawBarFace(graphics, barPoint.side, n13, false, this.drawOutline);
                            this.DrawBarFace(graphics, barPoint.top, n13, true, this.drawOutline);
                        }
                    }
                    ++n7;
                }
                if (bl2) {
                    this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, this.ysum_neg[n9], this.ysum[n9]);
                    bl2 = false;
                }
                n6 += n2;
            }
            if (!this.fastAction || !this.inAction) {
                this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, this.opp_x, bl, this.xGridLineList, n5, n2, this.gridLineStyle);
            }
        }
        n3 = this.firstLast.x;
        while (n3 <= this.firstLast.y) {
            if (this.seriesList.length == 0) break;
            n2 = n3 - this.firstLast.x;
            n = 0;
            while (n < this.seriesList.length) {
                if (this.seriesList[n].isShowing && this.seriesList[n].isIncluded) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n2][n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    JCChartStyle jCChartStyle = this.seriesList[n].getStyle();
                    if (barPoint != null && barPoint.front != null) {
                        if (this.seriesList[n].getStyle().getFillStyle().getImage() != null) {
                            jCChartStyle.getFillStyle().fillImageRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, barPoint.y >= 0.0, this.inverted);
                        } else if (this.drawOutline) {
                            jCChartStyle.getFillStyle().fillOutlineRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.outlineColor);
                        } else {
                            jCChartStyle.getFillStyle().fillRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height);
                        }
                    }
                }
                ++n;
            }
            ++n3;
        }
    }

    private Point[] copyPointArray(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            pointArray2[n2] = new Point(pointArray[n2].x, pointArray[n2].y);
            ++n2;
        }
        return pointArray2;
    }

    void DrawBarFace(Graphics graphics, Point[] pointArray, int n, boolean bl, boolean bl2) {
        JCFillStyle jCFillStyle = this.seriesList[n].getStyle().getFillStyle();
        int n2 = this.chartArea.deltaX;
        int n3 = this.chartArea.deltaY;
        boolean bl3 = bl && n3 <= 0 || !bl && n2 <= 0;
        Polygon polygon = new Polygon();
        int n4 = 0;
        while (n4 < pointArray.length) {
            if (n4 == 0) {
                polygon.addPoint(pointArray[n4].x, pointArray[n4].y);
            } else {
                polygon.addPoint(polygon.xpoints[n4 - 1] + pointArray[n4].x, polygon.ypoints[n4 - 1] + pointArray[n4].y);
            }
            ++n4;
        }
        if (bl3) {
            if (bl2) {
                jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.outlineColor);
                return;
            }
            jCFillStyle.fillPolygonHighlight(graphics, polygon);
            return;
        }
        if (bl2) {
            jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.outlineColor);
            return;
        }
        jCFillStyle.fillPolygonShadow(graphics, polygon);
    }

    JCDataIndex pick(Point point, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        int n6 = -1;
        int n7 = -1;
        JCDataIndex jCDataIndex = null;
        int n8 = Integer.MAX_VALUE;
        int n9 = this.chartArea.deltaX;
        int n10 = this.chartArea.deltaY;
        boolean bl = n9 != 0 || n10 != 0;
        int n11 = this.seriesList.length;
        if (n11 == 0 || this.firstLast == null || this.pts == null) {
            return null;
        }
        if (bl || this.is_100_percent) {
            if (this.opp_x != 0) {
                n5 = this.firstLast.y;
                n4 = -1;
                n3 = n5 < this.firstLast.x ? 0 : 1;
            } else {
                n5 = this.firstLast.x;
                n4 = 1;
                n3 = n5 > this.firstLast.y ? 0 : 1;
            }
            int n12 = n5;
            while (n3 != 0) {
                n3 = this.opp_x != 0 ? (n12 <= this.firstLast.x ? 0 : 1) : (n12 >= this.firstLast.y ? 0 : 1);
                n2 = n12 - this.firstLast.x;
                BarPoint[] barPointArray = this.pts[n2];
                int n13 = 0;
                while (n13 < this.seriesList.length) {
                    if (barPointArray[n13] != null) {
                        int n14 = JCChartUtil.distanceTo3dPolygon(point.x, point.y, barPointArray[n13].top, this.inverted, n);
                        int n15 = JCChartUtil.distanceTo3dPolygon(point.x, point.y, barPointArray[n13].side, this.inverted, n);
                        if (n14 <= n8 || n15 <= n8) {
                            n6 = n13;
                            n7 = n12;
                            n8 = Math.min(n15, n14);
                        }
                    }
                    ++n13;
                }
                n12 += n4;
            }
        }
        n5 = this.firstLast.x;
        while (n5 <= this.firstLast.y) {
            n4 = n5 - this.firstLast.x;
            if (this.pts[n4] != null) {
                n3 = 0;
                while (n3 < this.pts[n4].length) {
                    if (this.seriesList[n3].isShowing) {
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n4][n3];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue && barPoint.front != null && (n2 = JCChartUtil.distance(point.x, point.y, barPoint.front)) <= n8) {
                            n6 = n3;
                            n7 = n5;
                            n8 = n2;
                        }
                    }
                    ++n3;
                }
            }
            ++n5;
        }
        if (n6 >= 0 && n7 >= 0) {
            jCDataIndex = new JCDataIndex(n7, this.seriesList[n6], n6);
            jCDataIndex.distance = n8;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n - this.firstLast.x][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return null;
        }
        double d = barPoint.y;
        double d2 = barPoint.x;
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            n4 = barPoint.front.y + barPoint.front.height / 2;
            n3 = barPoint.front.x + barPoint.front.width / 2;
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.xaxis.isVertical;
        this.end = null;
        this.start = null;
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.drawingOrder];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n2;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    /*
     * Unable to fully structure code
     */
    int endEdit(JCDataIndex var1_1, int var2_2, int var3_3) {
        block4: {
            block3: {
                if (var1_1 == null || var1_1.dataView != this.dataObject) {
                    return -1;
                }
                this.chartArea.drawRubberBand(this.end, this.start);
                var4_4 = this.pts[var1_1.point - this.firstLast.x][var1_1.series.drawingOrder];
                var5_5 = this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
                if (!this.editInverted) break block3;
                if (var4_4.front.x >= var5_5) ** GOTO lbl-1000
                v0 = false;
                break block4;
            }
            if (var4_4.front.y < var5_5) ** GOTO lbl-1000
            v0 = false;
        }
        if (v0) lbl-1000:
        // 3 sources

        {
            var6_6 = this.editInverted != false ? var2_2 - this.r.x - var4_4.front.x : var4_4.front.y + var4_4.front.height - (var3_3 - this.r.y);
        } else {
            var6_6 = this.editInverted != false ? var2_2 - this.r.x - (var4_4.front.x + var4_4.front.width) : var4_4.front.y - (var3_3 - this.r.y);
        }
        var7_7 = this.editInverted != false ? var5_5 + var6_6 : var5_5 - var6_6;
        return var7_7;
    }
}

