/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import jclass.chart.VectorDataSource;

public class JDBCDataSource
extends VectorDataSource {
    public JDBCDataSource() {
    }

    public JDBCDataSource(ResultSet resultSet) {
        this.setJDBCData(resultSet);
    }

    public JDBCDataSource(ResultSet resultSet, int n) {
        this.dataInterpretation = n;
        this.setJDBCData(resultSet);
    }

    public JDBCDataSource(ResultSet resultSet, int n, boolean bl) {
        this.dataInterpretation = n;
        this.dataInRows = bl;
        this.setJDBCData(resultSet);
    }

    public void setData(ResultSet resultSet) {
        this.setJDBCData(resultSet);
        this.updateChart(14, 0, 0);
    }

    void setJDBCData(ResultSet resultSet) {
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData == null) {
                this.clearData();
                return;
            }
            int n2 = resultSetMetaData.getColumnCount();
            if (n2 <= 0) {
                this.clearData();
                return;
            }
            boolean bl = false;
            int n3 = resultSetMetaData.getColumnType(1);
            if (n3 == 1 || n3 == 12 || n3 == -1) {
                bl = true;
            }
            int n4 = bl ? n2 - 1 : n2;
            Vector<double[]> vector = new Vector<double[]>();
            Vector<String> vector2 = new Vector<String>();
            int n5 = -1;
            while (resultSet.next()) {
                ++n5;
                double[] dArray = new double[n4];
                n = 1;
                int n6 = 0;
                while (n <= n2) {
                    if (bl && n == 1) {
                        if (this.isLabelRow(n5)) {
                            vector2.addElement(resultSet.getObject(n).toString());
                        }
                    } else {
                        n3 = resultSetMetaData.getColumnType(n);
                        double d = Double.MAX_VALUE;
                        if (n3 == 8) {
                            d = resultSet.getDouble(n);
                        } else if (n3 == 6) {
                            d = resultSet.getFloat(n);
                        } else if (n3 == -5) {
                            d = resultSet.getLong(n);
                        } else if (n3 == 4 || n3 == -6 || n3 == 5) {
                            d = resultSet.getInt(n);
                        }
                        dArray[n6++] = d;
                    }
                    ++n;
                }
                vector.addElement(dArray);
            }
            int n7 = vector.size();
            this.data = new double[n7][n4];
            n = 0;
            while (n < n7) {
                this.data[n] = (double[])vector.elementAt(n);
                ++n;
            }
            String[] stringArray = null;
            if (bl) {
                stringArray = new String[vector2.size()];
                int n8 = 0;
                while (n8 < vector2.size()) {
                    stringArray[n8] = (String)vector2.elementAt(n8);
                    ++n8;
                }
            }
            int n9 = this.getNumColLabels(n2, bl);
            String[] stringArray2 = new String[n9];
            int n10 = bl ? 2 : 1;
            int n11 = 0;
            while (n11 < n9) {
                if (this.isLabelColumn(n10, bl)) {
                    stringArray2[n11++] = resultSetMetaData.getColumnName(n10);
                }
                ++n10;
            }
            if (this.dataInRows) {
                if (bl) {
                    this.setSeriesLabels(stringArray);
                }
                this.setPointLabels(stringArray2);
                return;
            }
            if (bl) {
                this.setPointLabels(stringArray);
            }
            this.setSeriesLabels(stringArray2);
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            this.clearData();
            return;
        }
    }

    void clearData() {
        this.data = null;
    }

    boolean isLabelRow(int n) {
        if (this.autoX || !this.dataInRows) {
            return true;
        }
        return !this.isXRow(n);
    }

    boolean isLabelColumn(int n, boolean bl) {
        int n2 = n = bl ? n - 2 : n - 1;
        if (n < 0) {
            return false;
        }
        if (this.autoX || this.dataInRows) {
            return true;
        }
        boolean bl2 = true;
        if (this.dataInterpretation == 0) {
            if (n == 0) {
                bl2 = false;
            }
        } else if (n % 2 == 0) {
            bl2 = false;
        }
        return bl2;
    }

    int getNumColLabels(int n, boolean bl) {
        if (bl) {
            --n;
        }
        if (this.autoX || this.dataInRows) {
            return Math.max(n, 0);
        }
        n = this.dataInterpretation == 0 ? --n : (n /= 2);
        return Math.max(n, 0);
    }
}

