/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCStyle;
import jclass.util.JCUtilConverter;

public class JCLineStyle
extends JCStyle
implements HTMLHandler {
    int pattern = 1;
    int width = 1;
    int colorIndex;
    Color color;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int LONG_DASH = 2;
    public static final int SHORT_DASH = 3;
    public static final int LSL_DASH = 4;
    public static final int DASH_DOT = 5;
    public static final String[] linePattern_strings = new String[]{"None", "Solid", "Long_Dash", "Short_Dash", "LSL_Dash", "Dash_Dot"};
    public static final int[] linePattern_values;
    int[] xp;
    int[] yp;

    public JCLineStyle(int n, Color color, int n2) {
        this.width = n;
        this.color = color;
        this.pattern = n2;
    }

    public static JCLineStyle makeDefault(JCChart jCChart) {
        JCLineStyle jCLineStyle = new JCLineStyle(1, JCLineStyle.getDefaultColor(jCChart), JCLineStyle.getDefaultPattern(jCChart));
        int n = 0;
        if (jCChart != null) {
            n = jCChart.getLineColorIndex();
            n = n == 0 ? JCStyle.defaultColors.length - 1 : --n;
        }
        jCLineStyle.colorIndex = n;
        return jCLineStyle;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        this.draw(graphics, n, n2, n3, n4, null);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (this.pattern == 0 || this.width <= 0) {
            return;
        }
        Color color2 = color != null ? color : this.color;
        if (graphics.getColor() != color2) {
            graphics.setColor(color2);
        }
        if (this.width == 1) {
            graphics.drawLine(n, n2, n3, n4);
            return;
        }
        if (n == n3) {
            int n5 = Math.min(n2, n4);
            int n6 = Math.abs(n4 - n2);
            graphics.fillRect(n - this.width / 2, n5, this.width, n6 + 1);
            return;
        }
        if (n2 == n4) {
            int n7 = Math.min(n, n3);
            int n8 = Math.abs(n3 - n);
            graphics.fillRect(n7, n2 - this.width / 2, n8 + 1, this.width);
            return;
        }
        int n9 = n3 - n;
        int n10 = n4 - n2;
        float f = (float)(2.0 * Math.sqrt(n9 * n9 + n10 * n10));
        int n11 = Math.round((float)(n10 * this.width) / f);
        int n12 = -Math.round((float)(n9 * this.width) / f);
        JCLineStyle jCLineStyle = this;
        synchronized (jCLineStyle) {
            if (this.xp == null || this.yp == null) {
                this.xp = new int[4];
                this.yp = new int[4];
            }
            this.xp[0] = n + n11;
            this.yp[0] = n2 + n12;
            this.xp[1] = n3 + n11;
            this.yp[1] = n4 + n12;
            this.xp[2] = n3 - n11;
            this.yp[2] = n4 - n12;
            this.xp[3] = n - n11;
            this.yp[3] = n2 - n12;
            graphics.fillPolygon(this.xp, this.yp, 4);
            return;
        }
    }

    public void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.drawRect(n, n2, n3, n4);
    }

    public void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics.getColor() != this.color) {
            graphics.setColor(this.color);
        }
        graphics.fillRect(n, n2, n3, n4);
    }

    public int getPattern() {
        return this.pattern;
    }

    public void setPattern(int n) {
        JCLineStyle jCLineStyle = this;
        synchronized (jCLineStyle) {
            if (n == this.pattern) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.pattern = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key73"));
                }
            }
        }
        this.setChanged(true, 17);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        JCLineStyle jCLineStyle = this;
        synchronized (jCLineStyle) {
            if (this.width == n) {
                Object var3_3 = null;
                return;
            }
            this.width = n;
        }
        this.setChanged(true, 18);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        JCLineStyle jCLineStyle = this;
        synchronized (jCLineStyle) {
            if (this.color == color) {
                Object var3_3 = null;
                return;
            }
            this.color = color;
        }
        this.setChanged(true, 17);
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color;
        if (jCChart == null) {
            color = JCStyle.defaultColors[0];
        } else {
            color = JCStyle.defaultColors[jCChart.lineColorIndex++];
            if (jCChart.lineColorIndex >= JCStyle.defaultColors.length) {
                jCChart.lineColorIndex = 0;
            }
            if (jCChart != null && jCChart.chartArea != null && color.equals(jCChart.chartArea.getPlotArea().getBackground())) {
                color = JCStyle.defaultColors[jCChart.lineColorIndex++];
                if (jCChart.lineColorIndex >= JCStyle.defaultColors.length) {
                    jCChart.lineColorIndex = 0;
                }
            }
        }
        return color;
    }

    static int getDefaultPattern(JCChart jCChart) {
        return 1;
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        JCLineStyle jCLineStyle = JCLineStyle.makeDefault(null);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".colorIndex", jCLineStyle.colorIndex, this.colorIndex);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".color", JCStyle.defaultColors[jCLineStyle.colorIndex], this.color);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".pattern", JCUtilConverter.fromEnum(jCLineStyle.pattern, linePattern_strings, linePattern_values), JCUtilConverter.fromEnum(this.pattern, linePattern_strings, linePattern_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".width", jCLineStyle.width, this.width);
    }

    public void loadParams(String string, JCChart jCChart) {
        String string2 = jCChart.getParam(String.valueOf(string) + ".color");
        if (string2 != null) {
            this.setColor(JCChart.getConverter().toColor(string2));
        } else {
            int n = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".colorIndex"), this.colorIndex);
            if (n != this.colorIndex) {
                this.setColor(JCStyle.defaultColors[n]);
            }
        }
        this.setPattern(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".pattern"), "linePattern", linePattern_strings, linePattern_values, this.getPattern()));
        this.setWidth(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".width"), this.getWidth()));
    }

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        linePattern_values = nArray;
    }
}

