/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import jclass.chart.ChartDataView;
import jclass.chart.ChartRegion;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartConverter;
import jclass.util.JCUtilConverter;

class JCChartHTMLSave
implements HTMLSaveDriver {
    private OutputStream saveParamStream;
    private DataOutputStream outputParamStream;
    private JCChart chart;

    JCChartHTMLSave(JCChart jCChart) {
        this.chart = jCChart;
    }

    public void setSaveParamStream(OutputStream outputStream) {
        this.saveParamStream = outputStream;
        this.outputParamStream = new DataOutputStream(outputStream);
    }

    public OutputStream getSaveParamStream() {
        block2: {
            if (this.saveParamStream != null) break block2;
            try {
                this.saveParamStream = new FileOutputStream("chart.html");
            }
            catch (IOException iOException) {
                System.out.println("Cannot assign outputstream");
                iOException.printStackTrace();
            }
        }
        return this.saveParamStream;
    }

    public void writeParam(String string, boolean bl) {
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + bl + "\">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public void writeParam(String string, Date date) {
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                String string2 = null;
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
                simpleDateFormat.setCalendar(Calendar.getInstance());
                simpleDateFormat.setTimeZone(TimeZone.getDefault());
                string2 = simpleDateFormat.format(date);
                this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + string2 + "\">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public void writeParam(String string, Color color) {
        if (color == null) {
            return;
        }
        String string2 = JCUtilConverter.fromColor(color);
        this.writeParam(string, string2);
    }

    public void writeParam(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return;
        }
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + string2 + "\">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public void writeParam(String string, int n) {
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + n + "\">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public void writeParam(String string, double d) {
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + d + "\">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public void writeParam(String string, Font font) {
        if (font == null) {
            return;
        }
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + JCUtilConverter.fromFont(font) + "\">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public void writeParam(String string, Color color, Color color2) {
        JCChart jCChart;
        if (color2 == null) {
            return;
        }
        if (color == null && color2 != null) {
            jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + JCUtilConverter.fromColor(color2) + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (color2 != null && color != null && !color.equals(color2)) {
            jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + JCUtilConverter.fromColor(color2) + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public void writeParam(String string, Font font, Font font2) {
        JCChart jCChart;
        if (font2 == null) {
            return;
        }
        if (font == null && font2 != null) {
            jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + JCUtilConverter.fromFont(font2) + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (font2 != null && font != null && !font.equals(font2)) {
            jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + JCUtilConverter.fromFont(font2) + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public void writeParam(String string, String string2, String string3) {
        JCChart jCChart;
        if (string3 == null) {
            return;
        }
        if (string3 != null && string2 == null) {
            jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + string3 + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (string3 != null && string2 != null && !string2.equals(string3)) {
            jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + string3 + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public void writeParam(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            JCChart jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + bl2 + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public void writeParam(String string, int n, int n2) {
        if (n != n2) {
            JCChart jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + n2 + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public void writeParam(String string, double d, double d2) {
        if (d != d2) {
            JCChart jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + d2 + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public void writeParam(String string, Insets insets, Insets insets2) {
        if (insets == null || insets2 == null) {
            return;
        }
        if (insets.top != insets2.top || insets.bottom != insets2.bottom || insets.right != insets2.right || insets.left != insets2.left) {
            JCChart jCChart = this.chart;
            synchronized (jCChart) {
                try {
                    this.outputParamStream.writeBytes("<PARAM NAME=" + string + " VALUE=\"" + JCUtilConverter.fromInsets(insets2) + "\">\n");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
    }

    public void writeParam(String string, JCAxis jCAxis, JCAxis jCAxis2) {
        String string2;
        if (jCAxis2 == null) {
            return;
        }
        JCChartConverter jCChartConverter = new JCChartConverter();
        if (jCAxis == null && jCAxis2 != null) {
            string2 = jCChartConverter.toAxisName(this.chart, jCAxis2.getName(), "xaxis");
            this.writeParam(string, string2);
        }
        if (jCAxis != null && jCAxis2 != null) {
            string2 = jCChartConverter.toAxisName(this.chart, jCAxis.getName(), "xaxis");
            String string3 = jCChartConverter.toAxisName(this.chart, jCAxis2.getName(), "xaxis");
            this.writeParam(string, string2, string3);
        }
    }

    void initSaveParams(String string) {
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                this.outputParamStream.writeBytes("<HTML>\n");
                this.outputParamStream.writeBytes("<HEAD>\n");
                this.outputParamStream.writeBytes("<TITLE>" + string + "</TITLE>\n");
                this.outputParamStream.writeBytes("</HEAD>\n");
                this.outputParamStream.writeBytes("<BODY>\n");
                this.outputParamStream.writeBytes("<CENTER><H2>" + string + "</H2></CENTER>\n");
                this.outputParamStream.writeBytes("<APPLET CODE=jclass/chart/JCChartApplet.class CODEBASE=\"../../..\" HEIGHT=" + this.chart.size().height + " WIDTH=" + this.chart.size().width + ">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    void closeSaveParams() {
        JCChart jCChart = this.chart;
        synchronized (jCChart) {
            try {
                this.outputParamStream.writeBytes("</APPLET>\n");
                this.outputParamStream.writeBytes("</BODY>\n");
                this.outputParamStream.writeBytes("</HTML>\n");
                this.outputParamStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public void saveParams(String string) {
        JCChart jCChart = new JCChart();
        this.chart.indexHashtable = new Hashtable();
        this.chart.dataviewHashtable = new Hashtable();
        OutputStream outputStream = this.getSaveParamStream();
        this.setSaveParamStream(outputStream);
        this.initSaveParams(string);
        this.writeParam("background", jCChart.getBackground(), this.chart.getBackground());
        this.writeParam("foreground", jCChart.getForeground(), this.chart.getForeground());
        this.writeParam("clipToScreen", jCChart.getClipToScreen(), this.chart.getClipToScreen());
        this.writeParam("font", jCChart.getFont(), this.chart.getFont());
        this.writeParam("doubleBuffer", jCChart.getDoubleBuffer(), this.chart.getDoubleBuffer());
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < this.chart.getNumTriggers()) {
            string3 = JCUtilConverter.fromEnum(this.chart.getTrigger(n).getModifiers(), JCChart.eventMod_strings, JCChart.eventMod_values);
            string2 = JCUtilConverter.fromEnum(this.chart.getTrigger(n).getAction(), JCChart.eventAction_strings, JCChart.eventAction_values);
            this.writeParam(String.valueOf(string2) + "Trigger", string3);
            ++n;
        }
        this.writeParam("resetKey", jCChart.getResetKey(), this.chart.getResetKey());
        this.writeParam("cancelKey", jCChart.getCancelKey(), this.chart.getCancelKey());
        this.writeParam("borderType", JCUtilConverter.fromEnum(jCChart.getBorderType(), ChartRegion.border_strings, ChartRegion.border_values), JCUtilConverter.fromEnum(this.chart.getBorderType(), ChartRegion.border_strings, ChartRegion.border_values));
        this.writeParam("borderWidth", jCChart.getBorderWidth(), this.chart.getBorderWidth());
        this.writeParam("allowUserChanges", jCChart.getAllowUserChanges(), this.chart.getAllowUserChanges());
        this.writeParam("leftMargin", jCChart.getLeftMargin(), this.chart.getLeftMargin());
        this.writeParam("rightMargin", jCChart.getRightMargin(), this.chart.getRightMargin());
        this.writeParam("topMargin", jCChart.getTopMargin(), this.chart.getTopMargin());
        this.writeParam("bottomMargin", jCChart.getBottomMargin(), this.chart.getBottomMargin());
        this.writeParam("offset", jCChart.getOffset(), this.chart.getOffset());
        this.chart.getFooter().saveParams("footer", this);
        this.chart.getHeader().saveParams("header", this);
        this.chart.getLegend().saveParams("legend", this);
        this.chart.getChartArea().saveParams("chartArea", this);
        this.writeParam("isBatched", jCChart.getIsBatched(), this.chart.getIsBatched());
        ChartDataView chartDataView = this.chart.getDataView(0);
        if (chartDataView != null) {
            this.chart.dataviewHashtable.put(chartDataView.getName(), "data");
            chartDataView.saveParams("data", this);
        }
        int n2 = 1;
        while (n2 < this.chart.getNumData()) {
            this.chart.dataviewHashtable.put(this.chart.getDataView(n2).getName(), "data" + n2);
            this.writeParam("dataName" + n2, "data" + n2);
            this.chart.getDataView(n2).saveParams("data" + n2, this);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.chart.labels.size()) {
            this.writeParam("labelName" + (n3 + 1), "label" + (n3 + 1));
            this.chart.getChartLabels(n3).saveParams("label" + (n3 + 1), this);
            ++n3;
        }
        this.closeSaveParams();
    }
}

