/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jclass.base.BaseComponent;
import jclass.base.TransientComponent;
import jclass.chart.Changeable;
import jclass.chart.ChartDataEvent;
import jclass.chart.ChartDataListener;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartFrame;
import jclass.chart.ChartRegion;
import jclass.chart.ChartText;
import jclass.chart.Chartable;
import jclass.chart.Encode;
import jclass.chart.EncoderException;
import jclass.chart.ErrorDialog;
import jclass.chart.EventTrigger;
import jclass.chart.GifEncoderException;
import jclass.chart.JCAboutBox;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartEvent;
import jclass.chart.JCChartHTMLSave;
import jclass.chart.JCChartLabel;
import jclass.chart.JCChartListener;
import jclass.chart.JCChartUtil;
import jclass.chart.JCCustomizerPage;
import jclass.chart.JCDataIndex;
import jclass.chart.JCGridLegend;
import jclass.chart.JCLegend;
import jclass.chart.JCPickEvent;
import jclass.chart.JCPickListener;
import jclass.chart.JCTitle;
import jclass.chart.JCValueLabel;
import jclass.chart.JCVersion;
import jclass.chart.PngEncoderException;
import jclass.chart.Timer;
import jclass.chart.TimerListener;
import jclass.util.JCConverter;
import jclass.util.JCEnvironment;
import jclass.util.JCFile;
import jclass.util.JCRectList;
import jclass.util.JCRectUtil;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class JCChart
extends TransientComponent
implements Changeable,
Serializable,
KeyListener,
MouseListener,
MouseMotionListener,
TimerListener,
ChartDataListener {
    protected JCChartArea chartArea;
    protected JCLegend legend;
    protected JCTitle footer;
    protected JCTitle header;
    protected JCVector labels = new JCVector();
    protected JCVector data = new JCVector();
    protected JCVector dwellLabels;
    protected JCChartLabel currentDwellLabel;
    protected Insets margins;
    protected JCVector triggers = new JCVector();
    protected JCVector listeners = new JCVector();
    protected JCVector pickListeners = new JCVector();
    private boolean isWarningOn = true;
    private boolean isBatched = false;
    private boolean doubleBuffer = true;
    private boolean allowUserChanges = false;
    private int dwellPointerX;
    private int dwellPointerY;
    private Timer timer;
    public static final int NONE = -1;
    public static final int PLOT = 0;
    public static final int SCATTER_PLOT = 1;
    public static final int POLAR = 2;
    public static final int RADAR = 3;
    public static final int FILLED_RADAR = 4;
    public static final int HILO = 5;
    public static final int HILO_OPEN_CLOSE = 6;
    public static final int CANDLE = 7;
    public static final int AREA = 8;
    public static final int BAR = 9;
    public static final int STACKING_BAR = 10;
    public static final int PIE = 11;
    public static final int STACKING_AREA = 12;
    public static final String ENCODE_GIF = "jclass.chart.EncodeGif";
    public static final String ENCODE_PNG = "jclass.chart.EncodePng";
    protected Hashtable dataviewHashtable;
    protected Hashtable indexHashtable;
    protected String customizerName = "jclass.chart.customizer.swing.ChartCustomizer";
    public static final String[] eventMod_strings = new String[]{"None", "Ctrl", "Shift", "Alt", "Meta"};
    public static final int[] eventMod_values = new int[]{EventTrigger.adjustModifier(0), EventTrigger.adjustModifier(2), EventTrigger.adjustModifier(1), EventTrigger.adjustModifier(8), EventTrigger.adjustModifier(4)};
    public static final String[] eventAction_strings = new String[]{"Rotate", "Zoom", "Translate", "Edit", "Pick", "Depth", "Customize"};
    public static final int[] eventAction_values;
    protected int lineColorIndex;
    protected int symbolColorIndex;
    protected int fillColorIndex;
    protected int symbolShapeIndex;
    private Dimension prefSize = new Dimension(-1, -1);
    private Dimension curSize = new Dimension(-1, -1);
    private int offset = 5;
    protected int resetKey = 114;
    protected int cancelKey = 99;
    private boolean changed = false;
    private String url;
    transient JCCustomizerPage customizer;
    int lastx;
    int lasty;
    private static JCConverter conv;
    private JCChartHTMLSave save;

    private void init() {
        this.highlight = 0;
        this.margins = this.getInsets();
        this.margins.top = 1;
        this.margins.left = 1;
        this.margins.bottom = 1;
        this.margins.right = 1;
        this.header = new JCTitle();
        this.header.setParent(this);
        this.chartArea = new JCChartArea();
        this.chartArea.setParent(this);
        this.footer = new JCTitle();
        this.footer.setParent(this);
        this.legend = new JCGridLegend();
        this.legend.setParent(this);
        this.resetDefaults();
        this.addDataView(0);
        this.setBorderWidth(0);
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        this.mouseDown(event, event.x, event.y);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        this.mouseUp(event, event.x, event.y);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        this.mouseExit(event, event.x, event.y);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        this.mouseDrag(event, event.x, event.y);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX() + mouseEvent.getComponent().location().x, mouseEvent.getY() + mouseEvent.getComponent().location().y, 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        this.mouseMove(event, event.x, event.y);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Event event = new Event(this, keyEvent.getWhen(), keyEvent.getID(), keyEvent.getComponent().location().x, keyEvent.getComponent().location().y, 0, keyEvent.getModifiers());
        this.keyDown(event, keyEvent.getKeyChar());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    protected void launchPropertyPage(Point point) {
        if (!this.allowUserChanges) {
            return;
        }
        if (this.customizer == null) {
            this.setCursor(3);
            try {
                Class<?> clazz = Class.forName(this.getCustomizerName());
                JCCustomizerPage jCCustomizerPage = (JCCustomizerPage)clazz.newInstance();
                jCCustomizerPage.init();
                this.customizer = jCCustomizerPage;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                this.customizer = null;
                ErrorDialog.raise(this, String.valueOf(JCChartBundle.string("jclass.chart.Key20")) + "\n" + exception);
            }
            this.setCursor(0);
        }
        if (this.customizer != null) {
            this.customizer.setObject(this);
            this.customizer.launch();
        }
    }

    public JCChart(int n) {
        this.init();
        ((ChartDataView)this.data.elementAt(0)).setChartType(n);
    }

    public JCChart() {
        try {
            this.init();
            ((ChartDataView)this.data.elementAt(0)).setChartType(0);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    public JCChart(Applet applet, String string) {
        super(applet, string);
        this.init();
        ((ChartDataView)this.data.elementAt(0)).setChartType(0);
        if (this.getClass().getName().equals("jclass.chart.JCChart") && this.getAppletContext() != null) {
            this.loadParams();
        }
    }

    public static JCChart makeChart(String string) {
        JCChart jCChart = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            jCChart = (JCChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            jCChart = null;
        }
        return jCChart;
    }

    public Applet getApplet() {
        return this.applet;
    }

    String getParam(String string) {
        return JCChart.getConverter().getParam(this.applet, this, this.getName(), string);
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n) {
        return this.getChanged(n);
    }

    public boolean getChanged() {
        return this.chartArea.isChanged() || this.legend.isChanged() || this.header.isChanged() || this.footer.isChanged();
    }

    public boolean getChanged(int n) {
        return this.chartArea.isChanged(n) || this.legend.isChanged(n) || this.header.isChanged(n) || this.footer.isChanged(n);
    }

    public void recalc() {
        if (!this.isChanged(2)) {
            return;
        }
        try {
            this.chartArea.recalc();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        this.setChanged(false, 0);
    }

    public void setChanged(boolean bl, int n) {
        if (bl == this.changed) {
            return;
        }
        this.changed = bl;
        if (this.changed) {
            int n2 = 0;
            if ((n & 0x20) > 0) {
                n2 |= 2;
            }
            if ((n & 0x10) > 0) {
                n2 |= 1;
            }
            if (n2 != 0) {
                this.legend.setChanged(true, n2, false);
            }
            int n3 = 0;
            if ((n & 4) > 0) {
                n3 |= 2;
            }
            if ((n & 0x200) > 0) {
                n3 |= 2;
            }
            if ((n & 0x100) > 0) {
                n3 |= 1;
            }
            if (n3 != 0) {
                this.chartArea.setChanged(true, n3, false);
            }
            if (this.getIsBatched()) {
                this.invalidate();
                return;
            }
            if ((n & 2) > 0 || (n & 4) > 0) {
                this.update();
                return;
            }
            if ((n & 1) > 0) {
                this.repaint();
            }
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n);
            return;
        }
        this.changed = bl;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).paintChart(this);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.paintComponent(graphics);
        graphics = graphics.create();
        Rectangle rectangle = this.getDrawingArea();
        graphics.translate(rectangle.x, rectangle.y);
        this.chartArea.draw(graphics);
        this.header.draw(graphics);
        this.footer.draw(graphics);
        this.legend.draw(graphics);
        this.recalcChangedChartLabels();
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null || !jCChartLabel.getIsShowing()) continue;
            jCChartLabel.draw(graphics);
        }
        graphics.dispose();
        this.setChanged(false, 0);
    }

    public void printAll(Graphics graphics) {
        super.printAll(graphics);
    }

    public void layout() {
        try {
            this.performLayout();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    private void performLayout() {
        Dimension dimension = new Dimension();
        dimension.width = this.getDrawingAreaWidth() - this.margins.left - this.margins.right;
        dimension.height = this.getDrawingAreaHeight() - this.margins.top - this.margins.bottom;
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        if (!(this.chartArea.isChanged(8) || dimension.width != this.curSize.width || dimension.height != this.curSize.height || this.legend.isChanged(2) || this.legend.isChanged(8) || this.header.isChanged(2) || this.header.isChanged(8) || this.footer.isChanged(2) || this.footer.isChanged(8))) {
            if (this.chartArea.isChanged(2)) {
                this.recalc();
            }
            this.repaint();
            return;
        }
        this.recalc();
        this.markAllChartLabelsForRecalc();
        this.curSize = dimension;
        Dimension dimension2 = this.header.preferredSize();
        Dimension dimension3 = this.footer.preferredSize();
        Dimension dimension4 = this.legend.preferredSize();
        Dimension dimension5 = new Dimension(this.chartArea.getWidth(), this.chartArea.getHeight());
        Point point = new Point(this.chartArea.getLeft() - this.margins.left, this.chartArea.getTop() - this.margins.top);
        Point point2 = new Point(this.legend.getLeft() - this.margins.left, this.legend.getTop() - this.margins.top);
        Point point3 = new Point(this.header.getLeft() - this.margins.left, this.header.getTop() - this.margins.top);
        Point point4 = new Point(this.footer.getLeft() - this.margins.left, this.footer.getTop() - this.margins.top);
        int n = dimension.width / 30;
        int n2 = dimension.height / 30;
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        int n3 = this.legend.getAnchor();
        if (this.legend.getTopIsDefault()) {
            block0 : switch (n3 & 0xF0) {
                case 16: {
                    switch (n3 & 0xF) {
                        case 1: 
                        case 2: {
                            point2.y = rectangle.y + n2;
                            break block0;
                        }
                    }
                    if (this.header.isShowing) {
                        point2.y = rectangle.y + 2 * n2 + dimension2.height;
                        break;
                    }
                    point2.y = rectangle.y + n2;
                    break;
                }
                case 32: {
                    switch (n3 & 0xF) {
                        case 1: 
                        case 2: {
                            point2.y = rectangle.y + rectangle.height - n2 - dimension4.height;
                            break block0;
                        }
                    }
                    if (this.footer.isShowing) {
                        point2.y = rectangle.y + rectangle.height - 2 * n2 - (dimension4.height + dimension3.height);
                        break;
                    }
                    point2.y = rectangle.y + rectangle.height - n2 - dimension4.height;
                    break;
                }
                default: {
                    point2.y = (rectangle.height - dimension4.height) / 2;
                }
            }
            point2.y = JCChartUtil.clamp(point2.y, 0, rectangle.height);
        }
        if (this.legend.getLeftIsDefault()) {
            switch (n3 & 0xF) {
                case 1: {
                    point2.x = rectangle.x + rectangle.width - n - dimension4.width;
                    break;
                }
                case 2: {
                    point2.x = rectangle.x + n;
                    break;
                }
                default: {
                    point2.x = (rectangle.width - dimension4.width) / 2;
                }
            }
            point2.x = JCChartUtil.clamp(point2.x, 0, rectangle.width);
        }
        Rectangle rectangle2 = new Rectangle(point3, dimension2);
        if (this.header.getLeftIsDefault()) {
            rectangle2.x = (rectangle.width - rectangle2.width) / 2;
            rectangle2.x = JCChartUtil.clamp(rectangle2.x, 0, rectangle.width);
        }
        if (this.header.getTopIsDefault()) {
            rectangle2.y = rectangle.y + n2;
            rectangle2.y = JCChartUtil.clamp(rectangle2.y, 0, rectangle.height);
        }
        Rectangle rectangle3 = new Rectangle(point4, dimension3);
        if (this.footer.getLeftIsDefault()) {
            rectangle3.x = (rectangle.width - rectangle3.width) / 2;
            rectangle3.x = JCChartUtil.clamp(rectangle3.x, 0, rectangle.width);
        }
        if (this.footer.getTopIsDefault()) {
            rectangle3.y = rectangle.y + rectangle.height - rectangle3.height - n2;
            rectangle3.y = JCChartUtil.clamp(rectangle3.y, 0, rectangle.height);
        }
        Rectangle rectangle4 = new Rectangle(point, dimension5);
        if (this.chartArea.getLeftIsDefault() || this.chartArea.getTopIsDefault() || this.chartArea.getWidthIsDefault() || this.chartArea.getHeightIsDefault()) {
            Rectangle rectangle5;
            JCRectList jCRectList = new JCRectList();
            JCRectUtil.rl_init(rectangle, jCRectList);
            if (this.legend.isShowing) {
                JCRectUtil.rl_remove(new Rectangle(point2, dimension4), jCRectList, jCRectList);
            }
            if (this.header.isShowing) {
                rectangle5 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (this.header.getLeftIsDefault()) {
                    rectangle5.x = 0;
                    rectangle5.width = rectangle.width;
                }
                JCRectUtil.rl_remove(rectangle5, jCRectList, jCRectList);
            }
            if (this.footer.isShowing) {
                rectangle5 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                if (this.footer.getLeftIsDefault()) {
                    rectangle5.x = 0;
                    rectangle5.width = rectangle.width;
                }
                JCRectUtil.rl_remove(rectangle5, jCRectList, jCRectList);
            }
            Rectangle rectangle6 = jCRectList.head != null ? JCRectUtil.largest_rect(jCRectList) : new Rectangle(0, 0, 0, 0);
            int n4 = rectangle6.width / 40;
            int n5 = rectangle6.height / 40;
            dimension5.width = rectangle6.width;
            if (rectangle6.x == rectangle.x) {
                point.x = rectangle6.x + n;
                dimension5.width -= n;
            } else {
                point.x = rectangle6.x + n4;
                dimension5.width -= n4;
            }
            dimension5.width = rectangle6.x + rectangle6.width == rectangle.x + rectangle.width ? (dimension5.width -= n) : (dimension5.width -= n4);
            dimension5.height = rectangle6.height;
            if (rectangle6.y == rectangle.y) {
                point.y = rectangle6.y + n2;
                dimension5.height -= n2;
            } else {
                point.y = rectangle6.y + n5;
                dimension5.height -= n5;
            }
            dimension5.height = rectangle6.y + rectangle6.height == rectangle.y + rectangle.height ? (dimension5.height -= n2) : (dimension5.height -= n5);
        }
        if (!this.chartArea.getLeftIsDefault()) {
            if (this.chartArea.getWidthIsDefault()) {
                dimension5.width -= rectangle4.x - point.x;
                dimension5.width = Math.max(0, dimension5.width);
            }
            point.x = rectangle4.x;
        }
        if (!this.chartArea.getTopIsDefault()) {
            if (this.chartArea.getHeightIsDefault()) {
                dimension5.height -= rectangle4.y - point.y;
                dimension5.height = Math.max(0, dimension5.height);
            }
            point.y = rectangle4.y;
        }
        if (!this.chartArea.getHeightIsDefault()) {
            dimension5.height = rectangle4.height;
        }
        if (!this.chartArea.getWidthIsDefault()) {
            dimension5.width = rectangle4.width;
        }
        if (dimension5.width > Integer.MAX_VALUE) {
            dimension5.width = 0;
        }
        if (dimension5.height > Integer.MAX_VALUE) {
            dimension5.height = 0;
        }
        if (this.header.getLeftIsDefault()) {
            point3.x = point.x + (dimension5.width - rectangle2.width) / 2;
            point3.x = Math.max(0, point3.x);
        }
        if (this.header.getTopIsDefault()) {
            point3.y = rectangle2.y;
        }
        if (this.footer.getLeftIsDefault()) {
            point4.x = point.x + (dimension5.width - rectangle3.width) / 2;
            point4.x = Math.max(0, point4.x);
        }
        if (this.footer.getTopIsDefault()) {
            point4.y = rectangle3.y;
        }
        this.legend.reshape(point2.x + this.margins.left, point2.y + this.margins.top, dimension4.width, dimension4.height);
        this.header.reshape(point3.x + this.margins.left, point3.y + this.margins.top, dimension2.width, dimension2.height);
        this.footer.reshape(point4.x + this.margins.left, point4.y + this.margins.top, dimension3.width, dimension3.height);
        this.chartArea.reshape(point.x + this.margins.left, point.y + this.margins.top, dimension5.width, dimension5.height);
        this.repaint();
    }

    public Dimension preferredSize() {
        try {
            super.preferredSize();
            this.recalc();
            if (this.pref_width != -999 && this.pref_height != -999) {
                this.prefSize = super.preferredSize();
                return this.prefSize;
            }
            if (this.prefSize.width >= 0 && this.prefSize.height >= 0) {
                return this.prefSize;
            }
            this.prefSize = this.chartArea.preferredSize();
            if (this.header.getIsShowing()) {
                this.prefSize.width = Math.max(this.header.preferredSize().width, this.prefSize.width);
                this.prefSize.height += this.header.preferredSize().height + this.offset;
            }
            if (this.footer.getIsShowing()) {
                this.prefSize.width = Math.max(this.footer.preferredSize().width, this.prefSize.width);
                this.prefSize.height += this.footer.preferredSize().height + this.offset;
            }
            Dimension dimension = this.legend.preferredSize();
            if (this.legend.getIsShowing()) {
                int n = this.legend.anchor;
                switch (n) {
                    case 17: 
                    case 18: 
                    case 33: 
                    case 34: {
                        this.prefSize.width += dimension.width + this.offset;
                        this.prefSize.height += dimension.height + this.offset;
                        break;
                    }
                    case 16: 
                    case 32: {
                        this.prefSize.width = Math.max(this.prefSize.width, dimension.width);
                        this.prefSize.height += dimension.height + this.offset;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.prefSize.width += dimension.width + this.offset;
                        this.prefSize.height = Math.max(this.prefSize.height, dimension.height);
                        break;
                    }
                }
            }
            this.prefSize.width += this.margins.left + this.margins.right;
            this.prefSize.height += this.margins.top + this.margins.bottom;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return this.prefSize;
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void setIsBatched(boolean bl) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            if (this.isBatched == bl) {
                Object var3_3 = null;
                return;
            }
            this.isBatched = bl;
        }
        if (!bl) {
            this.update();
        }
    }

    public boolean getIsBatched() {
        return this.isBatched;
    }

    public void update() {
        this.invalidate();
        if (this.getPeer() == null) {
            return;
        }
        this.validate();
    }

    public void addNotify() {
        super.addNotify();
        if (JCEnvironment.getJavaVersion() >= 110 || JCEnvironment.isJavaOS()) {
            this.layout();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setChanged(true, 514);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 514);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setChanged(true, 546);
    }

    public void setAllowUserChanges(boolean bl) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.allowUserChanges = bl;
            return;
        }
    }

    public boolean getAllowUserChanges() {
        return this.allowUserChanges;
    }

    public void setWarningDialog(boolean bl) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            if (this.isWarningOn == bl) {
                Object var3_3 = null;
                return;
            }
            this.isWarningOn = bl;
            return;
        }
    }

    public boolean getWarningDialog() {
        return this.isWarningOn;
    }

    public JCTitle getHeader() {
        return this.header;
    }

    public void setHeader(JCTitle jCTitle) {
        if (jCTitle == null) {
            return;
        }
        this.header = jCTitle;
        this.header.setParent(this);
        this.setChanged(true, 548);
    }

    public JCTitle getFooter() {
        return this.footer;
    }

    public void setFooter(JCTitle jCTitle) {
        if (jCTitle == null) {
            return;
        }
        this.footer = jCTitle;
        this.footer.setParent(this);
        this.setChanged(true, 548);
    }

    public JCLegend getLegend() {
        return this.legend;
    }

    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
        this.legend = jCLegend;
        this.legend.setParent(this);
        this.setChanged(true, 548);
    }

    public JCChartArea getChartArea() {
        return this.chartArea;
    }

    public void setChartArea(JCChartArea jCChartArea) {
        if (jCChartArea == null) {
            return;
        }
    }

    public ChartDataView getDataView(int n) {
        ChartDataView chartDataView = null;
        try {
            chartDataView = (ChartDataView)this.data.elementAt(n);
        }
        catch (Exception exception) {}
        return chartDataView;
    }

    public ChartDataView addDataView(int n) {
        ChartDataView chartDataView = new ChartDataView();
        chartDataView.setParent(this);
        this.setDataView(n, chartDataView);
        return chartDataView;
    }

    public void setDataView(int n, ChartDataView chartDataView) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            if (n < 0 || n > this.data.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key56"));
            }
            if (chartDataView != null) {
                chartDataView.setParent(this);
            }
            if (n < this.data.size()) {
                this.data.setElementAt(chartDataView, n);
            } else {
                this.data.insertElementAt(chartDataView, n);
            }
            this.reorderDataViews();
        }
        this.chartArea.clearDrawables();
        this.setChanged(true, 548);
    }

    public void setDataView(ChartDataView[] chartDataViewArray) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.data = new JCVector();
            if (chartDataViewArray == null) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < chartDataViewArray.length) {
                if (chartDataViewArray[n] != null) {
                    chartDataViewArray[n].setParent(this);
                }
                this.data.setElementAt(n, chartDataViewArray[n]);
                ++n;
            }
        }
        this.chartArea.clearDrawables();
        this.setChanged(true, 548);
    }

    public ChartDataView findDataView(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        int n = 0;
        while (n < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n);
            if (chartDataView.getName().equals(string)) {
                return chartDataView;
            }
            ++n;
        }
        return null;
    }

    public ChartDataView[] getDataView() {
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        ChartDataView[] chartDataViewArray = new ChartDataView[this.data.size()];
        int n = 0;
        while (n < chartDataViewArray.length) {
            chartDataViewArray[n] = (ChartDataView)this.data.elementAt(n);
            ++n;
        }
        return chartDataViewArray;
    }

    public void removeDataView(int n) {
        try {
            this.chartArea.removeDrawable((ChartDataView)this.data.elementAt(n));
            this.data.removeElementAt(n);
            this.reorderDataViews();
            this.setChanged(true, 548);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getNumData() {
        int n = 0;
        try {
            if (this.data != null) {
                n = this.data.size();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public EventTrigger getTrigger(int n) {
        EventTrigger eventTrigger = null;
        try {
            eventTrigger = (EventTrigger)this.triggers.elementAt(n);
        }
        catch (Exception exception) {}
        return eventTrigger;
    }

    public int getNumTriggers() {
        int n = 0;
        try {
            if (this.triggers != null) {
                n = this.triggers.size();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public EventTrigger addTrigger() {
        EventTrigger eventTrigger = null;
        try {
            EventTrigger eventTrigger2 = new EventTrigger();
            this.triggers.addElement(eventTrigger2);
            eventTrigger = eventTrigger2;
        }
        catch (Exception exception) {}
        return eventTrigger;
    }

    public void setTrigger(int n, EventTrigger eventTrigger) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            if (this.triggers == null) {
                Object var4_4 = null;
                return;
            }
            if (eventTrigger == null) {
                if (n < 0 || n >= this.triggers.size()) {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key61"));
                }
                this.removeTrigger(n);
            } else {
                if (n < 0 || n > this.triggers.size()) {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key61"));
                }
                this.triggers.insertElementAt(eventTrigger, n);
            }
            return;
        }
    }

    public void removeTrigger(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            try {
                this.triggers.removeElementAt(n);
            }
            catch (Exception exception) {}
            return;
        }
    }

    EventTrigger findMatchingTrigger(int n) {
        n = EventTrigger.adjustModifier(n);
        if (this.triggers == null) {
            return null;
        }
        EventTrigger eventTrigger = null;
        int n2 = 0;
        while (n2 < this.triggers.size()) {
            EventTrigger eventTrigger2 = (EventTrigger)this.triggers.elementAt(n2);
            if (eventTrigger2.modifiers == n) {
                eventTrigger = eventTrigger2;
                break;
            }
            ++n2;
        }
        return eventTrigger;
    }

    public void setResetKey(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.resetKey = n;
            return;
        }
    }

    public int getResetKey() {
        return this.resetKey;
    }

    public void setCancelKey(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.cancelKey = n;
            return;
        }
    }

    public int getCancelKey() {
        return this.cancelKey;
    }

    public void rotateStart() {
    }

    public void rotate() {
    }

    public void rotateEnd() {
    }

    public void zoom(double d, double d2, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        double d3 = JCChartUtil.calcError(jCAxis.precision.value);
        double d4 = 0.0;
        d4 = jCAxis.isLogarithmic ? Math.abs(JCChartUtil.log10(d) - JCChartUtil.log10(d2)) : Math.abs(d - d2);
        if (d4 < d3) {
            return;
        }
        if (d > d2) {
            double d5 = d;
            d = d2;
            d2 = d5;
        }
        jCAxis.min.value = d;
        jCAxis.min.isDefault = false;
        jCAxis.max.value = d2;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, 2, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    public void scale(double d, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.value /= d;
        jCAxis.min.isDefault = false;
        jCAxis.max.value /= d;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, 2, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    public void translateStart(JCAxis jCAxis) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.isDefault = false;
        jCAxis.max.isDefault = false;
        this.sendEvent(jCAxis);
        jCAxis.setChanged(true, 2, false);
    }

    public void translate(double d, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.translate(d);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    public void reset() {
        this.chartArea.reset();
    }

    public void cancel() {
        this.chartArea.cancel();
    }

    synchronized void reorderDataViews() {
        int n = 0;
        while (n < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n);
            chartDataView.drawingOrder = n++;
        }
    }

    public Insets insets() {
        return this.margins;
    }

    public void setTopMargin(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.margins.top = n;
        }
        this.setChanged(true, 4);
    }

    public int getTopMargin() {
        return this.margins.top;
    }

    public void setLeftMargin(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.margins.left = n;
        }
        this.setChanged(true, 4);
    }

    public int getLeftMargin() {
        return this.margins.left;
    }

    public void setRightMargin(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.margins.right = n;
        }
        this.setChanged(true, 4);
    }

    public int getRightMargin() {
        return this.margins.right;
    }

    public void setBottomMargin(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.margins.bottom = n;
        }
        this.setChanged(true, 4);
    }

    public int getBottomMargin() {
        return this.margins.bottom;
    }

    int getOffset() {
        return this.offset;
    }

    void setOffset(int n) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.offset = n;
        }
        this.setChanged(true, 4);
    }

    public String getAbout() {
        return JCChartBundle.string("jclass.chart.Key88");
    }

    public void setAbout(String string) {
    }

    public String getVersion() {
        return JCVersion.getVersionString();
    }

    public void setVersion(String string) {
    }

    public void setBorderType(int n) {
        this.setBorderStyle(n);
        this.setChanged(true, 1);
    }

    public int getBorderType() {
        return this.getBorderStyle();
    }

    public void setBorderWidth(int n) {
        this.border = n;
        this.setBorderThickness(n);
        this.setChanged(true, 514);
    }

    public int getBorderWidth() {
        return this.border;
    }

    ChartDataView findData(JCAxis jCAxis) {
        if (jCAxis == null) {
            return null;
        }
        int n = 0;
        while (n < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n);
            if ((chartDataView.xaxis == jCAxis || chartDataView.yaxis == jCAxis) && chartDataView.getIsShowing()) {
                return chartDataView;
            }
            ++n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JCDataIndex pick(Point point, ChartDataView chartDataView) {
        Object object = this.getAWTLock();
        synchronized (object) {
            Point point2 = new Point(point.x, point.y);
            Rectangle rectangle = this.getDrawingArea();
            point2.x -= rectangle.x;
            point2.y -= rectangle.y;
            ChartRegion chartRegion = this.locateChartRegion(point2.x, point2.y);
            if (chartRegion == null) {
                return null;
            }
            if (chartRegion instanceof JCTitle) {
                JCDataIndex jCDataIndex = new JCDataIndex(-1, null, -1);
                jCDataIndex.obj = chartRegion;
                return jCDataIndex;
            }
            if (chartRegion instanceof JCLegend) {
                return this.legend.pick(point2, chartDataView);
            }
            if (!(chartRegion instanceof JCChartArea)) return null;
            return this.chartArea.pick(point2, chartDataView, -1);
        }
    }

    public Point unpick(ChartDataView chartDataView, int n, int n2) {
        if (n2 == -1) {
            return null;
        }
        Object object = this.getAWTLock();
        synchronized (object) {
            Serializable serializable;
            if (n2 >= 0) {
                serializable = chartDataView.getSeries(n2);
                int n3 = serializable.getFirstPoint();
                int n4 = serializable.getLastPoint();
                if (n < n3 || n > n4) {
                    Point point = null;
                    Object var6_12 = null;
                    return point;
                }
            }
            if ((serializable = this.chartArea.getDrawable(chartDataView).unpick(n, n2)) != null) {
                Rectangle rectangle = this.chartArea.getDrawingArea();
                ((Point)serializable).x += rectangle.x;
                ((Point)serializable).y += rectangle.y;
                Rectangle rectangle2 = this.getDrawingArea();
                ((Point)serializable).x += rectangle2.x;
                ((Point)serializable).y += rectangle2.y;
            }
            Serializable serializable2 = serializable;
            Object var6_13 = null;
            return serializable2;
        }
    }

    public Point unpick(int n, ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return null;
        }
        return this.unpick(chartDataViewSeries.parent, n, chartDataViewSeries.parent.getSeriesIndex(chartDataViewSeries));
    }

    public void addChartListener(JCChartListener jCChartListener) {
        this.listeners.addElement(jCChartListener);
    }

    public void removeChartListener(JCChartListener jCChartListener) {
        this.listeners.removeElement(jCChartListener);
    }

    void sendEvent(JCAxis jCAxis) {
        JCChartEvent jCChartEvent = new JCChartEvent(this, jCAxis);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).changeChart(jCChartEvent);
        }
    }

    public void addPickListener(JCPickListener jCPickListener) {
        this.pickListeners.addElement(jCPickListener);
    }

    public void removePickListener(JCPickListener jCPickListener) {
        this.pickListeners.removeElement(jCPickListener);
    }

    private void sendPickEvent(JCDataIndex jCDataIndex) {
        JCPickEvent jCPickEvent = new JCPickEvent(this, jCDataIndex);
        Enumeration enumeration = this.pickListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JCPickListener)enumeration.nextElement()).pick(jCPickEvent);
        }
    }

    public boolean isNetscape() {
        String string = System.getProperty("browser");
        if (string == null) {
            return true;
        }
        return string.equalsIgnoreCase("Netscape Navigator");
    }

    public boolean mouseUp(Event event, int n, int n2) {
        Applet applet = this.getApplet();
        try {
            if (this.url != null && applet != null && JCString.showURL(this.url, applet.getAppletContext(), applet)) {
                return true;
            }
        }
        catch (Exception exception) {}
        if (this.chartArea.handler != null) {
            Rectangle rectangle = this.getDrawingArea();
            this.chartArea.endAction(n - rectangle.x, n2 - rectangle.y);
        }
        return super.mouseUp(event, n, n2);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        EventTrigger eventTrigger;
        if (this.url != null) {
            return false;
        }
        if (!event.metaDown() && (event.modifiers & 8) == 0 && this.isFocusTraversable()) {
            this.requestFocus();
        }
        if ((eventTrigger = this.findMatchingTrigger(event.modifiers)) != null) {
            if (!(this.allowUserChanges || eventTrigger.action != 3 && eventTrigger.action != 6)) {
                return false;
            }
            if (eventTrigger.action == 4) {
                this.sendPickEvent(this.pick(new Point(n, n2), null));
            } else if (eventTrigger.action == 6) {
                this.launchPropertyPage(new Point(n, n2));
            } else if (this.locateChartRegion(n, n2) == this.chartArea) {
                Rectangle rectangle = this.getDrawingArea();
                this.chartArea.startAction(eventTrigger, n - rectangle.x, n2 - rectangle.y);
            }
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.chartArea.handler == null) {
            return super.mouseDrag(event, n, n2);
        }
        Rectangle rectangle = this.getDrawingArea();
        this.chartArea.showAction(n - rectangle.x, n2 - rectangle.y);
        return super.mouseDrag(event, n, n2);
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.dwellLabels != null && this.dwellLabels.size() != 0) {
            Changeable changeable;
            Enumeration enumeration = this.dwellLabels.elements();
            while (enumeration.hasMoreElements()) {
                changeable = (JCChartLabel)enumeration.nextElement();
                if (changeable == null) continue;
                ((ChartRegion)changeable).hide();
            }
            changeable = this;
            synchronized (changeable) {
                this.currentDwellLabel = null;
            }
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        if (n == 97) {
            JCAboutBox jCAboutBox = new JCAboutBox(BaseComponent.getFrame(this), BaseComponent.getApplet(this));
            jCAboutBox.show();
            return true;
        }
        if (n == this.resetKey) {
            this.reset();
            return true;
        }
        if (n == this.cancelKey) {
            this.cancel();
            return true;
        }
        return super.keyDown(event, n);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.isFocusTraversable()) {
            this.handleEvent(new Event(this, 1004, null));
        }
    }

    public ChartRegion locateChartRegion(int n, int n2) {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null || !jCChartLabel.getIsShowing() || !jCChartLabel.inside(n, n2)) continue;
            return jCChartLabel;
        }
        if (this.legend.getIsShowing() && this.legend.inside(n, n2)) {
            return this.legend;
        }
        if (this.header.getIsShowing() && this.header.inside(n, n2)) {
            return this.header;
        }
        if (this.footer.getIsShowing() && this.footer.inside(n, n2)) {
            return this.footer;
        }
        if (this.chartArea.getIsShowing() && this.chartArea.inside(n, n2)) {
            return this.chartArea;
        }
        return null;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        Object object;
        Object object2;
        ChartDataView[] chartDataViewArray;
        Object object3 = null;
        Rectangle rectangle = this.getDrawingArea();
        int n3 = n - rectangle.x;
        int n4 = n2 - rectangle.y;
        ChartRegion chartRegion = this.locateChartRegion(n3, n4);
        if (chartRegion == null) {
            if (this.url != null) {
                this.url = null;
                this.changeURLCursor();
            }
            return true;
        }
        if (n == this.lastx && n2 == this.lasty) {
            return true;
        }
        this.lastx = n;
        this.lasty = n2;
        if (chartRegion instanceof JCChartArea && this.dwellLabels != null && this.dwellLabels.size() != 0) {
            Object object4;
            Changeable changeable;
            chartDataViewArray = this.getDataView();
            object2 = new JCDataIndex[chartDataViewArray.length];
            int n5 = 0;
            while (n5 < chartDataViewArray.length) {
                object2[n5] = this.pick(new Point(n, n2), chartDataViewArray[n5]);
                ++n5;
            }
            object = null;
            int n6 = Integer.MAX_VALUE;
            Enumeration enumeration = this.dwellLabels.elements();
            while (enumeration.hasMoreElements()) {
                changeable = (JCChartLabel)enumeration.nextElement();
                if (changeable == null) continue;
                object4 = null;
                int n7 = 0;
                while (n7 < chartDataViewArray.length) {
                    if (((JCChartLabel)changeable).getDataView() == chartDataViewArray[n7]) {
                        object4 = object2[n7];
                        break;
                    }
                    ++n7;
                }
                if (object4 == null || !((JCChartLabel)changeable).shouldPopupHere((JCDataIndex)object4) || ((JCDataIndex)object4).getDistance() > n6) continue;
                object = changeable;
                n6 = ((JCDataIndex)object4).getDistance();
            }
            if (object != null && object != this.currentDwellLabel) {
                changeable = this;
                synchronized (changeable) {
                    if (this.currentDwellLabel != null) {
                        this.currentDwellLabel.hide();
                    }
                }
                int n8 = ((JCChartLabel)object).getDwellDelay();
                if (n8 <= 0) {
                    ((ChartRegion)object).show();
                } else {
                    if (this.timer == null) {
                        this.timer = new Timer(1000);
                        this.timer.addTimerListener(this);
                    }
                    this.timer.setTime(n8);
                    object4 = this;
                    synchronized (object4) {
                        this.currentDwellLabel = object;
                    }
                }
            }
            this.dwellPointerX = n;
            this.dwellPointerY = n2;
        }
        chartDataViewArray = new Point(n3, n4);
        if (chartRegion instanceof JCTitle) {
            ((JCTitle)chartRegion).getLabel();
            object3 = ((JCTitle)chartRegion).getLabel().getRealContents();
        } else if (chartRegion instanceof JCLegend) {
            ChartDataView chartDataView;
            object2 = this.legend.pick((Point)chartDataViewArray, null);
            if (object2 != null && (chartDataView = ((JCDataIndex)object2).getDataView()) != null) {
                object = ((JCDataIndex)object2).getSeries();
                object3 = object != null ? ((ChartDataViewSeries)object).getRealLabel() : (((JCDataIndex)object2).getSeriesIndex() == -10 ? chartDataView.getPieChartFormat().getRealOtherLabel() : chartDataView.getRealName());
            }
        } else if (chartRegion instanceof JCChartArea) {
            chartDataViewArray.x -= chartRegion.getDrawingArea().x;
            chartDataViewArray.y -= chartRegion.getDrawingArea().y;
            object3 = this.axisChartLabelHit(((JCChartArea)chartRegion).xaxes, (Point)chartDataViewArray);
            if (object3 == null) {
                object3 = this.axisChartLabelHit(((JCChartArea)chartRegion).yaxes, (Point)chartDataViewArray);
            }
        } else {
            if (this.url != null) {
                this.url = null;
                this.changeURLCursor();
            }
            return true;
        }
        this.checkURL(object3, (Point)chartDataViewArray);
        this.changeURLCursor();
        return true;
    }

    void checkURL(Object object, Point point) {
        if (object != null && object instanceof JCString) {
            this.url = JCString.getURL(this.getApplet(), object, point.x, point.y);
            return;
        }
        this.url = null;
    }

    void changeURLCursor() {
        Frame frame = this.getFrame();
        if (frame != null) {
            if (this.url != null) {
                frame.setCursor(12);
                return;
            }
            frame.setCursor(0);
        }
    }

    public void timerExpired(Timer timer) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            JCDataIndex jCDataIndex;
            ChartDataView chartDataView;
            if (this.currentDwellLabel != null && (chartDataView = this.currentDwellLabel.getDataView()) != null && (jCDataIndex = this.pick(new Point(this.dwellPointerX, this.dwellPointerY), chartDataView)) != null && jCDataIndex.equals(this.currentDwellLabel.getDataIndex())) {
                this.currentDwellLabel.recalc();
                this.currentDwellLabel.show();
            }
            return;
        }
    }

    public void chartDataChange(ChartDataEvent chartDataEvent) {
        ChartDataView[] chartDataViewArray = this.getDataView();
        Chartable chartable = (Chartable)chartDataEvent.getSource();
        int n = -1;
        int n2 = 0;
        while (n2 < chartDataViewArray.length) {
            if (chartDataViewArray[n2].getDataSource() == chartable) {
                n = -2;
                chartDataViewArray[n2].update(chartDataEvent.getDataUpdate());
            }
            if (chartDataViewArray[n2].getDataSource() == null && n == -1) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            chartDataViewArray[n].setDataSource(chartable);
            return;
        }
        if (n == -1) {
            ChartDataView chartDataView = this.addDataView(this.getNumData());
            chartDataView.setDataSource(chartable);
        }
    }

    private Object axisChartLabelHit(JCVector jCVector, Point point) {
        JCString jCString = null;
        int n = point.x;
        int n2 = point.y;
        int n3 = 0;
        while (n3 < jCVector.size() && jCString == null) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n3);
            JCAxisTitle jCAxisTitle = jCAxis.getTitle();
            if (jCAxisTitle != null && jCAxisTitle.isShowing && n >= jCAxisTitle.getLeft() && n < jCAxisTitle.getLeft() + jCAxisTitle.getWidth() && n2 >= jCAxisTitle.getTop() && n2 < jCAxisTitle.getTop() + jCAxisTitle.getHeight()) {
                jCString = jCAxisTitle.realContents;
                break;
            }
            if (jCAxis.isShowing && n >= jCAxis.getLeft() && n < jCAxis.getLeft() + jCAxis.getWidth() && n2 >= jCAxis.getTop() && n2 < jCAxis.getTop() + jCAxis.getHeight()) {
                JCVector jCVector2 = jCAxis.getAnnotations();
                int n4 = 0;
                while (n4 < jCVector2.size()) {
                    ChartText chartText = ((JCValueLabel)jCVector2.elementAt(n4)).getChartText();
                    if (chartText.isShowing && n >= chartText.getLeft() && n < chartText.getLeft() + chartText.getWidth() && n2 >= chartText.getTop() && n2 < chartText.getTop() + chartText.getHeight()) {
                        jCString = chartText.realContents;
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return jCString;
    }

    public Image snapshot() {
        Image image = this.createImage(this.size().width, this.size().height);
        if (image != null) {
            ((Container)this).print(image.getGraphics());
        }
        return image;
    }

    public void resetDefaults() {
        this.lineColorIndex = 0;
        this.fillColorIndex = 0;
        this.symbolColorIndex = 0;
        this.symbolShapeIndex = 1;
    }

    public void setLineColorIndex(int n) {
        this.lineColorIndex = n;
    }

    public void setFillColorIndex(int n) {
        this.fillColorIndex = n;
    }

    public void setSymbolColorIndex(int n) {
        this.symbolColorIndex = n;
    }

    public void setSymbolShapeIndex(int n) {
        this.symbolShapeIndex = n;
    }

    public int getLineColorIndex() {
        return this.lineColorIndex;
    }

    public int getFillColorIndex() {
        return this.fillColorIndex;
    }

    public int getSymbolColorIndex() {
        return this.symbolColorIndex;
    }

    public int getSymbolShapeIndex() {
        return this.symbolShapeIndex;
    }

    public void addChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.appendChartLabel(jCChartLabel);
        jCChartLabel.setChanged(true, 2);
    }

    protected void appendChartLabel(JCChartLabel jCChartLabel) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            Enumeration enumeration = this.labels.elements();
            while (enumeration.hasMoreElements()) {
                JCChartLabel jCChartLabel2 = (JCChartLabel)enumeration.nextElement();
                if (jCChartLabel2 == null || jCChartLabel2 != jCChartLabel) continue;
                Object var3_5 = null;
                return;
            }
            this.labels.addElement(jCChartLabel);
            if (jCChartLabel.getIsDwellLabel()) {
                this.addToDwellLabels(jCChartLabel);
            }
        }
        jCChartLabel.setParent(this);
    }

    public void removeChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.deleteChartLabel(jCChartLabel);
        this.setChanged(true, 2);
    }

    protected void deleteChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.labels.removeElement(jCChartLabel);
            this.removeFromDwellLabels(jCChartLabel);
            return;
        }
    }

    public int getNumChartLabels() {
        int n = 0;
        try {
            if (this.labels != null) {
                n = this.labels.size();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public void removeAllChartLabels() {
        this.labels.removeAllElements();
        int n = 0;
        while (n < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n);
            chartDataView.autoLabelList = null;
            chartDataView.setAutoLabel(false);
            ++n;
        }
        this.setChanged(true, 1);
    }

    public JCChartLabel getChartLabels(int n) {
        if (n < 0 || n >= this.labels.size()) {
            throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key59"));
        }
        return (JCChartLabel)this.labels.elementAt(n);
    }

    public void setChartLabels(int n, JCChartLabel jCChartLabel) {
        if (n < 0 || n > this.labels.size()) {
            throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key59"));
        }
        if (n < this.labels.size()) {
            if (jCChartLabel == null) {
                this.removeChartLabel((JCChartLabel)this.labels.elementAt(n));
            } else if (!this.labels.contains(jCChartLabel)) {
                JCChart jCChart = this;
                synchronized (jCChart) {
                    this.labels.setElementAt(jCChartLabel, n);
                    if (jCChartLabel.getIsDwellLabel()) {
                        this.addToDwellLabels(jCChartLabel);
                    }
                }
                jCChartLabel.setParent(this);
            }
        } else {
            this.addChartLabel(jCChartLabel);
        }
        this.setChanged(true, 2);
    }

    public JCChartLabel[] getChartLabels() {
        if (this.labels == null || this.labels.size() == 0) {
            return null;
        }
        JCChartLabel[] jCChartLabelArray = new JCChartLabel[this.labels.size()];
        int n = 0;
        while (n < jCChartLabelArray.length) {
            jCChartLabelArray[n] = (JCChartLabel)this.labels.elementAt(n);
            ++n;
        }
        return jCChartLabelArray;
    }

    public void setChartLabels(JCChartLabel[] jCChartLabelArray) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            this.labels = new JCVector();
        }
        boolean bl = this.getIsBatched();
        this.setIsBatched(false);
        if (jCChartLabelArray != null && jCChartLabelArray.length > 0) {
            JCChart jCChart2 = this;
            synchronized (jCChart2) {
                int n = 0;
                while (n < jCChartLabelArray.length) {
                    this.labels.addElement(jCChartLabelArray[n]);
                    if (jCChartLabelArray[n].getIsDwellLabel()) {
                        this.addToDwellLabels(jCChartLabelArray[n]);
                    }
                    ++n;
                }
            }
            int n = 0;
            while (n < jCChartLabelArray.length) {
                jCChartLabelArray[n].setParent(this);
                ++n;
            }
        }
        this.setChanged(true, 2);
        this.setIsBatched(bl);
    }

    public String getCustomizerName() {
        return this.customizerName;
    }

    public void setCustomizerName(String string) {
        if (string == null) {
            return;
        }
        this.customizerName = string;
    }

    public void saveChartAsPng(File file) throws PngEncoderException {
        try {
            this.saveChartAs(ENCODE_PNG, file);
            return;
        }
        catch (EncoderException encoderException) {
            throw new PngEncoderException(encoderException.getMessage());
        }
    }

    public void saveChartAsGif(File file) throws GifEncoderException {
        try {
            this.saveChartAs(ENCODE_GIF, file);
            return;
        }
        catch (EncoderException encoderException) {
            throw new GifEncoderException(encoderException.getMessage());
        }
    }

    public void saveChartAs(String string, File file) throws EncoderException {
        try {
            Encode encode = (Encode)Class.forName(string).newInstance();
            encode.doEncode(this.snapshot(), new FileOutputStream(file));
            return;
        }
        catch (IOException iOException) {
            throw new EncoderException("Unable to create file.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals(ENCODE_GIF)) {
                ErrorDialog.raise(this, JCChartBundle.string("jclass.chart.Key299"));
            } else {
                ErrorDialog.raise(this, "Class " + string + " not found.");
            }
            throw new EncoderException("Encoding class " + string + " not found.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EncoderException("Problems encoding with class " + string + ".");
        }
    }

    protected void addToDwellLabels(JCChartLabel jCChartLabel) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            if (this.dwellLabels != null && this.dwellLabels.contains(jCChartLabel)) {
                Object var3_3 = null;
                return;
            }
            if (jCChartLabel.getIsDwellLabel()) {
                if (this.dwellLabels == null) {
                    this.dwellLabels = new JCVector();
                }
                this.dwellLabels.addElement(jCChartLabel);
            }
            return;
        }
    }

    protected void removeFromDwellLabels(JCChartLabel jCChartLabel) {
        JCChart jCChart = this;
        synchronized (jCChart) {
            block8: {
                block7: {
                    if (this.dwellLabels == null) break block7;
                    if (this.dwellLabels.contains(jCChartLabel)) break block8;
                }
                Object var3_3 = null;
                return;
            }
            this.dwellLabels.removeElement(jCChartLabel);
            if (this.dwellLabels.size() == 0) {
                this.dwellLabels = null;
            }
            return;
        }
    }

    protected void recalcChangedChartLabels() {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null || !jCChartLabel.getChanged(2)) continue;
            jCChartLabel.recalc();
        }
    }

    protected void markAllChartLabelsForRecalc() {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null) continue;
            jCChartLabel.setChanged(true, 2, false);
        }
    }

    public static JCConverter getConverter() {
        if (conv == null) {
            conv = new JCConverter();
        }
        return conv;
    }

    private JCChartHTMLSave getHTMLSave() {
        if (this.save == null) {
            this.save = new JCChartHTMLSave(this);
        }
        return this.save;
    }

    public void setSaveParamStream(OutputStream outputStream) {
        this.getHTMLSave().setSaveParamStream(outputStream);
    }

    public OutputStream getSaveParamStream() {
        return this.getHTMLSave().getSaveParamStream();
    }

    public void saveParams(String string) {
        this.getHTMLSave().saveParams(string);
    }

    public void loadParams(String string) {
        JCUtilConverter.setParamSource(this, JCFile.read(this.getApplet(), string));
        this.loadParams();
    }

    public void loadParams() {
        EventTrigger eventTrigger;
        this.dataviewHashtable = new Hashtable();
        this.indexHashtable = new Hashtable();
        this.setIsBatched(true);
        this.setBackground(JCChart.getConverter().toColor(this.getParam("background"), this.getBackground()));
        this.setForeground(JCChart.getConverter().toColor(this.getParam("foreground"), this.getForeground()));
        this.setFont(JCChart.getConverter().toFont(this.getParam("font"), this.getFont()));
        this.setClipToScreen(JCChart.getConverter().toBoolean(this.getParam("clipToScreen"), this.getClipToScreen()));
        String string = this.getParam("rotateTrigger");
        if (string != null) {
            eventTrigger = this.addTrigger();
            eventTrigger.setModifiers(JCChart.getConverter().toEnum(string, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(0);
        }
        if ((string = this.getParam("zoomTrigger")) != null) {
            eventTrigger = this.addTrigger();
            eventTrigger.setModifiers(JCChart.getConverter().toEnum(string, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(1);
        }
        if ((string = this.getParam("customizeTrigger")) != null) {
            eventTrigger = this.addTrigger();
            eventTrigger.setModifiers(JCChart.getConverter().toEnum(string, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(6);
        }
        if ((string = this.getParam("translateTrigger")) != null) {
            eventTrigger = this.addTrigger();
            eventTrigger.setModifiers(JCChart.getConverter().toEnum(string, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(2);
        }
        if ((string = this.getParam("editTrigger")) != null) {
            eventTrigger = this.addTrigger();
            eventTrigger.setModifiers(JCChart.getConverter().toEnum(string, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(3);
        }
        if ((string = this.getParam("pickTrigger")) != null) {
            eventTrigger = this.addTrigger();
            eventTrigger.setModifiers(JCChart.getConverter().toEnum(string, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(4);
        }
        if ((string = this.getParam("depthTrigger")) != null) {
            eventTrigger = this.addTrigger();
            eventTrigger.setModifiers(JCChart.getConverter().toEnum(string, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(5);
        }
        if (this.getParam("resetKey") != null) {
            this.setResetKey(Integer.parseInt(this.getParam("resetKey")));
        }
        if (this.getParam("candleKey") != null) {
            this.setCancelKey(Integer.parseInt(this.getParam("cancelKey")));
        }
        this.setBorderType(JCChart.getConverter().toEnum(this.getParam("borderType"), "border type", ChartRegion.border_strings, ChartRegion.border_values, this.getBorderType()));
        this.setBorderWidth(JCChart.getConverter().toInt(this.getParam("borderWidth"), this.getBorderWidth()));
        this.setAllowUserChanges(JCChart.getConverter().toBoolean(this.getParam("allowUserChanges"), this.getAllowUserChanges()));
        this.setLeftMargin(JCChart.getConverter().toInt(this.getParam("leftMargin"), this.getLeftMargin()));
        this.setRightMargin(JCChart.getConverter().toInt(this.getParam("rightMargin"), this.getRightMargin()));
        this.setTopMargin(JCChart.getConverter().toInt(this.getParam("topMargin"), this.getTopMargin()));
        this.setBottomMargin(JCChart.getConverter().toInt(this.getParam("bottomMargin"), this.getBottomMargin()));
        this.setDoubleBuffer(JCChart.getConverter().toBoolean(this.getParam("doubleBuffer"), this.getDoubleBuffer()));
        this.setOffset(JCChart.getConverter().toInt(this.getParam("offset"), this.getOffset()));
        this.getFooter().loadParams("footer", this);
        this.getHeader().loadParams("header", this);
        this.getLegend().loadParams("legend", this);
        this.getChartArea().loadParams("chartArea", this);
        this.dataviewHashtable.put("data", this.getDataView(0));
        this.getDataView(0).loadParams("data", this);
        int n = 1;
        while (n < 100) {
            String string2 = this.getParam("dataName" + n);
            if (string2 != null) {
                ChartDataView chartDataView = this.addDataView(this.getNumData());
                this.dataviewHashtable.put(string2, chartDataView);
                chartDataView.loadParams(string2, this);
            }
            ++n;
        }
        int n2 = 1;
        while (n2 < 100) {
            String string3 = this.getParam("indexName" + n2);
            if (string3 != null) {
                JCDataIndex jCDataIndex = new JCDataIndex();
                this.indexHashtable.put(string3, jCDataIndex);
                jCDataIndex.loadParams(string3, this);
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < 100) {
            String string4 = this.getParam("labelName" + n3);
            if (string4 != null) {
                JCChartLabel jCChartLabel = new JCChartLabel();
                this.setChartLabels(this.labels.size(), jCChartLabel);
                jCChartLabel.loadParams(string4, this);
            }
            ++n3;
        }
        this.setIsBatched(false);
        this.setIsBatched(JCChart.getConverter().toBoolean(this.getParam("isBatched"), this.getIsBatched()));
    }

    public static void main(String[] stringArray) {
        ChartFrame chartFrame = new ChartFrame("JClass Chart");
        JCChart jCChart = new JCChart();
        jCChart.setAllowUserChanges(true);
        jCChart.setTrigger(0, new EventTrigger(4, 6));
        chartFrame.setLayout(new GridLayout(1, 1));
        chartFrame.add(jCChart);
        chartFrame.pack();
        chartFrame.resize(500, 300);
        chartFrame.show();
    }

    static {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        eventAction_values = nArray;
        conv = null;
    }
}

