/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Locale;
import jclass.chart.DerivedInt;
import jclass.chart.Drawable;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCBorderStyle;
import jclass.chart.JCChart;
import jclass.chart.JCChartNumberFormat;
import jclass.chart.TrackChange;
import jclass.util.JCUtilConverter;

public class ChartRegion
extends TrackChange
implements Drawable,
Serializable,
HTMLHandler {
    JCBorderStyle borderStyle;
    Insets insets = new Insets(0, 0, 0, 0);
    DerivedInt left = new DerivedInt(0, true);
    DerivedInt top = new DerivedInt(0, true);
    DerivedInt width = new DerivedInt(0, true);
    DerivedInt height = new DerivedInt(0, true);
    public static final String[] border_strings = new String[]{"None", "Etched_In", "Etched_Out", "In", "Out", "Plain", "Frame_In", "Frame_Out", "Control_In", "Control_Out"};
    public static final int[] border_values;
    Font font;
    String name;
    Color foreground;
    Color background;
    JCChart parent;
    ChartRegion parentRegion;
    boolean isShowing = true;
    boolean updateParent = true;
    boolean dimIsDefaultChangedToTrue = false;
    boolean inUpdate = false;
    boolean needsRepaint = true;
    protected boolean transparent = true;
    private transient JCChartNumberFormat numberFormatter;
    protected boolean numberLocalization = true;
    protected boolean groupingUsed = false;

    public ChartRegion() {
    }

    public ChartRegion(JCChart jCChart) {
        this.setParent(jCChart);
        this.setBorderWidth(3);
    }

    public ChartRegion(ChartRegion chartRegion) {
        this.setParentRegion(chartRegion);
        if (chartRegion != null) {
            this.setParent(chartRegion.getParent());
        }
        this.setBorderWidth(3);
    }

    public void setParent(JCChart jCChart) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            this.parent = jCChart;
            return;
        }
    }

    public JCChart getParent() {
        return this.parent;
    }

    public Object getRegionLock() {
        if (this.parent != null) {
            return this.parent.getAWTLock();
        }
        return this;
    }

    public void setParentRegion(ChartRegion chartRegion) {
        this.parentRegion = chartRegion;
    }

    public ChartRegion getParentRegion() {
        return this.parentRegion;
    }

    public Font getFont() {
        if (this.font == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (font == this.font) {
                Object var3_3 = null;
                return;
            }
            this.font = font;
        }
        this.setChanged(true, 2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            this.name = string;
            return;
        }
    }

    public Color getForeground() {
        if (this.foreground == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getForeground();
        }
        return this.foreground;
    }

    public void setForeground(Color color) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (color == this.foreground) {
                Object var3_3 = null;
                return;
            }
            this.foreground = color;
        }
        this.setChanged(true, 2);
    }

    public Color getBackground() {
        if (this.background == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getBackground();
        }
        return this.background;
    }

    public void setBackground(Color color) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (color == this.background) {
                Object var3_3 = null;
                return;
            }
            this.background = color;
        }
        this.setChanged(true, 2);
    }

    public boolean getIsShowing() {
        return this.isShowing;
    }

    public void setIsShowing(boolean bl) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.isShowing == bl) {
                Object var3_3 = null;
                return;
            }
            this.isShowing = bl;
        }
        this.setChanged(true, 2);
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public void recalc() {
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.left.isDefault) {
            this.left.value = n;
        }
        if (this.top.isDefault) {
            this.top.value = n2;
        }
        if (this.width.isDefault) {
            this.width.value = n3;
        }
        if (this.height.isDefault) {
            this.height.value = n4;
        }
    }

    public void move(int n, int n2) {
        this.reshape(n, n2, this.width.value, this.height.value);
    }

    public void resize(int n, int n2) {
        this.reshape(this.left.value, this.top.value, n + this.insets.left + this.insets.right, n2 + this.insets.top + this.insets.bottom);
    }

    public void setTop(int n) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.top.value == n) {
                Object var3_3 = null;
                return;
            }
            this.top.value = n;
            this.top.isDefault = false;
        }
        this.setChanged(true, 10);
    }

    public int getTop() {
        return this.top.value;
    }

    public void setTopIsDefault(boolean bl) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.top.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.top.isDefault = bl;
            this.dimIsDefaultChangedToTrue = bl;
        }
        this.setChanged(true, 10);
    }

    public boolean getTopIsDefault() {
        return this.top.isDefault;
    }

    public void setLeft(int n) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.left.value == n) {
                Object var3_3 = null;
                return;
            }
            this.left.value = n;
            this.left.isDefault = false;
        }
        this.setChanged(true, 10);
    }

    public int getLeft() {
        return this.left.value;
    }

    public void setLeftIsDefault(boolean bl) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.left.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.left.isDefault = bl;
            this.dimIsDefaultChangedToTrue = bl;
        }
        this.setChanged(true, 10);
    }

    public boolean getLeftIsDefault() {
        return this.left.isDefault;
    }

    public void setWidth(int n) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.width.value == n) {
                Object var3_3 = null;
                return;
            }
            this.width.value = n;
            this.width.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public int getWidth() {
        return this.width.value;
    }

    public void setWidthIsDefault(boolean bl) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.width.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.width.isDefault = bl;
            this.dimIsDefaultChangedToTrue = bl;
        }
        this.setChanged(true, 2);
    }

    public boolean getWidthIsDefault() {
        return this.width.isDefault;
    }

    public void setHeight(int n) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.height.value == n) {
                Object var3_3 = null;
                return;
            }
            this.height.value = n;
            this.height.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public int getHeight() {
        return this.height.value;
    }

    public void setHeightIsDefault(boolean bl) {
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.height.isDefault == bl) {
                Object var3_3 = null;
                return;
            }
            this.height.isDefault = bl;
            this.dimIsDefaultChangedToTrue = bl;
        }
        this.setChanged(true, 2);
    }

    public boolean getHeightIsDefault() {
        return this.height.isDefault;
    }

    public void setBorderType(int n) {
        JCBorderStyle jCBorderStyle = null;
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.borderStyle == null) {
                this.borderStyle = new JCBorderStyle(this);
            }
            jCBorderStyle = this.borderStyle;
        }
        jCBorderStyle.setType(n);
    }

    public int getBorderType() {
        if (this.borderStyle == null) {
            this.borderStyle = new JCBorderStyle(this);
        }
        return this.borderStyle.getType();
    }

    public void setBorderWidth(int n) {
        JCBorderStyle jCBorderStyle = null;
        ChartRegion chartRegion = this;
        synchronized (chartRegion) {
            if (this.borderStyle == null) {
                this.borderStyle = new JCBorderStyle(this);
            }
            jCBorderStyle = this.borderStyle;
        }
        jCBorderStyle.setWidth(n);
    }

    public int getBorderWidth() {
        if (this.borderStyle == null) {
            this.borderStyle = new JCBorderStyle(this);
        }
        return this.borderStyle.getWidth();
    }

    public JCChartNumberFormat getNumberFormatter() {
        if (this.numberFormatter == null) {
            this.numberFormatter = new JCChartNumberFormat(this);
        }
        return this.numberFormatter;
    }

    public void setNumberLocalization(boolean bl) {
        if (bl == this.numberLocalization) {
            return;
        }
        this.numberLocalization = bl;
    }

    public boolean getNumberLocalization() {
        return this.numberLocalization;
    }

    public boolean getGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean bl) {
        if (this.groupingUsed == bl) {
            return;
        }
        this.groupingUsed = bl;
        this.setChanged(true, 2);
    }

    public void setNumberFormatterLocale(Locale locale) {
        this.getNumberFormatter().setNumberFormatterLocale(locale);
        this.setChanged(true, 2);
    }

    public void draw(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        if (!this.transparent) {
            if (this.getBackground() == null) {
                if (this.parent != null && this.parent.getBackground() != null) {
                    graphics.setColor(this.parent.getBackground());
                    graphics.fillRect(this.left.value, this.top.value, this.width.value, this.height.value);
                }
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.left.value, this.top.value, this.width.value, this.height.value);
            }
        }
        if (this.borderStyle == null) {
            return;
        }
        this.borderStyle.draw(graphics, this.left.value, this.top.value, this.width.value, this.height.value, this.getBackground(), this.getForeground());
    }

    public void setChanged(boolean bl, int n) {
        if (bl != this.getChanged() || !this.getChanged(n)) {
            if (this.parentRegion != null) {
                this.parentRegion.setChanged(bl, n, false);
            }
            super.setChanged(bl, n);
        }
        if (bl && this.parent != null && this.updateParent) {
            this.updateParent(n);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (this.parentRegion != null) {
            this.parentRegion.setChanged(bl, n, false);
        }
        super.setChanged(bl, n, bl2);
    }

    Graphics getGraphics() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getGraphics();
    }

    public void repaint() {
        if (this.parentRegion != null) {
            this.parentRegion.repaint();
            return;
        }
        if (this.parent == null) {
            return;
        }
        Graphics graphics = null;
        Image image = null;
        if (this.parent.getDoubleBuffer()) {
            graphics = this.parent.getDoubleBufferGraphics();
            image = this.parent.getDoubleBufferImage();
        }
        if (graphics == null && (graphics = this.parent.getGraphics()) == null) {
            this.parent.repaint();
            return;
        }
        Rectangle rectangle = new Rectangle(this.left.value, this.top.value, this.width.value, this.height.value);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
        if (image != null) {
            graphics = this.parent.getGraphics();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (graphics != null) {
                graphics.drawImage(image, 0, 0, null);
            }
            graphics.dispose();
        }
    }

    public Dimension preferredSize() {
        Dimension dimension = new Dimension();
        int n = this.getBorderWidth();
        dimension.width = !this.width.isDefault ? (dimension.width += this.width.value) : 2 * n + this.insets.left + this.insets.right;
        dimension.height = !this.height.isDefault ? (dimension.height += this.height.value) : (dimension.height += 2 * n + this.insets.top + this.insets.bottom);
        return dimension;
    }

    public Point location() {
        return new Point(this.left.value, this.top.value);
    }

    public Dimension size() {
        return new Dimension(this.width.value, this.height.value);
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        int n = this.getBorderWidth();
        rectangle.reshape(n + this.insets.left + this.left.value, n + this.insets.top + this.top.value, Math.max(0, this.size().width - (2 * n + this.insets.left + this.insets.right)), Math.max(0, this.size().height - (2 * n + this.insets.top + this.insets.bottom)));
    }

    public boolean inside(int n, int n2) {
        Rectangle rectangle = this.getDrawingArea();
        return rectangle.inside(n, n2);
    }

    public void show() {
        this.setIsShowing(true);
        this.parent.repaint();
    }

    public void hide() {
        if (!this.isShowing) {
            return;
        }
        this.setIsShowing(false);
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
        this.setChanged(true, 2);
    }

    public Insets insets() {
        return this.insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public boolean sizeChanged() {
        if (this.dimIsDefaultChangedToTrue) {
            this.dimIsDefaultChangedToTrue = false;
            return true;
        }
        return this.getLeft() != this.location().x || this.getTop() != this.location().y || this.getWidth() != this.size().width || this.getHeight() != this.size().height;
    }

    public void updateParent(int n) {
        JCChart jCChart = this.getParent();
        if (jCChart != null && jCChart.getPeer() != null) {
            if ((n & 2) > 0 || (n & 8) > 0) {
                Object object = this.getRegionLock();
                synchronized (object) {
                    jCChart.invalidate();
                    if (!jCChart.getIsBatched()) {
                        jCChart.validate();
                        if (jCChart.getPeer() != null) {
                            jCChart.repaint();
                        }
                    }
                    return;
                }
            }
            if ((n & 1) > 0) {
                Object object = this.getRegionLock();
                synchronized (object) {
                    if (!jCChart.getIsBatched() && jCChart.getPeer() != null) {
                        jCChart.repaint();
                    }
                    return;
                }
            }
        }
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        boolean bl;
        ChartRegion chartRegion = new ChartRegion();
        boolean bl2 = string.indexOf("footer") >= 0 || string.indexOf("header") >= 0 || string.indexOf("title") >= 0;
        boolean bl3 = bl = string.indexOf("legend") >= 0;
        if (!this.left.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".left", this.getLeft());
        }
        if (!this.top.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".top", this.getTop());
        }
        if (!this.height.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".height", this.getHeight());
        }
        if (!this.width.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".width", this.getWidth());
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".groupingUsed", chartRegion.getGroupingUsed(), this.getGroupingUsed());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".numberLocalization", chartRegion.getNumberLocalization(), this.getNumberLocalization());
        if (!bl2 && !bl) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowing", chartRegion.getIsShowing(), this.getIsShowing());
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".borderType", JCUtilConverter.fromEnum(chartRegion.getBorderType(), border_strings, border_values), JCUtilConverter.fromEnum(this.getBorderType(), border_strings, border_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".borderWidth", chartRegion.getBorderWidth(), this.getBorderWidth());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".font", this.font);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".foreground", this.foreground);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".background", this.background);
        if (!bl2) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".insets", chartRegion.getInsets(), this.getInsets());
        }
    }

    public void loadParams(String string, JCChart jCChart) {
        String string2 = jCChart.getParam(String.valueOf(string) + ".font");
        if (string2 != null) {
            this.setFont(JCChart.getConverter().toFont(string2));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".foreground")) != null) {
            this.setForeground(JCChart.getConverter().toColor(string2));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".background")) != null) {
            this.setBackground(JCChart.getConverter().toColor(string2));
        }
        this.setGroupingUsed(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".groupingUsed"), this.getGroupingUsed()));
        this.setNumberLocalization(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".numberLocalization"), this.getNumberLocalization()));
        string2 = jCChart.getParam(String.valueOf(string) + ".left");
        if (string2 != null) {
            try {
                if (Integer.valueOf(string2) == 0) {
                    this.setLeft(0);
                    this.setLeftIsDefault(false);
                } else {
                    this.setLeft(JCChart.getConverter().toInt(string2, this.getLeft()));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".top")) != null) {
            try {
                if (Integer.valueOf(string2) == 0) {
                    this.setTop(0);
                    this.setTopIsDefault(false);
                } else {
                    this.setTop(JCChart.getConverter().toInt(string2, this.getTop()));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".width")) != null) {
            try {
                if (Integer.valueOf(string2) == 0) {
                    this.setWidth(0);
                    this.setWidthIsDefault(false);
                } else {
                    this.setWidth(JCChart.getConverter().toInt(string2, this.getWidth()));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".height")) != null) {
            try {
                if (Integer.valueOf(string2) == 0) {
                    this.setHeight(0);
                    this.setHeightIsDefault(false);
                } else {
                    this.setHeight(JCChart.getConverter().toInt(string2, this.getHeight()));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.setBorderType(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".borderType"), String.valueOf(string) + " border type", border_strings, border_values, this.getBorderType()));
        this.setBorderWidth(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".borderWidth"), this.getBorderWidth()));
        this.setIsShowing(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), this.getIsShowing()));
        this.setInsets(JCChart.getConverter().toInsets(jCChart.getParam(String.valueOf(string) + ".insets"), this.getInsets()));
    }

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        border_values = nArray;
    }
}

