/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.Serializable;
import jclass.chart.ChartDataView;
import jclass.chart.DerivedInt;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartStyle;
import jclass.chart.MinMax;
import jclass.util.JCString;

public class ChartDataViewSeries
implements Serializable,
HTMLHandler {
    protected ChartDataView parent;
    private double[] xvalues;
    private double[] yvalues;
    protected int firstPoint;
    protected DerivedInt lastPoint = new DerivedInt(0, true);
    protected String name;
    protected int drawingOrder = -1;
    protected boolean isShowing = true;
    protected boolean isShowingInLegend = true;
    protected boolean isIncluded = true;
    protected String label;
    protected JCString realLabel;
    protected static int dataViewSeriesNum;

    void init(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
        } else {
            this.firstPoint = 0;
            this.lastPoint.value = this.maxIndex();
            this.lastPoint.isDefault = true;
        }
        this.name = String.valueOf(JCChartBundle.string("jclass.chart.Key27")) + ++dataViewSeriesNum;
    }

    public ChartDataViewSeries() {
        this.parent = null;
        this.xvalues = null;
        this.yvalues = null;
    }

    ChartDataViewSeries(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
            return;
        }
        this.firstPoint = 0;
        this.lastPoint.value = this.maxIndex();
        this.lastPoint.isDefault = true;
    }

    public void editPoint(int n, double d) {
        if (this.parent.editPoint(this, n, d)) {
            this.yvalues[n] = d;
            this.parent.setChanged(true, 2);
        }
    }

    public int getFirstPoint() {
        if (this.firstPoint == Integer.MAX_VALUE && this.getX() != null && this.getY() != null) {
            this.firstPoint = 0;
        }
        return this.firstPoint;
    }

    public void setFirstPoint(int n) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (n < 0 || n > this.maxIndex()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key40"));
            }
            if (this.firstPoint == n) {
                Object var3_3 = null;
                return;
            }
            this.firstPoint = n;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public int getLastPoint() {
        double[] dArray = this.getX();
        double[] dArray2 = this.getY();
        if (this.lastPoint.isDefault && dArray != null && dArray2 != null) {
            return Math.min(dArray2.length, dArray.length) - 1;
        }
        return this.lastPoint.value;
    }

    public boolean getLastPointIsDefault() {
        return this.lastPoint.isDefault;
    }

    public void setLastPoint(int n) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (n < 0 || n > this.maxIndex()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key101"));
            }
            if (this.lastPoint.value == n) {
                Object var3_3 = null;
                return;
            }
            this.lastPoint.value = n;
            this.lastPoint.isDefault = false;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setLastPointIsDefault(boolean bl) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            this.lastPoint.isDefault = bl;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (this.name == string) {
                Object var3_3 = null;
                return;
            }
            this.name = string;
            return;
        }
    }

    public ChartDataView getParent() {
        return this.parent;
    }

    public JCChartStyle getStyle() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.getSeriesIndex(this);
        if (n < 0) {
            return null;
        }
        return this.parent.getChartStyle(n);
    }

    public void setStyle(JCChartStyle jCChartStyle) {
        if (this.parent == null) {
            return;
        }
        int n = this.parent.getSeriesIndex(this);
        this.parent.setChartStyle(n, jCChartStyle);
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public void setDrawingOrder(int n) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (this.drawingOrder == n) {
                Object var3_3 = null;
                return;
            }
            this.drawingOrder = n;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 17);
        }
    }

    public boolean getIsShowing() {
        return this.isShowing;
    }

    public void setIsShowing(boolean bl) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (bl == this.isShowing) {
                Object var3_3 = null;
                return;
            }
            this.isShowing = bl;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
    }

    public boolean getIsShowingInLegend() {
        return this.isShowingInLegend;
    }

    public void setIsShowingInLegend(boolean bl) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (bl == this.isShowingInLegend) {
                Object var3_3 = null;
                return;
            }
            this.isShowingInLegend = bl;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 32);
        }
    }

    public boolean getIsIncluded() {
        return this.isIncluded;
    }

    public void setIsIncluded(boolean bl) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (bl == this.isIncluded) {
                Object var3_3 = null;
                return;
            }
            this.isIncluded = bl;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setLabel(String string) {
        ChartDataViewSeries chartDataViewSeries = this;
        synchronized (chartDataViewSeries) {
            if (string == this.label) {
                Object var3_3 = null;
                return;
            }
            this.label = string;
            this.realLabel = this.label == null ? null : (this.parent != null ? JCString.parse(this.parent.chart, this.label) : JCString.parse(null, this.label));
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 32);
        }
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = new String(String.valueOf(JCChartBundle.string("jclass.chart.Key127")) + (this.drawingOrder + 1));
        }
        return this.label;
    }

    JCString getRealLabel() {
        return this.realLabel;
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            return JCChartBundle.string("jclass.chart.Key143");
        }
        return string;
    }

    int maxXIndex() {
        int n;
        int n2 = this.parent == null ? 0 : (n = this.parent.getX() == null ? 0 : this.parent.getX().length);
        if (this.xvalues == null) {
            return n;
        }
        return this.xvalues.length;
    }

    int maxYIndex() {
        if (this.yvalues == null) {
            return 0;
        }
        return this.yvalues.length;
    }

    int maxIndex() {
        return Math.max(0, Math.min(this.maxXIndex(), this.maxYIndex()) - 1);
    }

    void getXMinMax(MinMax minMax) {
        if (minMax == null) {
            return;
        }
        minMax.setMinMax(this.xvalues == null ? this.parent.getX() : this.xvalues, this.parent.holeValue);
    }

    void calcStep(JCAxis jCAxis) {
        double[] dArray;
        double[] dArray2 = dArray = this.xvalues == null ? this.parent.getX() : this.xvalues;
        if (dArray == null || dArray.length == 0) {
            return;
        }
        int n = 1;
        while (n < dArray.length) {
            double d = dArray[n] - dArray[n - 1];
            if (d < 0.0) {
                d = -d;
            }
            if (d < jCAxis.step && d != 0.0) {
                jCAxis.step = d;
            }
            ++n;
        }
        if (jCAxis.step == Double.MAX_VALUE) {
            jCAxis.step = 1.0;
        }
    }

    void getYMinMax(MinMax minMax) {
        if (minMax == null) {
            return;
        }
        minMax.setMinMax(this.yvalues, this.parent.holeValue);
    }

    public double getX(int n) {
        if (this.xvalues == null) {
            return this.parent.getX()[n];
        }
        return this.xvalues[n];
    }

    public double getY(int n) {
        return this.yvalues[n];
    }

    double[] getX() {
        if (this.xvalues == null) {
            return this.parent.getX();
        }
        return this.xvalues;
    }

    double[] getY() {
        return this.yvalues;
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    void setY(double[] dArray) {
        this.yvalues = dArray;
    }

    public int getX(double d) {
        return this.getPoint(d, this.getX());
    }

    public int getY(double d) {
        return this.getPoint(d, this.yvalues);
    }

    int getPoint(double d, double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = Math.abs(dArray[n2] - d);
            if (d3 < d2) {
                d2 = d3;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries();
        this.getStyle().saveParams(string, hTMLSaveDriver);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowing", chartDataViewSeries.isShowing, this.isShowing);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isIncluded", chartDataViewSeries.isIncluded, this.isIncluded);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowingInLegend", chartDataViewSeries.isShowingInLegend, this.isShowingInLegend);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".firstPoint", chartDataViewSeries.firstPoint, this.firstPoint);
        if (!this.lastPoint.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".lastPoint", this.lastPoint.value);
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".label", this.getLabel());
    }

    public void loadParams(String string, JCChart jCChart) {
        this.getStyle().loadParams(string, jCChart);
        this.setIsShowing(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), this.getIsShowing()));
        this.setIsIncluded(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isIncluded"), this.getIsIncluded()));
        this.setIsShowingInLegend(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowingInLegend"), this.getIsShowingInLegend()));
        String string2 = jCChart.getParam(String.valueOf(string) + ".firstPoint");
        if (string2 != null) {
            this.setFirstPoint(JCChart.getConverter().toInt(string2, this.getFirstPoint()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".lastPoint")) != null) {
            this.setLastPoint(JCChart.getConverter().toInt(string2, this.getLastPoint()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".label")) != null && !string2.equals(this.getLabel())) {
            this.setLabel(string2);
        }
    }
}

