/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.StringBufferInputStream;
import jclass.chart.ChartDataView;
import jclass.chart.InputStreamDataSource;
import jclass.chart.JCChart;
import jclass.chart.JCChartConverter;
import jclass.chart.URLDataSource;
import jclass.util.JCConverter;

class ChartDataViewHTMLLoad {
    ChartDataView source;

    ChartDataViewHTMLLoad(ChartDataView chartDataView) {
        this.source = chartDataView;
    }

    public void load(String string, JCChart jCChart) {
        InputStreamDataSource inputStreamDataSource = null;
        String string2 = jCChart.getParam(string);
        if (string2 == null) {
            string2 = jCChart.getParam(String.valueOf(string) + "File");
            if (string2 != null) {
                try {
                    inputStreamDataSource = new URLDataSource(jCChart.getApplet().getDocumentBase(), string2);
                }
                catch (Exception exception) {
                    inputStreamDataSource = null;
                }
            }
        } else {
            try {
                inputStreamDataSource = new InputStreamDataSource(new StringBufferInputStream(string2));
            }
            catch (Exception exception) {
                inputStreamDataSource = null;
            }
        }
        if (inputStreamDataSource != null) {
            this.source.setDataSource(inputStreamDataSource);
        }
        this.source.setIsInverted(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isInverted"), this.source.getIsInverted()));
        this.source.setChartType(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".chartType"), "chart type", ChartDataView.chartType_strings, ChartDataView.chartType_values, this.source.getChartType()));
        this.source.setIsShowingInLegend(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowingInLegend"), this.source.getIsShowingInLegend()));
        this.source.setIsShowing(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), this.source.getIsShowing()));
        this.source.setAutoLabel(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".autoLabel"), this.source.getAutoLabel()));
        this.source.setBufferPlotData(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".bufferPlotData"), this.source.getBufferPlotData()));
        this.source.setFastUpdate(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".fastUpdate"), this.source.getFastUpdate()));
        this.source.setDrawFrontPlane(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".drawFrontPlane"), this.source.getDrawFrontPlane()));
        this.source.setOutlineColor(JCChart.getConverter().toColor(jCChart.getParam(String.valueOf(string) + ".outlineColor"), this.source.getOutlineColor()));
        this.source.setHoleValue(JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".holeValue"), this.source.getHoleValue()));
        String string3 = jCChart.getParam(String.valueOf(string) + ".pointLabels");
        if (string3 != null) {
            JCChart.getConverter();
            this.source.setPointLabels(JCConverter.toStringList(string3));
        }
        this.source.getXAxis().loadParams(String.valueOf(string) + ".xaxis", jCChart);
        this.source.getYAxis().loadParams(String.valueOf(string) + ".yaxis", jCChart);
        JCChartConverter jCChartConverter = new JCChartConverter();
        this.source.setXAxis(jCChartConverter.toAxis(jCChart, jCChart.getParam(String.valueOf(string) + ".xaxis"), this.source.getXAxis()));
        this.source.setYAxis(jCChartConverter.toAxis(jCChart, jCChart.getParam(String.valueOf(string) + ".yaxis"), this.source.getYAxis()));
        int n = 0;
        while (n < this.source.getNumSeries()) {
            this.source.getSeries(n).loadParams(String.valueOf(string) + ".series" + (n + 1), jCChart);
            ++n;
        }
        switch (this.source.getChartType()) {
            case 5: {
                this.source.getHiloChartFormat().loadParams(String.valueOf(string) + ".Hilo", jCChart);
                return;
            }
            case 6: {
                this.source.getHLOCChartFormat().loadParams(String.valueOf(string) + ".HLOC", jCChart);
                return;
            }
            case 7: {
                this.source.getCandleChartFormat().loadParams(String.valueOf(string) + ".Candle", jCChart);
                return;
            }
            case 9: 
            case 10: {
                this.source.getBarChartFormat().loadParams(String.valueOf(string) + ".Bar", jCChart);
                return;
            }
            case 8: 
            case 12: {
                this.source.getAreaChartFormat().loadParams(String.valueOf(string) + ".Area", jCChart);
                return;
            }
            case 11: {
                this.source.getPieChartFormat().loadParams(String.valueOf(string) + ".Pie", jCChart);
                return;
            }
        }
    }
}

