/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import jclass.chart.JCAxis;
import jclass.chart.JCLineStyle;
import jclass.chart.MultiChart;
import jclass.chart.RadioAxisWrapper;
import jclass.chart.RadioSeries;

public class AxisGridWrapper
extends RadioAxisWrapper {
    public boolean[] showing;
    public double[] spacing;
    public int[] pattern;
    public int[] width;
    public Color[] color;
    public boolean[] spacing_isdef;
    public int width_def = 1;
    private boolean defs_done = false;

    public AxisGridWrapper() {
    }

    public AxisGridWrapper(int n) {
        this.setWrapperArraySize(n);
    }

    public AxisGridWrapper(String string, String string2, String string3, String string4, String string5) {
        this.setWrapperArraySize(MultiChart.AXIS_RADIO_NAMES.length);
        this.setWrapperBooleanValues(this.showing, new RadioSeries(string));
        this.setWrapperDoubleIsDefValues(this.spacing, this.spacing_isdef, new RadioSeries(string2));
        this.setWrapperEnumValues(this.pattern, new RadioSeries(string3), JCLineStyle.linePattern_strings, JCLineStyle.linePattern_values, "AxisGridPattern", 1);
        this.setWrapperIntValues(this.width, new RadioSeries(string4));
        this.setWrapperColorValues(this.color, new RadioSeries(string5));
    }

    public void setWrapperArraySize(int n) {
        this.showing = new boolean[n];
        this.spacing = new double[n];
        this.pattern = new int[n];
        this.width = new int[n];
        this.color = new Color[n];
        this.spacing_isdef = new boolean[n];
    }

    public void setWrapperValue(int n, JCAxis jCAxis) {
        this.showing[n] = jCAxis.getGridIsShowing();
        this.spacing[n] = jCAxis.getGridSpacing();
        this.pattern[n] = jCAxis.getGridStyle().getLinePattern();
        this.width[n] = jCAxis.getGridStyle().getLineWidth();
        this.color[n] = jCAxis.getGridStyle().getLineColor();
        this.spacing_isdef[n] = jCAxis.getGridSpacingIsDefault();
    }

    public void setPropertyValue(int n, JCAxis jCAxis) {
        jCAxis.setGridIsShowing(this.showing[n]);
        if (this.spacing_isdef[n]) {
            jCAxis.setGridSpacingIsDefault(this.spacing_isdef[n]);
        } else {
            jCAxis.setGridSpacing(this.spacing[n]);
        }
        try {
            jCAxis.getGridStyle().setLinePattern(this.pattern[n]);
        }
        catch (Exception exception) {
            this.pattern[n] = jCAxis.getGridStyle().getLinePattern();
        }
        jCAxis.getGridStyle().setLineWidth(this.width[n]);
        jCAxis.getGridStyle().setLineColor(this.color[n]);
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + this.booleanValuesToString(this.showing);
        string = String.valueOf(string) + ",";
        string = String.valueOf(string) + this.doubleIsDefValuesToString(this.spacing, this.spacing_isdef);
        string = String.valueOf(string) + ",";
        string = String.valueOf(string) + this.enumValuesToString(this.pattern, JCLineStyle.linePattern_strings, JCLineStyle.linePattern_values);
        string = String.valueOf(string) + ",";
        string = String.valueOf(string) + this.intValuesToString(this.width);
        string = String.valueOf(string) + ",";
        string = String.valueOf(string) + this.colorValuesToString(this.color);
        return string;
    }
}

