/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_Item;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_SwitchIns;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_TableSwitchIns
extends BT_SwitchIns {
    public int low;
    public int high;

    public Object clone() {
        BT_Ins[] t = new BT_Ins[this.targets.length];
        int n = 0;
        while (n < t.length) {
            t[n] = this.targets[n];
            ++n;
        }
        return new BT_TableSwitchIns(this.opcode, this.low, this.high, this.def, t);
    }

    public BT_TableSwitchIns(int opcode, int low, int high, BT_Ins def, BT_Ins[] targets) {
        super(opcode, def, targets);
        this.low = low;
        this.high = high;
    }

    BT_TableSwitchIns(int opcode, int index, int low, int high, int defIntTarget, int[] intTargets) {
        super(opcode, index, defIntTarget, intTargets);
        this.low = low;
        this.high = high;
    }

    public static BT_TableSwitchIns make(int opcode, int offset, byte[] data, BT_Item item) {
        int start = (offset / 4 + 1) * 4;
        if (start + 12 > data.length) {
            throw new InternalError("Truncated instruction at " + offset + " of method " + item.fullName());
        }
        int def = offset - 8 + BT_Misc.bytesToInt(data, start);
        int low = BT_Misc.bytesToInt(data, start + 4);
        int high = BT_Misc.bytesToInt(data, start + 8);
        int size = start - offset + 12 + (high - low + 1) * 4;
        if (start + 12 + (high - low + 1) * 4 > data.length) {
            throw new InternalError("Truncated instruction at " + offset + " of method " + item.fullName());
        }
        int[] intTargets = new int[high - low + 1];
        int m = 0;
        while (m < high - low + 1) {
            intTargets[m] = offset - 8 + BT_Misc.bytesToInt(data, start + 12 + m * 4);
            ++m;
        }
        return new BT_TableSwitchIns(opcode, offset - 8, low, high, def, intTargets);
    }

    public int size() {
        int start = (this.byteIndex / 4 + 1) * 4;
        int size = start - this.byteIndex + 12 + (this.high - this.low + 1) * 4;
        return size;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeByte(this.opcode);
        int start = (this.byteIndex / 4 + 1) * 4;
        int n = this.byteIndex + 1;
        while (n < start) {
            dos.writeByte(0);
            ++n;
        }
        dos.writeInt(this.def.byteIndex - this.byteIndex);
        dos.writeInt(this.low);
        dos.writeInt(this.high);
        n = 0;
        while (n < this.targets.length) {
            dos.writeInt(this.targets[n].byteIndex - this.byteIndex);
            ++n;
        }
    }

    public String toString() {
        String s = String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode];
        if (this.targets != null) {
            int n = 0;
            while (n < this.targets.length) {
                s = String.valueOf(s) + BT_Base.endl() + "\t\t    when value is " + (this.low + n) + " goto instruction at " + this.targets[n].byteIndex;
                ++n;
            }
            s = String.valueOf(s) + BT_Base.endl() + "\t\t    else goto instruction at " + this.def.byteIndex;
        }
        return s;
    }

    public String toAssemblerString() {
        StringBuffer s = new StringBuffer(BT_Misc.opcodeName[this.opcode]);
        s.append(this.def.getLabel());
        s.append(" { ");
        s.append(this.low);
        s.append(" ");
        s.append(this.high);
        s.append(" ");
        int n = 0;
        while (n < this.targets.length) {
            s.append(this.targets[n].getLabel());
            s.append(" ");
            ++n;
        }
        s.append("}");
        return s.toString();
    }
}

