/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Local;
import com.ibm.jikesbt.BT_LocalVector;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_RetIns
extends BT_Ins {
    public int localNr;
    public BT_Local target;
    public boolean wide;

    BT_RetIns(int opcode, int index, int localNr) {
        this(opcode, index, localNr, false);
    }

    BT_RetIns(int opcode, int index, int localNr, boolean wide) {
        super(opcode, index);
        this.localNr = localNr;
        this.wide = wide;
    }

    public BT_RetIns(int opcode, BT_Local l) {
        super(opcode, -1);
        this.target = l;
        this.localNr = this.target.localNr;
        this.wide = this.localNr > 255;
    }

    public Object clone() {
        return new BT_RetIns(this.opcode, this.target);
    }

    public void dereference(BT_InsVector items) {
        this.target = items.locals.elementAt(this.localNr);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.target = ins.locals.elementAt(this.localNr);
        this.wide = this.localNr > 255;
    }

    public int size() {
        return this.wide ? 4 : 2;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.wide) {
            dos.writeByte(196);
            dos.writeByte(169);
            dos.writeShort(this.localNr);
        } else {
            dos.writeByte(169);
            dos.writeByte(this.localNr);
        }
    }

    public void incrementLocalsAccessWith(int inc, int start, BT_LocalVector locals) {
        if (this.localNr < start) {
            return;
        }
        this.localNr += inc;
        this.wide = this.localNr > 255;
        this.target = locals.elementAt(this.localNr);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.localNr;
    }

    public String toAssemblerString() {
        return String.valueOf(super.toAssemblerString()) + " " + this.localNr;
    }
}

