/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Accessor;
import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ClassInfoUntilName;
import com.ibm.jikesbt.BT_ClassPathEntry;
import com.ibm.jikesbt.BT_ClassTable;
import com.ibm.jikesbt.BT_ClassVector;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_DuplicateClassException;
import com.ibm.jikesbt.BT_Exception;
import com.ibm.jikesbt.BT_Factory;
import com.ibm.jikesbt.BT_Field;
import com.ibm.jikesbt.BT_FieldRefIns;
import com.ibm.jikesbt.BT_GenericAttribute;
import com.ibm.jikesbt.BT_JarResource;
import com.ibm.jikesbt.BT_JarResourceVector;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_MethodCallSite;
import com.ibm.jikesbt.BT_MethodRefIns;
import com.ibm.jikesbt.BT_MethodRelationships;
import com.ibm.jikesbt.BT_MethodSignature;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BT_Repository
extends BT_Base {
    protected static final boolean TRACE = false;
    static boolean loadSystemClassesUsingReflection = false;
    protected static String sourcePath;
    public BT_Factory factory;
    public final BT_ClassVector classes = new BT_ClassTable();
    public final BT_JarResourceVector resources = new BT_JarResourceVector();
    public static boolean locked;
    public static final int VERSION_RELEASE_FIX = 10100;
    public static String debugRecentlyReadAttributeName;
    public static String debugRecentlyReadClassName;
    public static String debugRecentlyReadFieldName;
    public static String debugRecentlyReadMethodName;
    public static BT_Attribute debugRecentlyUsedAttribute;
    public static BT_Class debugRecentlyUsedClass;
    public static BT_Field debugRecentlyUsedField;
    public static BT_Method debugRecentlyUsedMethod;
    public static BT_Attribute debugRecentlyWrittenAttribute;
    public static BT_Class debugRecentlyWrittenClass;
    public static BT_Field debugRecentlyWrittenField;
    public static BT_Method debugRecentlyWrittenMethod;
    public static String debugRecentlyReadFileName;
    public static String debugRecentlyWrittenFileName;
    public static final Stack debugStackOfCurrentlyUsedObjects;
    protected BT_Class t_boolean = null;
    protected BT_Class t_byte = null;
    protected BT_Class t_char = null;
    protected BT_Class t_double = null;
    protected BT_Class t_float = null;
    protected BT_Class t_int = null;
    protected BT_Class t_long = null;
    protected BT_Class t_short = null;
    protected BT_Class t_void = null;
    protected int nClassesBeingRead_;
    protected final Stack classesToBeDereferenced_ = new Stack();
    protected static boolean doingQueuedDereferences_;
    protected static BT_Class java_lang_Object_Cache_;
    protected static BT_Class java_lang_String_Cache_;
    protected Vector classPath_ = null;

    static {
        locked = false;
        debugStackOfCurrentlyUsedObjects = new Stack();
        doingQueuedDereferences_ = false;
    }

    public BT_Repository(BT_Factory factory) {
        this.factory = factory;
    }

    public void addClass(BT_Class c) {
        if (!this.contains(c)) {
            this.classes.addElement(c);
        }
    }

    public BT_Class findClass(String name) {
        return this.forName(name);
    }

    public BT_Field findField(String cName, String fName, String type) {
        return this.findClass(cName).findField(fName, this.findClass(type));
    }

    public BT_Method findMethodGivenDescriptor(String cName, String mName, String descriptor) {
        return this.findClass(cName).findMethod(mName, BT_MethodSignature.create(descriptor, this));
    }

    public BT_Method findMethodWithArgs(String cName, String mName, String extArgs) {
        return this.findClass(cName).findMethod(mName, extArgs);
    }

    public BT_Method findMethod(String cName, String returnType, String mName, String args) {
        return this.findClass(cName).findMethod(mName, BT_MethodSignature.create(returnType, args, this));
    }

    public boolean contains(BT_Class c) {
        return this.classes.findClass(c.name) != null;
    }

    public int numberOfSystemClasses() {
        return this.classes.size() - this.numberOfProjectClasses();
    }

    public int numberOfProjectClasses() {
        int n = 0;
        int i = 0;
        while (i < this.classes.size()) {
            if (this.classes.elementAt(i).inProject()) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public void empty() {
        this.resetClassPath();
        locked = false;
        debugRecentlyUsedAttribute = null;
        debugRecentlyUsedClass = null;
        debugRecentlyUsedField = null;
        debugRecentlyUsedMethod = null;
        debugRecentlyWrittenAttribute = null;
        debugRecentlyWrittenClass = null;
        debugRecentlyWrittenField = null;
        debugRecentlyWrittenMethod = null;
        this.classes.removeAllElements();
        this.resources.removeAllElements();
        this.addClass(this.getBoolean());
        this.addClass(this.getChar());
        this.addClass(this.getFloat());
        this.addClass(this.getDouble());
        this.addClass(this.getByte());
        this.addClass(this.getShort());
        this.addClass(this.getInt());
        this.addClass(this.getLong());
        this.addClass(this.getVoid());
        this.clearPartOfRepository();
        BT_Method.clearPartOfRepository();
        BT_MethodSignature.clearPartOfRepository();
    }

    public void verify() throws BT_ClassFileException {
        int i = 0;
        while (i < this.classes.size()) {
            BT_Class c = this.classes.elementAt(i);
            if (c.inProject()) {
                int n = c.methods.size() - 1;
                while (n >= 0) {
                    BT_Method m = c.methods.elementAt(n);
                    BT_CodeAttribute code = m.getCode();
                    if (!(m.isAbstract() || m.isNative() || m.cls.isStub() || code != null)) {
                        throw new BT_ClassFileException("Method " + m + " is not abstract nor native nor in a stub, yet has no code body");
                    }
                    if (code != null) {
                        code.verify();
                    }
                    --n;
                }
                if (c.isClass) {
                    n = 0;
                    while (n < c.parents_.size()) {
                        if (c.parents_.elementAt((int)n).isInterface) {
                            BT_Repository.verifyImplements(c, c.parents_.elementAt(n));
                        }
                        ++n;
                    }
                }
            }
            ++i;
        }
    }

    protected static void verifyImplements(BT_Class c, BT_Class itf) throws BT_ClassFileException {
        int n = 0;
        while (n < itf.methods.size()) {
            BT_Method m = itf.methods.elementAt(n);
            if (!m.isStaticInitializer()) {
                c.findInheritedMethod(m.name, m.signature, itf);
                if (c == null) {
                    throw new BT_ClassFileException("Class " + c.name + BT_Base.endl() + " -- implements interface " + itf.name + BT_Base.endl() + " -- but does not implement method " + m);
                }
            }
            ++n;
        }
        int k = 0;
        while (k < itf.parents_.size()) {
            if (itf.parents_.elementAt((int)k).isInterface) {
                BT_Repository.verifyImplements(c, itf.parents_.elementAt(k));
            }
            ++k;
        }
    }

    public void print(PrintStream ps, int printFlags) {
        boolean printEvenSystemClasses = (printFlags & 4) != 0;
        int i = 0;
        while (i < this.classes.size()) {
            BT_Class c = this.classes.elementAt(i);
            if (printEvenSystemClasses || c.inProject()) {
                c.print(ps, printFlags);
            }
            ++i;
        }
    }

    public void print(PrintStream ps) {
        this.print(ps, 0);
    }

    public void count(PrintStream ps, boolean printSystemClasses) {
        int n = 0;
        int nclasses = 0;
        int nmethods = 0;
        int nfields = 0;
        ps.println(String.valueOf(BT_Base.endl()) + "nr  #methods  #fields   class name");
        ps.println("-----------------------------------------------");
        int i = 0;
        while (i < this.classes.size()) {
            BT_Class c = this.classes.elementAt(i);
            if (printSystemClasses || c.inProject()) {
                ++nclasses;
                nmethods += c.methods.size();
                nfields += c.fields.size();
                ps.println(String.valueOf(n++) + "\t" + c.methods.size() + "\t" + c.fields.size() + "\t" + c.name);
            }
            ++i;
        }
        ps.println("-----------------------------------------------");
        ps.println("#classes  = " + nclasses);
        ps.println("#methods  = " + nmethods);
        ps.println("#fields   = " + nfields);
        ps.println("-----------------------------------------------");
    }

    public int save(String jarFileName) throws IOException {
        ZipEntry entry;
        debugRecentlyWrittenFileName = jarFileName;
        int nwritten = 0;
        File file = new File(jarFileName);
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        zos.setMethod(8);
        int n = 0;
        while (n < this.classes.size()) {
            BT_Class c = this.classes.elementAt(n);
            if (c.inProject()) {
                debugRecentlyWrittenClass = c;
                entry = new ZipEntry(String.valueOf(c.name.replace('.', '/')) + ".class");
                entry.setSize(0L);
                entry.setCrc(0L);
                zos.putNextEntry(entry);
                try {
                    c.write(new DataOutputStream(zos));
                }
                catch (Exception e) {
                    throw new IOException("Error writing class " + c.getName() + " to archive " + jarFileName);
                }
                zos.closeEntry();
                ++nwritten;
            }
            ++n;
        }
        n = 0;
        while (n < this.resources.size()) {
            BT_JarResource resource = this.resources.elementAt(n);
            entry = new ZipEntry(resource.name);
            entry.setSize(0L);
            entry.setCrc(0L);
            zos.putNextEntry(entry);
            zos.write(resource.contents);
            zos.closeEntry();
            ++nwritten;
            this.factory.noteResourceSaved(resource);
            ++n;
        }
        if (nwritten > 0) {
            zos.finish();
            zos.close();
        }
        return nwritten;
    }

    public void addResource(String name, byte[] contents) {
        if (contents == null) {
            throw new NullPointerException("Resource " + name + " contents = null");
        }
        this.resources.addElement(new BT_JarResource(name, contents));
    }

    public final BT_ClassVector getClasses() {
        return this.classes;
    }

    public static void printDebugRecentFields(PrintStream ps) {
        if (debugStackOfCurrentlyUsedObjects.size() != 0) {
            ps.println("    Current objects (recent first) ...");
            int i = debugStackOfCurrentlyUsedObjects.size() - 1;
            while (i != -1) {
                ps.println("          " + debugStackOfCurrentlyUsedObjects.elementAt(i));
                --i;
            }
        }
        ps.println("    Last read ...");
        ps.println("      AttributeName: " + debugRecentlyReadAttributeName);
        ps.println("      ClassName:     " + debugRecentlyReadClassName);
        ps.println("      FieldName:     " + debugRecentlyReadFieldName);
        ps.println("      MethodName:    " + debugRecentlyReadMethodName);
        ps.println("    from ...");
        ps.println("      FileName:      " + debugRecentlyReadFileName);
        ps.println();
        ps.println("    Recently used ...");
        ps.println("      Attribute:     " + debugRecentlyUsedAttribute);
        ps.println("      Class:         " + debugRecentlyUsedClass);
        ps.println("      Field:         " + debugRecentlyUsedField);
        ps.println("      Method:        " + debugRecentlyUsedMethod);
        ps.println();
        ps.println("    Last written ...");
        ps.println("      Attribute:     " + debugRecentlyWrittenAttribute);
        ps.println("      Class:         " + debugRecentlyWrittenClass);
        ps.println("      Field:         " + debugRecentlyWrittenField);
        ps.println("      Method:        " + debugRecentlyWrittenMethod);
        ps.println("    to ...");
        ps.println("      FileName:      " + debugRecentlyWrittenFileName);
    }

    public void updateMethodRelations() {
        if (this.factory.buildMethodRelationships) {
            int i = 0;
            while (i < this.classes.size()) {
                BT_Class clazz = this.classes.elementAt(i);
                clazz.buildMethodRelationships();
                ++i;
            }
        }
    }

    protected BT_Class createPrimitive(String name) {
        BT_Class c = this.createClass(name);
        c.name = name;
        this.addClass(c);
        c.isBasicTypeClass = true;
        c.setInProjectFalse();
        this.factory.noteClassLoaded(c, null, null);
        return c;
    }

    public BT_Class getBoolean() {
        if (this.t_boolean == null) {
            this.t_boolean = this.createPrimitive("boolean");
        }
        return this.t_boolean;
    }

    public BT_Class getByte() {
        if (this.t_byte == null) {
            this.t_byte = this.createPrimitive("byte");
        }
        return this.t_byte;
    }

    public BT_Class getChar() {
        if (this.t_char == null) {
            this.t_char = this.createPrimitive("char");
        }
        return this.t_char;
    }

    public BT_Class getDouble() {
        if (this.t_double == null) {
            this.t_double = this.createPrimitive("double");
        }
        return this.t_double;
    }

    public BT_Class getFloat() {
        if (this.t_float == null) {
            this.t_float = this.createPrimitive("float");
        }
        return this.t_float;
    }

    public BT_Class getInt() {
        if (this.t_int == null) {
            this.t_int = this.createPrimitive("int");
        }
        return this.t_int;
    }

    public BT_Class getLong() {
        if (this.t_long == null) {
            this.t_long = this.createPrimitive("long");
        }
        return this.t_long;
    }

    public BT_Class getShort() {
        if (this.t_short == null) {
            this.t_short = this.createPrimitive("short");
        }
        return this.t_short;
    }

    public BT_Class getVoid() {
        if (this.t_void == null) {
            this.t_void = this.createPrimitive("void");
        }
        return this.t_void;
    }

    protected BT_Class findClassIfPrimitive(String name) {
        if (name.equals("boolean")) {
            return this.getBoolean();
        }
        if (name.equals("byte")) {
            return this.getByte();
        }
        if (name.equals("char")) {
            return this.getChar();
        }
        if (name.equals("double")) {
            return this.getDouble();
        }
        if (name.equals("float")) {
            return this.getFloat();
        }
        if (name.equals("int")) {
            return this.getInt();
        }
        if (name.equals("long")) {
            return this.getLong();
        }
        if (name.equals("short")) {
            return this.getShort();
        }
        if (name.equals("void")) {
            return this.getVoid();
        }
        return null;
    }

    public static boolean isPrimitiveName(String name) {
        return name.equals("boolean") || name.equals("byte") || name.equals("char") || name.equals("double") || name.equals("float") || name.equals("int") || name.equals("long") || name.equals("short") || name.equals("void");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BT_Class readClass(InputStream is, Object file, String className, String canonFid) throws BT_ClassFileException, BT_DuplicateClassException, IOException {
        BT_Class bT_Class;
        ++this.nClassesBeingRead_;
        try {
            BT_Class gotC;
            debugRecentlyReadFileName = canonFid;
            debugRecentlyReadClassName = className;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            BT_ClassInfoUntilName classInfo = null;
            if (className == null) {
                classInfo = new BT_ClassInfoUntilName();
                classInfo.readUntilName(dis, file, this);
                className = classInfo.className;
            }
            if ((gotC = this.classes.findClass(className)) == null) {
                gotC = this.createStub(className);
            } else if (!gotC.isStub()) {
                throw new BT_DuplicateClassException("Tried to read an already existing class: " + gotC.getName(), gotC);
            }
            try {
                try {
                    gotC.setStub(false);
                    gotC.setInProject(this.factory.isProjectClass(className, file));
                    gotC.loadedFrom = canonFid;
                    if (classInfo == null) {
                        classInfo = new BT_ClassInfoUntilName();
                        classInfo.readUntilName(dis, file, this);
                        if (!this.validClassVersion(classInfo.majorVersion, classInfo.minorVersion)) {
                            gotC.setThrowsUnsupportedClassVersionError();
                            throw new BT_ClassFileException("The class file of " + className + " has wrong internal version number: " + classInfo.majorVersion + "." + classInfo.minorVersion);
                        }
                        if (!classInfo.className.equals(className)) {
                            gotC.setThrowsNoClassDefFoundErrorTrue();
                            throw new BT_ClassFileException("The class file of " + className + " has internal name " + classInfo.className);
                        }
                    }
                    gotC.readAfterName(dis, file, classInfo);
                }
                catch (BT_ClassFileException e) {
                    if (!gotC.throwsAnyError()) {
                        gotC.setThrowsClassFormatErrorTrue();
                    }
                    e.addMessage("while reading class " + gotC.name);
                    throw e;
                }
                catch (IOException e) {
                    gotC.setThrowsClassFormatErrorTrue();
                    throw e;
                }
                catch (InternalError e) {
                    gotC.setThrowsClassFormatErrorTrue();
                    throw e;
                }
                catch (RuntimeException e) {
                    gotC.setThrowsClassFormatErrorTrue();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.factory.noteClassLoaded(gotC, canonFid, dis);
                this.classesToBeDereferenced_.push(gotC);
                if (!gotC.inProject() || gotC.pool == null) throw throwable;
                try {
                    gotC.setStub(true);
                    gotC.pool.closure();
                    gotC.setStub(false);
                    throw throwable;
                }
                catch (BT_ClassFileException e) {
                    gotC.setStub(false);
                    gotC.setThrowsClassFormatErrorTrue();
                    throw e;
                }
                catch (InternalError e) {
                    gotC.setStub(false);
                    gotC.setThrowsClassFormatErrorTrue();
                    throw e;
                }
            }
            Object var9_14 = null;
            this.factory.noteClassLoaded(gotC, canonFid, dis);
            this.classesToBeDereferenced_.push(gotC);
            if (gotC.inProject() && gotC.pool != null) {
                try {
                    gotC.setStub(true);
                    gotC.pool.closure();
                    gotC.setStub(false);
                }
                catch (BT_ClassFileException e) {
                    gotC.setStub(false);
                    gotC.setThrowsClassFormatErrorTrue();
                    throw e;
                }
                catch (InternalError e) {
                    gotC.setStub(false);
                    gotC.setThrowsClassFormatErrorTrue();
                    throw e;
                }
            }
            bT_Class = gotC;
            Object var12_20 = null;
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            is.close();
            --this.nClassesBeingRead_;
            if (this.nClassesBeingRead_ != 0) throw throwable;
            this.doQueuedDereferences();
            throw throwable;
        }
        is.close();
        --this.nClassesBeingRead_;
        if (this.nClassesBeingRead_ != 0) return bT_Class;
        this.doQueuedDereferences();
        return bT_Class;
    }

    protected boolean validClassVersion(int major, int minor) {
        return true;
    }

    public BT_Class createStub(String name) {
        BT_Class c = this.createClass(name);
        c.name = name;
        c.setStub(true);
        c.setInProjectFalse();
        c.becomePublic();
        this.addClass(c);
        return c;
    }

    protected void doQueuedDereferences() {
        if (doingQueuedDereferences_) {
            return;
        }
        doingQueuedDereferences_ = true;
        InternalError firstInternalError = null;
        RuntimeException firstRuntimeException = null;
        try {
            int i = 0;
            while (i != this.classesToBeDereferenced_.size()) {
                block13: {
                    try {
                        ((BT_Class)this.classesToBeDereferenced_.elementAt(i)).dereference();
                    }
                    catch (InternalError e) {
                        if (firstInternalError == null) {
                            firstInternalError = e;
                        }
                    }
                    catch (RuntimeException e) {
                        if (firstRuntimeException != null) break block13;
                        firstRuntimeException = e;
                    }
                }
                ++i;
            }
            if (this.factory.buildMethodRelationships) {
                while (!this.classesToBeDereferenced_.empty()) {
                    BT_MethodRelationships.linkInlawsCausedByThisClass((BT_Class)this.classesToBeDereferenced_.pop());
                }
            } else {
                this.classesToBeDereferenced_.removeAllElements();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            doingQueuedDereferences_ = false;
            throw throwable;
        }
        Object var5_9 = null;
        doingQueuedDereferences_ = false;
        if (firstInternalError != null) {
            throw firstInternalError;
        }
        if (firstRuntimeException != null) {
            throw firstRuntimeException;
        }
    }

    public BT_Class loadFromFile(File file) throws BT_DuplicateClassException {
        BT_Class gotC = null;
        try {
            String canonFid = file.getCanonicalPath();
            int i = 0;
            while (i < this.classes.size()) {
                BT_Class oc = this.classes.elementAt(i);
                if (oc.loadedFrom != null && oc.loadedFrom.equals(canonFid)) {
                    return oc;
                }
                ++i;
            }
            gotC = this.readClass(new FileInputStream(file), file, null, canonFid);
        }
        catch (BT_DuplicateClassException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleClassReadingError(e, gotC, "", file.getPath());
            gotC = null;
        }
        catch (InternalError e) {
            this.handleClassReadingError(e, gotC, "", file.getPath());
            gotC = null;
        }
        return gotC;
    }

    protected void handleClassReadingError(Throwable e, BT_Class gotC, String cnm, String fnm) {
        if (e instanceof IOException) {
            this.factory.noteClassReadIOException(cnm, fnm, (IOException)e);
        } else if (e instanceof BT_Exception) {
            ((BT_Exception)e).addMessage("loading " + cnm);
            this.factory.noteClassVerifyFailure(cnm, fnm, e.getMessage(), e);
        } else {
            this.factory.noteClassVerifyFailure(cnm, fnm, "General exception", e);
        }
    }

    public BT_Class loadFromClassPath(String cnm, BT_ClassPathEntry.BT_ClassPathLocation location) {
        BT_Class gotC = null;
        String fnm = location.getClassPathEntry().getEntryCanonicalName();
        if (loadSystemClassesUsingReflection && !this.factory.isProjectClass(cnm, null) && (gotC = this.readSystemClass(cnm)) != null) {
            return gotC;
        }
        try {
            gotC = this.readClass(location.getInputStream(), location.getFileObject(), cnm, fnm);
        }
        catch (Exception e) {
            this.handleClassReadingError(e, gotC, cnm, fnm);
        }
        catch (InternalError e) {
            this.handleClassReadingError(e, gotC, cnm, fnm);
        }
        return gotC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BT_Class forName(String cnm) {
        BT_Class c = this.classes.findClass(cnm);
        if (c != null) {
            return c;
        }
        try {
            if (cnm.endsWith("]")) {
                c = this.createClass(cnm);
                c.initAsArray(cnm);
                this.factory.noteClassLoaded(c, null, null);
                return c;
            }
            c = this.findClassIfPrimitive(cnm);
            if (c != null) {
                return c;
            }
            String fnm = BT_Repository.fileNameForClassName(cnm);
            BT_ClassPathEntry.BT_ClassPathLocation location = this.findInClassPath(fnm);
            if (location == null) {
                return this.factory.noteClassNotFound(cnm, this);
            }
            c = this.loadFromClassPath(cnm, location);
            if (c != null) return c;
            c = this.createStub(cnm);
            return c;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            throw throwable;
        }
    }

    public BT_Class forName(String name, boolean wantInterface) {
        BT_Class c = this.forName(name);
        return c;
    }

    public BT_Class findJavaLangObject() {
        if (java_lang_Object_Cache_ == null) {
            java_lang_Object_Cache_ = this.forName("java.lang.Object", false);
        }
        return java_lang_Object_Cache_;
    }

    public BT_Class findJavaLangString() {
        if (java_lang_String_Cache_ == null) {
            java_lang_String_Cache_ = this.forName("java.lang.String", false);
        }
        return java_lang_String_Cache_;
    }

    void clearPartOfRepository() {
        this.classesToBeDereferenced_.removeAllElements();
        java_lang_Object_Cache_ = null;
    }

    public static String classFileNameToClassName(String f) {
        int index = f.lastIndexOf(".class");
        return f.substring(0, index).replace('/', '.').replace('\\', '.').replace(File.separatorChar, '.');
    }

    BT_Class readSystemClass(String name) {
        Class<?> jlc;
        try {
            jlc = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Cannot find " + name);
            return null;
        }
        BT_Class c = this.createClass(name);
        c.name = name;
        this.addClass(c);
        c.setInProjectFalse();
        this.factory.noteClassLoaded(c, null, null);
        ++this.nClassesBeingRead_;
        c.initializeFromClass(jlc);
        --this.nClassesBeingRead_;
        return c;
    }

    public static String fileNameForClassName(String className) {
        return String.valueOf(className.replace('.', '/')) + ".class";
    }

    public static final String getSourcePath() {
        return sourcePath;
    }

    public static final void setSourcePath(String path) {
        sourcePath = path;
    }

    public BT_ClassPathEntry.BT_ClassPathLocation findInClassPath(String fnm) {
        Vector cpv = this.getClassPathVector();
        int n = 0;
        while (n < cpv.size()) {
            BT_ClassPathEntry cpe = (BT_ClassPathEntry)cpv.elementAt(n);
            BT_ClassPathEntry.BT_ClassPathLocation location = cpe.findFile(fnm);
            if (location != null) {
                return location;
            }
            ++n;
        }
        return null;
    }

    protected final Vector getClassPathVector() {
        if (this.classPath_ == null) {
            this.classPath_ = new Vector();
            this.prependClassPath(System.getProperty("java.class.path", "."));
        }
        return this.classPath_;
    }

    public void prependClassPath(String path) {
        this.appendOrPrependClassPath(path, false);
    }

    public void appendClassPath(String path) {
        this.appendOrPrependClassPath(path, true);
    }

    protected void appendOrPrependClassPath(String path, boolean append) {
        Vector cpv = this.getClassPathVector();
        String c = path.replace('\\', '/');
        StringTokenizer tokenizer = new StringTokenizer(c, File.pathSeparator, false);
        int j = 0;
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            BT_ClassPathEntry cpe;
            String tok = tokenizer.nextToken();
            if (!tok.equals("") && (cpe = this.createClassPathEntry(tok)) != null) {
                if (append) {
                    cpv.addElement(cpe);
                } else {
                    cpv.insertElementAt(cpe, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void resetClassPath() {
        this.getClassPathVector().removeAllElements();
    }

    public void addClassPath(String path) {
        BT_ClassPathEntry cpe = this.createClassPathEntry(path);
        if (cpe != null) {
            this.getClassPathVector().addElement(cpe);
        }
    }

    protected BT_ClassPathEntry createClassPathEntry(String entryString) {
        File file = new File(entryString);
        if (file.exists()) {
            try {
                return new BT_ClassPathEntry(file);
            }
            catch (IOException ex) {
                return null;
            }
        }
        this.factory.noteClassPathProblem(entryString, "Classpath entry " + entryString + " is not an existing directory nor .jar/.zip file");
        return null;
    }

    public String classPathToString() {
        String sep = File.pathSeparator;
        StringBuffer buf = new StringBuffer();
        Vector cpv = this.getClassPathVector();
        int i = 0;
        while (i < cpv.size()) {
            buf.append(String.valueOf(((BT_ClassPathEntry)cpv.elementAt(i)).getEntryCanonicalName()) + sep);
            ++i;
        }
        return buf.toString();
    }

    public BT_ConstantPool createConstantPool(char mode, String inClassName, Object file) {
        if (mode != 'n' && mode != 'r' && mode != 'w') {
            BT_Base.fatal("Oops 11 " + mode + " " + inClassName + " " + file);
        }
        if (mode != 'r' && inClassName == null) {
            BT_Base.fatal("Oops 12 " + mode + " " + inClassName + " " + file);
        }
        if (mode == 'r' && file == null) {
            BT_Base.fatal("Oops 13 " + mode + " " + inClassName + " " + file);
        }
        if (mode != 'r' && file != null) {
            BT_Base.fatal("Oops 14 " + mode + " " + inClassName + " " + file);
        }
        if (inClassName != null && inClassName.equals("")) {
            BT_Base.fatal("Oops 15 " + mode + " " + inClassName + " " + file);
        }
        return new BT_ConstantPool(this, inClassName);
    }

    public BT_Class createClass(String nameComment) {
        return new BT_Class(this);
    }

    public BT_Method createMethod(BT_Class c) {
        return new BT_Method(c);
    }

    public BT_Field createField(BT_Class c) {
        return new BT_Field(c);
    }

    public BT_Attribute createGenericAttribute(String name, byte[] data, Object container, BT_ConstantPool pool) throws BT_ClassFileException, IOException {
        return new BT_GenericAttribute(name, data, container);
    }

    public BT_MethodCallSite createMethodCallSite(BT_Method from, BT_MethodRefIns instruction, BT_Method to) {
        return new BT_MethodCallSite(from, instruction, to);
    }

    public BT_Accessor createAccessor(BT_Method from, BT_FieldRefIns instruction, BT_Field to) {
        return new BT_Accessor(from, instruction, to);
    }
}

