/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_Opcodes;
import com.ibm.jikesbt.BT_Repository;

public final class BT_Optimizer
implements BT_Opcodes {
    static final boolean TRACE = false;

    public static void optimize(boolean strict, BT_Repository repo) {
        int n = 0;
        while (n < repo.classes.size()) {
            BT_Class c = repo.classes.elementAt(n);
            if (c.inProject()) {
                BT_Optimizer.optimize(c, strict);
            }
            ++n;
        }
    }

    public static boolean optimize(BT_Class c, boolean strict) {
        if (!c.inProject()) {
            return false;
        }
        boolean result = false;
        int i = c.methods.size() - 1;
        while (i >= 0) {
            result |= BT_Optimizer.optimize(c.methods.elementAt(i), strict);
            --i;
        }
        return result;
    }

    public static boolean optimize(BT_Method m, boolean strict) {
        BT_CodeAttribute code = m.getCode();
        if (code == null) {
            return false;
        }
        boolean result = code.optimize(strict);
        if (result) {
            code.computeInstructionSizes();
        }
        return result;
    }
}

