/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_NewArrayIns
extends BT_Ins {
    private short typeNumber_;
    private BT_Repository repository;

    public short getTypeNumber() {
        return this.typeNumber_;
    }

    BT_NewArrayIns(BT_Class primitive) {
        super(188);
        if (primitive == null) {
            BT_Base.assert("The class must be a primitive -- not null");
        }
        this.repository = primitive.repository;
        if (primitive == this.repository.getBoolean()) {
            this.typeNumber_ = (short)4;
        } else if (primitive == this.repository.getByte()) {
            this.typeNumber_ = (short)8;
        } else if (primitive == this.repository.getChar()) {
            this.typeNumber_ = (short)5;
        } else if (primitive == this.repository.getDouble()) {
            this.typeNumber_ = (short)7;
        } else if (primitive == this.repository.getFloat()) {
            this.typeNumber_ = (short)6;
        } else if (primitive == this.repository.getInt()) {
            this.typeNumber_ = (short)10;
        } else if (primitive == this.repository.getLong()) {
            this.typeNumber_ = (short)11;
        } else if (primitive == this.repository.getShort()) {
            this.typeNumber_ = (short)9;
        } else {
            BT_Base.assert("The class must be a primitive -- not " + primitive);
        }
    }

    BT_NewArrayIns(int opcode, int index, short typeNumber, BT_Repository repository) throws BT_ClassFileException {
        super(opcode, index);
        this.repository = repository;
        switch (typeNumber) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new BT_ClassFileException("invalid primitive type in newarray instruction");
            }
        }
        this.typeNumber_ = typeNumber;
    }

    public BT_Class getClassTarget() {
        switch (this.typeNumber_) {
            case 4: {
                return this.repository.getBoolean();
            }
            case 8: {
                return this.repository.getByte();
            }
            case 5: {
                return this.repository.getChar();
            }
            case 7: {
                return this.repository.getDouble();
            }
            case 6: {
                return this.repository.getFloat();
            }
            case 10: {
                return this.repository.getInt();
            }
            case 11: {
                return this.repository.getLong();
            }
            case 9: {
                return this.repository.getShort();
            }
        }
        BT_Base.assert("Invalid primitive type: " + this.typeNumber_);
        return null;
    }

    private String typeName() {
        return this.getClassTarget().name;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeByte(this.opcode);
        dos.writeByte(this.typeNumber_);
    }

    public Object clone() {
        return new BT_NewArrayIns(this.getClassTarget());
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " " + this.typeName();
    }

    public String toAssemblerString() {
        return String.valueOf(BT_Misc.opcodeName[this.opcode]) + " " + this.typeName();
    }
}

