/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_NewIns;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_MultiANewArrayIns
extends BT_NewIns {
    public short dimensions;

    BT_MultiANewArrayIns(int opcode, int index, String name, short dimensions, BT_Repository repo) throws BT_ClassFileException {
        super(opcode, index, name, repo);
        this.dimensions = dimensions;
        if (dimensions < 1 || this.target.getArrayDimensions() < dimensions) {
            throw new BT_ClassFileException("invalid multianewarray instruction");
        }
    }

    public BT_MultiANewArrayIns(int opcode, BT_Class target, short dimensions) {
        super(opcode, target);
        this.dimensions = dimensions;
    }

    public Object clone() {
        return new BT_MultiANewArrayIns(this.opcode, this.target, this.dimensions);
    }

    public int getStackDiff() {
        return this.getPoppedStackDiff() + 1;
    }

    public int getPoppedStackDiff() {
        return -this.dimensions;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeByte(this.opcode);
        dos.writeShort(pool.indexOfClassRef(this.target));
        dos.writeByte(this.dimensions);
        if (this.size() != 4) {
            throw new InternalError("Write/size error " + this);
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " " + this.target.useName() + " " + this.dimensions;
    }
}

