/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassVector;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Opcodes;
import com.ibm.jikesbt.BT_Repository;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class BT_MethodSignature
implements BT_Opcodes {
    private static final boolean verbose = false;
    public final BT_Class returnType;
    public final BT_ClassVector types;
    String stringRepresentation;
    private int hash = 0;
    private static final Hashtable signatures = new Hashtable();

    private BT_MethodSignature(String intSig, BT_Repository repo) {
        this.returnType = repo.forName(BT_ConstantPool.getReturnType(intSig));
        this.types = BT_ConstantPool.getArgumentTypes(intSig, repo);
    }

    private BT_MethodSignature(String retExtType, String argExtTypes, BT_Repository repo) {
        this.types = new BT_ClassVector();
        StringTokenizer t = new StringTokenizer(argExtTypes.substring(1), ",) ");
        while (t.hasMoreTokens()) {
            this.types.addElement(repo.forName(t.nextToken()));
        }
        this.returnType = repo.forName(retExtType);
    }

    private BT_MethodSignature(BT_Class ret, BT_ClassVector args) {
        this.returnType = ret;
        this.types = args;
    }

    private BT_MethodSignature(Class returnTypeClass, Class[] args, BT_Repository repo) {
        this.types = new BT_ClassVector();
        int n = 0;
        while (n < args.length) {
            this.types.addElement(repo.forName(BT_ConstantPool.toJavaName(args[n].getName())));
            ++n;
        }
        this.returnType = repo.forName(BT_ConstantPool.toJavaName(returnTypeClass.getName()));
    }

    public static BT_MethodSignature create(String intSig, BT_Repository repo) {
        return BT_MethodSignature.find(intSig, repo);
    }

    public static BT_MethodSignature create(String retExtType, String argExtTypes, BT_Repository repo) {
        return BT_MethodSignature.find(new BT_MethodSignature(retExtType, argExtTypes, repo).toString(), repo);
    }

    public static BT_MethodSignature createUnique(String retExtType, String argExtTypes, BT_Repository repo) {
        return new BT_MethodSignature(retExtType, argExtTypes, repo);
    }

    public static BT_MethodSignature createUnique(BT_Class returnType, BT_ClassVector args) {
        return new BT_MethodSignature(returnType, args);
    }

    public static BT_MethodSignature create(BT_Class returnType, BT_ClassVector args, BT_Repository repo) {
        return BT_MethodSignature.find(new BT_MethodSignature(returnType, args).toString(), repo);
    }

    public static BT_MethodSignature create(Class returnType, Class[] args, BT_Repository repo) {
        return BT_MethodSignature.find(new BT_MethodSignature(returnType, args, repo).toString(), repo);
    }

    public static BT_MethodSignature find(String intSig, BT_Repository repo) {
        BT_MethodSignature found = (BT_MethodSignature)signatures.get(intSig);
        if (found != null) {
            return found;
        }
        BT_MethodSignature result = new BT_MethodSignature(intSig, repo);
        signatures.put(intSig, result);
        return result;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null || !otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        return otherObject.toString().equals(this.toString());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public int getArgsSize() {
        int size = 0;
        int n = 0;
        while (n < this.types.size()) {
            size += this.types.elementAt(n).getSizeForLocal();
            ++n;
        }
        return size;
    }

    public BT_MethodSignature addArgument(BT_Class type) {
        BT_MethodSignature newSig = new BT_MethodSignature(this.returnType, this.types);
        newSig.types.addElement(type);
        BT_MethodSignature oldSig = (BT_MethodSignature)signatures.get(newSig);
        if (oldSig != null) {
            return oldSig;
        }
        signatures.put(newSig, newSig);
        return newSig;
    }

    static void clearPartOfRepository() {
        signatures.clear();
    }

    public String toExternalArgumentString() {
        StringBuffer s = new StringBuffer("");
        int n = 0;
        while (n < this.types.size()) {
            if (n != 0) {
                s.append(",");
            }
            s.append(this.types.elementAt((int)n).name);
            ++n;
        }
        return s.toString();
    }

    public String toString() {
        if (this.stringRepresentation != null) {
            return this.stringRepresentation;
        }
        StringBuffer s = new StringBuffer("(");
        int n = 0;
        while (n < this.types.size()) {
            s.append(BT_ConstantPool.toInternalName(this.types.elementAt(n)));
            ++n;
        }
        s.append(")");
        s.append(BT_ConstantPool.toInternalName(this.returnType));
        this.stringRepresentation = s.toString();
        return this.stringRepresentation;
    }
}

