/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassDescendentVisitor;
import com.ibm.jikesbt.BT_ClassVector;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_MethodInlaw;
import com.ibm.jikesbt.BT_MethodVector;

final class BT_MethodRelationships
extends BT_Base {
    private BT_MethodRelationships() {
        throw new RuntimeException();
    }

    private static boolean isReallyParent(BT_Method frM, BT_Method targetM, BT_ClassVector candCs) {
        int i = 0;
        while (i < candCs.size()) {
            BT_Class candC = candCs.elementAt(i);
            BT_Method candM = candC.findMethodOrNull(frM.name, frM.signature);
            if (candM == targetM) {
                return true;
            }
            if (candM == null && BT_MethodRelationships.isReallyParent(frM, targetM, candC.parents_)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static BT_MethodVector findAllMethodsWhichCanBeInheritedByAClass(BT_Class ac) {
        BT_MethodVector ms = new BT_MethodVector();
        int im = 0;
        while (im < ac.methods.size()) {
            if (ac.methods.elementAt(im).canBeInherited()) {
                ms.addElement(ac.methods.elementAt(im));
            }
            ++im;
        }
        int ipc = 0;
        while (ipc < ac.parents_.size()) {
            BT_MethodVector pcs = BT_MethodRelationships.findAllMethodsWhichCanBeInheritedByAClass(ac.parents_.elementAt(ipc));
            int im2 = 0;
            while (im2 < pcs.size()) {
                if (ac.findMethodOrNull(pcs.elementAt((int)im2).name, pcs.elementAt((int)im2).signature) == null) {
                    ms.addElement(pcs.elementAt(im2));
                }
                ++im2;
            }
            ++ipc;
        }
        return ms;
    }

    private static void delinkParent(BT_Method kidM, BT_Method parM) {
        boolean removedP = kidM.parents.removeElement(parM);
        boolean removedK = parM.kids.removeElement(kidM);
    }

    static void delinkParents(BT_Method kidM) {
        int i = 0;
        while (i < kidM.parents.size()) {
            kidM.parents.elementAt((int)i).kids.removeElement(kidM);
            ++i;
        }
        kidM.parents.removeAllElements();
    }

    static void delinkKids(BT_Method parM) {
        int i = 0;
        while (i < parM.kids.size()) {
            parM.kids.elementAt((int)i).parents.removeElement(parM);
            ++i;
        }
        parM.kids.removeAllElements();
    }

    private static void linkParentAndKid(BT_Method parM, BT_Method kidM) {
        if (parM.kids.addUnique(kidM)) {
            boolean added = kidM.parents.addUnique(parM);
            BT_MethodRelationships.delinkInlawsWhichAreNowInherited(parM, kidM);
        }
    }

    private static void linkParentsInAClassOrAncestors(BT_Method frM, BT_Class pc) {
        BT_Method pm = pc.findMethodOrNull(frM.name, frM.signature);
        if (pm != null) {
            if (pm.canBeInherited()) {
                BT_MethodRelationships.linkParentAndKid(pm, frM);
            }
        } else {
            BT_MethodRelationships.linkParentsInAncestorsOfClass(frM, pc);
        }
    }

    private static void linkParentsInAncestorsOfClass(BT_Method frM, BT_Class ofC) {
        int i = 0;
        while (i < ofC.parents_.size()) {
            BT_MethodRelationships.linkParentsInAClassOrAncestors(frM, ofC.parents_.elementAt(i));
            ++i;
        }
    }

    static void linkParents(BT_Method frM) {
        BT_MethodRelationships.linkParentsInAncestorsOfClass(frM, frM.cls);
    }

    private static void linkKidsInOrDescendentsOfAClass(BT_Method frM, BT_Class desC) {
        BT_Method km = desC.findMethodOrNull(frM.name, frM.signature);
        if (km != null) {
            BT_MethodRelationships.linkParentAndKid(frM, km);
        } else {
            BT_MethodRelationships.linkKidsInDescendentsOfClass(frM, desC);
        }
    }

    private static void linkKidsInDescendentsOfClass(BT_Method frM, BT_Class of) {
        int i = 0;
        while (i < of.kids_.size()) {
            BT_MethodRelationships.linkKidsInOrDescendentsOfAClass(frM, of.kids_.elementAt(i));
            ++i;
        }
    }

    private static void linkKids(BT_Method frM) {
        BT_MethodRelationships.linkKidsInDescendentsOfClass(frM, frM.cls);
    }

    static void linkKidsOfAncestorMethodsThruAClass(BT_Class ancestorC, BT_ClassVector seenCs, BT_Class thruDescendentC) {
        int iParM = 0;
        while (iParM < ancestorC.methods.size()) {
            block5: {
                BT_Method parM = ancestorC.methods.elementAt(iParM);
                if (parM.canBeInherited()) {
                    int iSeenC = 0;
                    while (iSeenC < seenCs.size()) {
                        BT_Class seenC = seenCs.elementAt(iSeenC);
                        if (seenC.findMethodOrNull(parM.name, parM.signature) == null) {
                            ++iSeenC;
                            continue;
                        }
                        break block5;
                    }
                    BT_MethodRelationships.linkKidsInOrDescendentsOfAClass(parM, thruDescendentC);
                }
            }
            ++iParM;
        }
        seenCs.addElement(ancestorC);
        BT_ClassVector pcs = ancestorC.parents_;
        int ipc = 0;
        while (ipc < pcs.size()) {
            BT_MethodRelationships.linkKidsOfAncestorMethodsThruAClass(pcs.elementAt(ipc), seenCs, thruDescendentC);
            ++ipc;
        }
        seenCs.removeElementAt(seenCs.size() - 1);
    }

    static boolean relinkParentsOfMyAndDescendentMethods(BT_Class thisC) {
        int save = ++BT_Class.curMark_;
        RelinkDescendentMethodsCDV visitor = new RelinkDescendentMethodsCDV(BT_Class.curMark_, thisC.parents_.size() != 0);
        Boolean someBranches = (Boolean)visitor.visitAClassAndDescendents(thisC);
        return someBranches;
    }

    static void relinkParentsAndKidsOfDeletedMethod(BT_Method deldM) {
        int ipm = 0;
        while (ipm < deldM.parents.size()) {
            BT_Method parM = deldM.parents.elementAt(ipm);
            boolean found = parM.kids.removeElement(deldM);
            int ikm = 0;
            while (ikm < deldM.kids.size()) {
                BT_MethodRelationships.linkParentAndKid(parM, deldM.kids.elementAt(ikm));
                ++ikm;
            }
            ++ipm;
        }
        deldM.parents.removeAllElements();
        BT_MethodRelationships.delinkKids(deldM);
    }

    static void relinkParentsAndKidsOfAddedMethod(final BT_Method addedM) {
        BT_ClassDescendentVisitor cdv = new BT_ClassDescendentVisitor(){
            private boolean pathBranches_ = false;
            private Boolean someBranches_ = Boolean.FALSE;

            public void visit(BT_Class dc) {
                BT_Method dm;
                boolean saveBranches = this.pathBranches_;
                if (dc.parents_.size() != 1) {
                    this.pathBranches_ = true;
                    this.someBranches_ = Boolean.TRUE;
                }
                if ((dm = dc.findMethodOrNull(addedM.name, addedM.signature)) != null) {
                    if (dm.canInherit()) {
                        if (this.pathBranches_ || !addedM.canBeInherited()) {
                            BT_MethodRelationships.delinkParents(dm);
                            BT_MethodRelationships.linkParents(dm);
                        } else {
                            int ipdm = 0;
                            while (ipdm < dm.parents.size()) {
                                BT_Method pdm = dm.parents.elementAt(ipdm);
                                BT_MethodVector parKids = pdm.kids;
                                int ii = parKids.indexOf(dm);
                                boolean added = addedM.parents.addUnique(pdm);
                                if (added) {
                                    parKids.setElementAt(addedM, ii);
                                } else {
                                    parKids.removeElementAt(ii);
                                }
                                ++ipdm;
                            }
                            dm.parents.removeAllElements();
                            BT_MethodRelationships.linkParentAndKid(addedM, dm);
                        }
                    }
                } else {
                    super.visit(dc);
                }
                this.pathBranches_ = saveBranches;
            }
        };
        cdv.visitDescendents(addedM.cls);
        if (addedM.canInherit()) {
            BT_MethodRelationships.linkParents(addedM);
        }
    }

    static void delinkInlawPairByIndex(BT_Method frM, int frIx) {
        BT_MethodInlaw pair1 = frM.inlaws.elementAt(frIx);
        BT_Class causeC = pair1.cls_;
        BT_Method m2 = pair1.getOtherMethod(frM);
        m2.inlaws.depointInlaw(causeC, frM);
        frM.inlaws.removeElementAt(frIx);
    }

    static void delinkInlawsOfMethod(BT_Method frM) {
        int i = 0;
        while (i < frM.inlaws.size()) {
            BT_MethodInlaw thisPair = frM.inlaws.elementAt(i);
            BT_Method m2 = thisPair.getOtherMethod(frM);
            m2.inlaws.depointInlaw(thisPair.cls_, frM);
            ++i;
        }
        frM.inlaws.removeAllElements();
    }

    private static void delinkInlawsWhichAreNowInherited(BT_Method parM, BT_Method kidM) {
        int iPair = parM.inlaws.size() - 1;
        while (iPair != -1) {
            BT_MethodInlaw pair = parM.inlaws.elementAt(iPair);
            if (pair.getOtherMethod(parM) == kidM) {
                pair.getOtherMethod((BT_Method)parM).inlaws.depointInlaw(pair.cls_, parM);
                parM.inlaws.removeElementAt(iPair);
            }
            --iPair;
        }
    }

    static void delinkInlawsOfAllMethodsOfClassAndAncestors(BT_Class startC) {
        int im = 0;
        while (im < startC.methods.size()) {
            BT_MethodRelationships.delinkInlawsOfMethod(startC.methods.elementAt(im));
            ++im;
        }
        int ipc = 0;
        while (ipc < startC.parents_.size()) {
            BT_Class pc = startC.parents_.elementAt(ipc);
            BT_MethodRelationships.delinkInlawsOfAllMethodsOfClassAndAncestors(pc);
            ++ipc;
        }
    }

    private static void linkInlawPairIf(BT_Method m1, BT_Method m2, BT_Class causeC) {
        if (m1 != m2 && !m2.parents.contains(m1) && !m1.parents.contains(m2)) {
            BT_MethodInlaw pair = m1.inlaws.findInlawRecord(m2, causeC);
            if (pair == null) {
                pair = new BT_MethodInlaw(m1, m2, causeC);
                m1.inlaws.addElement(pair);
                m2.inlaws.addElement(pair);
            } else {
                pair.tempMark_ = BT_MethodInlaw.curMark_;
            }
        }
    }

    private static void linkInlawsOfAMethod_AndCausedByAClass_WithMethodsInAClassesOrTheirAncestors(BT_Method origM, BT_Class causeC, BT_Class exceptC, BT_ClassVector inlawCs) {
        int iInlawC = inlawCs.size() - 1;
        while (iInlawC != -1) {
            BT_Class inlawC = inlawCs.elementAt(iInlawC);
            if (inlawC != exceptC) {
                BT_Method inlawM = inlawC.findMethodOrNull(origM.name, origM.signature);
                if (inlawM != null) {
                    if (inlawM.canBeInherited()) {
                        BT_MethodRelationships.linkInlawPairIf(origM, inlawM, causeC);
                    }
                } else {
                    BT_MethodRelationships.linkInlawsOfAMethod_AndCausedByAClass_WithMethodsInAClassesOrTheirAncestors(origM, causeC, null, inlawC.parents_);
                }
            }
            --iInlawC;
        }
    }

    private static void linkInlawsOfAMethod_AndCausedByDescendentsOfAClass(BT_Method origM, BT_Class causeAncestorC) {
        BT_ClassVector kids = causeAncestorC.kids_;
        int ikc = 0;
        while (ikc < kids.size()) {
            BT_MethodRelationships.linkInlawsOfAMethod_AndCausedByAClassOrDescendents(origM, kids.elementAt(ikc), causeAncestorC);
            ++ikc;
        }
    }

    private static void linkInlawsOfAMethod_AndCausedByAClassOrDescendents(BT_Method origM, BT_Class causeC, BT_Class exceptC) {
        BT_Method km = causeC.findMethodOrNull(origM.name, origM.signature);
        if (km == null) {
            if (causeC.parents_.size() > 1) {
                BT_MethodRelationships.linkInlawsOfAMethod_AndCausedByAClass_WithMethodsInAClassesOrTheirAncestors(origM, causeC, exceptC, causeC.parents_);
            }
            BT_MethodRelationships.linkInlawsOfAMethod_AndCausedByDescendentsOfAClass(origM, causeC);
        }
    }

    private static void linkInlawsOfAMethod(BT_Method am) {
        if (!am.canBeInherited()) {
            return;
        }
        BT_MethodRelationships.linkInlawsOfAMethod_AndCausedByDescendentsOfAClass(am, am.cls);
    }

    static void linkInlawsAlongDescendentPath(BT_Class topC, BT_ClassVector seenCs, BT_Class botC, BT_Class exceptC) {
        int iTopM = 0;
        while (iTopM < topC.methods.size()) {
            block5: {
                BT_Method topM = topC.methods.elementAt(iTopM);
                if (topM.canBeInherited()) {
                    int iSeenC = 0;
                    while (iSeenC < seenCs.size()) {
                        BT_Class seenC = seenCs.elementAt(iSeenC);
                        if (seenC.findMethodOrNull(topM.name, topM.signature) == null) {
                            ++iSeenC;
                            continue;
                        }
                        break block5;
                    }
                    BT_MethodRelationships.linkInlawsOfAMethod_AndCausedByAClassOrDescendents(topM, botC, exceptC);
                }
            }
            ++iTopM;
        }
        seenCs.addElement(topC);
        BT_ClassVector pcs = topC.parents_;
        int ipc = 0;
        while (ipc < pcs.size()) {
            BT_MethodRelationships.linkInlawsAlongDescendentPath(pcs.elementAt(ipc), seenCs, botC, exceptC);
            ++ipc;
        }
        seenCs.removeElementAt(seenCs.size() - 1);
    }

    static void linkInlawsOfAllMethodsOfClassAndAncestors(BT_Class startC) {
        int im = 0;
        while (im < startC.methods.size()) {
            BT_MethodRelationships.linkInlawsOfAMethod(startC.methods.elementAt(im));
            ++im;
        }
        int ipc = 0;
        while (ipc < startC.parents_.size()) {
            BT_Class pc = startC.parents_.elementAt(ipc);
            BT_MethodRelationships.linkInlawsOfAllMethodsOfClassAndAncestors(pc);
            ++ipc;
        }
    }

    static void linkInlawsCausedByThisClass(BT_Class causeC) {
        if (causeC.parents_.size() >= 2) {
            BT_MethodVector[] inhMs = new BT_MethodVector[causeC.parents_.size()];
            int ic = 0;
            while (ic < causeC.parents_.size()) {
                BT_Class c = causeC.parents_.elementAt(ic);
                inhMs[ic] = BT_MethodRelationships.findAllMethodsWhichCanBeInheritedByAClass(c);
                ++ic;
            }
            int ipc1 = 0;
            while (ipc1 < causeC.parents_.size()) {
                int iam = 0;
                while (iam < inhMs[ipc1].size()) {
                    BT_Method am1 = inhMs[ipc1].elementAt(iam);
                    if (causeC.findMethodOrNull(am1.name, am1.signature) == null) {
                        int ipc2 = ipc1 + 1;
                        while (ipc2 < causeC.parents_.size()) {
                            BT_Method am2 = inhMs[ipc2].findMethod(am1.name, am1.signature);
                            if (am2 != null) {
                                BT_MethodRelationships.linkInlawPairIf(am1, am2, causeC);
                            }
                            ++ipc2;
                        }
                    }
                    ++iam;
                }
                ++ipc1;
            }
        }
    }

    static void relinkInlawsOfDeletedMethod(BT_Method deldM) {
        int ii = deldM.inlaws.size() - 1;
        while (ii != -1) {
            BT_MethodInlaw pair = deldM.inlaws.elementAt(ii);
            BT_MethodRelationships.delinkInlawPairByIndex(deldM, ii);
            int ipm = 0;
            while (ipm < deldM.parents.size()) {
                BT_MethodRelationships.linkInlawPairIf(pair.getOtherMethod(deldM), deldM.parents.elementAt(ipm), pair.cls_);
                ++ipm;
            }
            --ii;
        }
        int ipm1 = 0;
        while (ipm1 < deldM.parents.size()) {
            BT_Method pm1 = deldM.parents.elementAt(ipm1);
            if (pm1.canBeInherited()) {
                int ipm2 = 1 + ipm1;
                while (ipm2 < deldM.parents.size()) {
                    BT_Method pm2 = deldM.parents.elementAt(ipm2);
                    if (pm2.canBeInherited()) {
                        BT_MethodRelationships.linkInlawPairIf(pm1, pm2, deldM.cls);
                    }
                    ++ipm2;
                }
            }
            ++ipm1;
        }
    }

    static void relinkInlawsOfAddedMethod(BT_Method addedM) {
        int curMark = ++BT_MethodInlaw.curMark_;
        int ipm = 0;
        while (ipm < addedM.parents.size()) {
            BT_Method pm = addedM.parents.elementAt(ipm);
            BT_MethodRelationships.linkInlawsOfAMethod(pm);
            int ii = pm.inlaws.size() - 1;
            while (ii != -1) {
                BT_MethodInlaw pair = pm.inlaws.elementAt(ii);
                if (pair.tempMark_ != BT_MethodInlaw.curMark_) {
                    BT_MethodRelationships.delinkInlawPairByIndex(pm, ii);
                }
                --ii;
            }
            ++ipm;
        }
        BT_MethodRelationships.linkInlawsOfAMethod(addedM);
    }

    static void refreshInterMethodRelationships(BT_MethodVector ms) {
        BT_Method m;
        int im = 0;
        while (im < ms.size()) {
            m = ms.elementAt(im);
            BT_MethodRelationships.delinkParents(m);
            BT_MethodRelationships.delinkKids(m);
            BT_MethodRelationships.delinkInlawsOfMethod(m);
            ++im;
        }
        im = 0;
        while (im < ms.size()) {
            m = ms.elementAt(im);
            if (m.canInherit()) {
                BT_MethodRelationships.linkParents(m);
            }
            if (m.canBeInherited()) {
                BT_MethodRelationships.linkKids(m);
                BT_MethodRelationships.linkInlawsOfAMethod(m);
            }
            ++im;
        }
    }

    private static class RelinkDescendentMethodsCDV
    extends BT_ClassDescendentVisitor {
        private final int copiedCurMark_;
        private boolean pathBranches_;
        private Boolean someBranches_;

        RelinkDescendentMethodsCDV(int curMark, boolean parentBranches) {
            this.copiedCurMark_ = curMark;
            this.pathBranches_ = parentBranches;
            this.someBranches_ = parentBranches ? Boolean.TRUE : Boolean.FALSE;
        }

        public void visit(BT_Class dc) {
            dc.tempMark_ = this.copiedCurMark_;
            boolean saveBranches = this.pathBranches_;
            if (dc.parents_.size() > 1) {
                this.pathBranches_ = true;
                this.someBranches_ = Boolean.TRUE;
            }
            int idm = 0;
            while (idm < dc.methods.size()) {
                BT_Method dm = dc.methods.elementAt(idm);
                if (dm.canInherit()) {
                    if (this.pathBranches_) {
                        BT_MethodRelationships.delinkParents(dm);
                        BT_MethodRelationships.linkParents(dm);
                    } else {
                        BT_MethodVector dpms = dm.parents;
                        int idpm = dpms.size() - 1;
                        while (idpm != -1) {
                            BT_Method dpm = dpms.elementAt(idpm);
                            if (dpm.cls.tempMark_ != this.copiedCurMark_) {
                                BT_MethodRelationships.delinkParent(dm, dpm);
                            }
                            --idpm;
                        }
                    }
                }
                ++idm;
            }
            super.visit(dc);
            this.pathBranches_ = saveBranches;
        }

        public Object visitAClassAndDescendents(BT_Class dc) {
            super.visitAClassAndDescendents(dc);
            return this.someBranches_;
        }
    }
}

