/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_InvokeStaticIns;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_MethodSignature;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BT_MethodRefIns
extends BT_Ins {
    public BT_Method target;
    public int index = -1;
    public int localsInUse = -1;

    BT_MethodRefIns(int opcode, int index) {
        super(opcode, index);
    }

    BT_MethodRefIns(int opcode, int index, int poolIndex, BT_Method inM) throws BT_ClassFileException {
        this(opcode, index);
        BT_ConstantPool pool = inM.cls.pool;
        if (pool != null) {
            int expectedType = opcode == 185 ? 11 : 10;
            String className = pool.getClassNameAt(poolIndex, expectedType);
            String methodName = pool.getMethodNameAt(poolIndex);
            String signatureString = pool.getMethodTypeAt(poolIndex);
            BT_MethodSignature signature = BT_MethodSignature.create(signatureString, pool.getRepository());
            BT_Class targetClass = pool.getRepository().forName(className, opcode == 185);
            this.target = BT_MethodRefIns.findTarget(opcode, targetClass, methodName, signature, inM.cls);
            if (this.target == null) {
                this.target = targetClass.addStubMethod(methodName, signature);
                if (this instanceof BT_InvokeStaticIns) {
                    this.target.becomeStatic();
                }
                pool.getRepository().factory.noteUndeclaredMethod(this.target, "Instruction " + this + BT_Base.endl() + " -- in method " + inM);
            }
        }
    }

    private static BT_Method findTarget(int opcode, BT_Class targetClass, String methodName, BT_MethodSignature methodSignature, BT_Class referent) {
        if (targetClass.isStub() || opcode == 184 || opcode == 183) {
            return targetClass.findMethodOrNull(methodName, methodSignature);
        }
        return targetClass.findInheritedMethod(methodName, methodSignature, referent, true);
    }

    public boolean optimize(BT_CodeAttribute code, int n, boolean strict) {
        return false;
    }

    public void dereference(BT_InsVector ins) {
        this.target.addCallSite(this, ins.code.method);
    }

    public void remove() {
        this.target.removeCallSite(this);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.index = pool.indexOfMethodRef(this.target);
    }

    public BT_Method getMethodTarget() {
        return this.target;
    }

    public BT_Class getClassTarget() {
        return this.target.cls;
    }

    public BT_Method getTarget() {
        return this.target;
    }

    public void setTarget(BT_Method m) {
        this.target = m;
    }

    public void resetTarget(BT_Method m, BT_InsVector ins) {
        if (m != this.target) {
            this.remove();
            this.target = m;
            this.dereference(ins);
        }
    }

    public int getStackDiff() {
        int diff = this.getPoppedStackDiff();
        if (!this.target.isVoidMethod()) {
            diff += this.target.signature.returnType.getSizeForLocal();
        }
        return diff;
    }

    public int getPoppedStackDiff() {
        int diff = 0;
        int n = this.target.signature.types.size() - 1;
        while (n >= 0) {
            diff -= this.target.signature.types.elementAt(n).getSizeForLocal();
            --n;
        }
        if (this.opcode != 184) {
            --diff;
        }
        return diff;
    }

    int getOpcodeForPop(BT_Method target, int argNumber) {
        return target.signature.types.elementAt(argNumber).getOpcodeForPop();
    }

    public boolean sideEffectFreeMethod(BT_Method m) {
        if (m.cls.name.equals("java.lang.Math")) {
            return true;
        }
        if (m.cls.name.equals("java.awt.Color")) {
            return true;
        }
        if (m.cls.name.equals("java.lang.Runtime")) {
            if (m.name.equals("getRuntime")) {
                return true;
            }
            if (m.name.equals("freeMemory")) {
                return true;
            }
            if (m.name.equals("totalMemory")) {
                return true;
            }
        }
        return false;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeByte(this.opcode);
        dos.writeShort(this.index);
        if (this.size() != 3) {
            throw new InternalError("Write/size error " + this);
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode & 0xFF] + " " + this.target.getSignature().returnType + " " + this.target.useName();
    }

    public String toAssemblerString() {
        return String.valueOf(BT_Misc.opcodeName[this.opcode & 0xFF]) + " " + this.target.getSignature().returnType + " " + this.target.getDeclaringClass().getName() + "." + this.target.getName() + "(" + this.target.getSignature().toExternalArgumentString() + ")";
    }
}

