/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_ArrayEnumerator;
import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_MethodInlaw;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class BT_MethodInlawVector
extends BT_Base
implements Cloneable,
Serializable {
    protected int elementCount = 0;
    protected BT_MethodInlaw[] elementData;
    protected int capacityIncrement;
    private static final BT_MethodInlaw[] emptyData = new BT_MethodInlaw[0];
    private static final int DEFAULT_SIZE = 0;

    public BT_MethodInlawVector() {
        this(0, 0);
    }

    public BT_MethodInlawVector(int capacity) {
        this(capacity, 0);
    }

    public BT_MethodInlawVector(int capacity, int capacityIncrement) {
        this.elementData = capacity == 0 ? emptyData : new BT_MethodInlaw[capacity];
        this.capacityIncrement = capacityIncrement;
    }

    public void addElement(BT_MethodInlaw object) {
        this.insertElementAt(object, this.elementCount);
    }

    public int capacity() {
        return this.elementData.length;
    }

    public Object clone() {
        try {
            BT_MethodInlawVector vector = (BT_MethodInlawVector)super.clone();
            int length = this.elementData.length;
            vector.elementData = new BT_MethodInlaw[length];
            System.arraycopy(this.elementData, 0, vector.elementData, 0, length);
            return vector;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean contains(BT_MethodInlaw object) {
        return this.indexOf(object, 0) != -1;
    }

    public void copyInto(BT_MethodInlaw[] elements) {
        System.arraycopy(this.elementData, 0, elements, 0, this.elementCount);
    }

    public BT_MethodInlaw elementAt(int location) {
        if (location < this.elementCount) {
            return this.elementData[location];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Enumeration elements() {
        return new BT_ArrayEnumerator(this.elementData, this.elementCount);
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.elementData.length < minimumCapacity) {
            this.grow(minimumCapacity);
        }
    }

    public BT_MethodInlaw firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    private void grow(int newCapacity) {
        BT_MethodInlaw[] newData = new BT_MethodInlaw[newCapacity];
        System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    public int indexOf(BT_MethodInlaw object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(BT_MethodInlaw object, int location) {
        int i = location;
        while (i < this.elementCount) {
            BT_MethodInlaw element = this.elementData[i];
            if (element == object) {
                return i;
            }
            if (element != null && element.equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insertElementAt(BT_MethodInlaw object, int location) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            if (this.elementCount == this.elementData.length) {
                int newCapacity = (this.capacityIncrement == 0 ? this.elementCount : this.capacityIncrement) + this.elementCount;
                if (newCapacity == 0) {
                    ++newCapacity;
                }
                this.grow(newCapacity);
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy(this.elementData, location, this.elementData, location + 1, count);
            }
            this.elementData[location] = object;
            ++this.elementCount;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public BT_MethodInlaw lastElement() {
        try {
            return this.elementData[this.elementCount - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public int lastIndexOf(BT_MethodInlaw object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public int lastIndexOf(BT_MethodInlaw object, int location) {
        if (location < this.elementCount) {
            int i = location;
            while (i >= 0) {
                BT_MethodInlaw element = this.elementData[i];
                if (element == object) {
                    return i;
                }
                if (element != null && element.equals(object)) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public boolean removeElement(BT_MethodInlaw object) {
        int index = this.indexOf(object, 0);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    public void removeElementAt(int location) {
        if (location < this.elementCount) {
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy(this.elementData, location + 1, this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void setElementAt(BT_MethodInlaw object, int location) {
        if (location < this.elementCount) {
            this.elementData[location] = object;
            return;
        }
        throw new ArrayIndexOutOfBoundsException("Index: " + location);
    }

    public void setSize(int length) {
        this.ensureCapacity(length);
        if (this.elementCount > length) {
            int i = length;
            while (i < this.elementCount) {
                this.elementData[i] = null;
                ++i;
            }
        }
        this.elementCount = length;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int length = this.elementCount - 1;
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        int i = 0;
        while (i < length) {
            buffer.append(this.elementData[i]);
            buffer.append(',');
            ++i;
        }
        buffer.append(this.elementData[length]);
        buffer.append(']');
        return buffer.toString();
    }

    public void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }

    BT_MethodInlaw findInlawRecord(BT_Method m, BT_Class c) {
        int i = 0;
        while (i < this.size()) {
            BT_MethodInlaw p = this.elementAt(i);
            if ((m == p.method1_ || m == p.method2_) && c == p.cls_) {
                return p;
            }
            ++i;
        }
        return null;
    }

    void depointInlaw(BT_Class causeC, BT_Method toM) {
        int i = 0;
        while (i < this.size()) {
            BT_MethodInlaw p = this.elementAt(i);
            if ((toM == p.method1_ || toM == p.method2_) && causeC == p.cls_) {
                this.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public BT_MethodInlaw findMethod(BT_Method m) {
        int i = this.elementCount - 1;
        while (i != -1) {
            BT_MethodInlaw element = this.elementData[i];
            if (element.method1_ == m || element.method2_ == m) {
                return element;
            }
            --i;
        }
        return null;
    }

    public void sortArbitrarily() {
        boolean done = false;
        while (!done) {
            done = true;
            int i = this.elementCount - 1;
            while (i > 0) {
                int j = this.elementData[i - 1].compareTo(this.elementData[i]);
                if (j > 0) {
                    BT_MethodInlaw c = this.elementData[i];
                    this.elementData[i] = this.elementData[i - 1];
                    this.elementData[i - 1] = c;
                    done = false;
                }
                --i;
            }
        }
    }
}

