/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_AttributeVector;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ClassVector;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_ExceptionsAttribute;
import com.ibm.jikesbt.BT_Factory;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_LineNumberAttribute;
import com.ibm.jikesbt.BT_Member;
import com.ibm.jikesbt.BT_MethodCallSite;
import com.ibm.jikesbt.BT_MethodCallSiteVector;
import com.ibm.jikesbt.BT_MethodInlawVector;
import com.ibm.jikesbt.BT_MethodRefIns;
import com.ibm.jikesbt.BT_MethodRelationships;
import com.ibm.jikesbt.BT_MethodSignature;
import com.ibm.jikesbt.BT_MethodTable;
import com.ibm.jikesbt.BT_MethodVector;
import com.ibm.jikesbt.BT_NewIns;
import com.ibm.jikesbt.BT_Opcodes;
import com.ibm.jikesbt.BT_Repository;
import com.ibm.jikesbt.StringVector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class BT_Method
extends BT_Member
implements BT_Opcodes {
    private static final boolean TRACE = false;
    public BT_MethodCallSiteVector callSites = new BT_MethodCallSiteVector();
    BT_MethodVector parents;
    BT_MethodVector kids;
    final BT_MethodInlawVector inlaws;
    public BT_MethodSignature signature;
    private BT_CodeAttribute code_;
    private static BT_MethodSignature mainSigCache;
    static /* synthetic */ Class class$0;

    public void initializeFrom(Class returnType, Class[] args) {
        BT_ClassVector types = new BT_ClassVector();
        int n = 0;
        while (n < args.length) {
            BT_Class c = this.cls.getRepository().findClass(this.toJavaName(args[n]));
            if (c == null) {
                c = new BT_Class(this.toJavaName(args[n]), this.cls.getRepository());
            }
            types.addElement(c);
            ++n;
        }
        BT_Class retC = this.cls.getRepository().findClass(this.toJavaName(returnType));
        if (retC == null) {
            retC = new BT_Class(returnType.getName(), this.cls.getRepository());
        }
        this.signature = BT_MethodSignature.create(retC, types, this.cls.getRepository());
    }

    public void initializeFrom(Constructor m) {
        this.name = "<init>";
        this.flags = (short)m.getModifiers();
        this.initializeFrom(Void.TYPE, m.getParameterTypes());
    }

    public void initializeFrom(Method m) {
        this.name = m.getName();
        this.flags = (short)m.getModifiers();
        this.initializeFrom(m.getReturnType(), m.getParameterTypes());
        Class<?>[] etypes = m.getExceptionTypes();
        int n = 0;
        while (n < etypes.length) {
            this.declaredExceptions().addElement(this.cls.getRepository().findClass(etypes[n].getName()));
            ++n;
        }
    }

    public String toJavaName(Class c) {
        if (c.isArray()) {
            return BT_ConstantPool.toJavaName(c.getName());
        }
        return c.getName();
    }

    public BT_MethodVector getParents() {
        return this.parents;
    }

    public boolean isParentOf(BT_Method kidM) {
        return this.kids.contains(kidM);
    }

    public BT_MethodVector getKids() {
        return this.kids;
    }

    public boolean isKidOf(BT_Method parentM) {
        return this.parents.contains(parentM);
    }

    public BT_Method overrides() {
        int i = 0;
        while (i < this.parents.size()) {
            if (this.parents.elementAt((int)i).cls.isClass) {
                return this.parents.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public BT_MethodInlawVector getInlaws() {
        return this.inlaws;
    }

    public BT_MethodSignature getSignature() {
        return this.signature;
    }

    public void setSignature(BT_MethodSignature s) {
        BT_MethodSignature oldSig = this.signature;
        this.signature = s;
        this.signature.stringRepresentation = null;
        ((BT_MethodTable)this.cls.methods).update(this, this.getName(), oldSig);
    }

    public void updateName(String newName) {
        String oldName = this.name;
        this.name = newName;
        ((BT_MethodTable)this.cls.methods).update(this, oldName, this.signature);
    }

    public void updateReferences() {
    }

    public boolean sigEquals(BT_Method other) {
        return this.name.equals(other.name) && this.signature.equals(other.signature);
    }

    private final void initialize(short flags, BT_MethodSignature sig, String simpleName) {
        this.flags = flags;
        this.signature = sig;
        this.name = simpleName;
        this.cls.methods.addElement(this);
    }

    public BT_Method(BT_Class cls) {
        super(cls);
        this.parents = this.cls.getRepository().factory.buildMethodRelationships ? new BT_MethodVector() : null;
        this.kids = this.cls.getRepository().factory.buildMethodRelationships ? new BT_MethodVector() : null;
        this.inlaws = this.cls.getRepository().factory.buildMethodRelationships ? new BT_MethodInlawVector() : null;
    }

    public BT_Method(BT_Class cls, short flags, String simpleName, BT_MethodSignature sig) {
        super(cls);
        this.parents = this.cls.getRepository().factory.buildMethodRelationships ? new BT_MethodVector() : null;
        this.kids = this.cls.getRepository().factory.buildMethodRelationships ? new BT_MethodVector() : null;
        this.inlaws = this.cls.getRepository().factory.buildMethodRelationships ? new BT_MethodInlawVector() : null;
        this.initialize(flags, sig, simpleName);
    }

    public BT_Method(BT_Class cls, short flags, String returnType, String simpleName, String args, BT_CodeAttribute code) {
        this(cls, flags, returnType, simpleName, args);
        this.setCode(code);
    }

    public BT_Method(BT_Class cls, short flags, String returnType, String simpleName, String args) {
        this(cls, flags, simpleName, BT_MethodSignature.create(returnType, args, cls.getRepository()));
    }

    public BT_Method(BT_Class cls, String returnType, String simpleName, String args) {
        this(cls, 1, returnType, simpleName, args);
    }

    public BT_Method(BT_Class cls, String returnType, String simpleName, String args, BT_CodeAttribute code) {
        this(cls, 1, returnType, simpleName, args);
        this.setCode(code);
    }

    public static BT_Method createMethod(BT_Class inClass, short flags, BT_MethodSignature sig, String simpleName, BT_CodeAttribute code) {
        BT_Method m = inClass.repository.createMethod(inClass);
        m.initialize(flags, sig, simpleName);
        return m;
    }

    public void resetDeclaringClassAndName(BT_Class newC, String newNm) {
        if (this.cls.getRepository().factory.buildMethodRelationships) {
            BT_MethodRelationships.relinkInlawsOfDeletedMethod(this);
            BT_MethodRelationships.relinkParentsAndKidsOfDeletedMethod(this);
        }
        this.name = newNm;
        this.cls = newC;
        if (this.cls.getRepository().factory.buildMethodRelationships) {
            BT_MethodRelationships.relinkParentsAndKidsOfAddedMethod(this);
            BT_MethodRelationships.relinkInlawsOfAddedMethod(this);
        }
    }

    public void resetDeclaringClass(BT_Class newC) {
        this.resetDeclaringClassAndName(newC, this.name);
    }

    public void resetName(String newNm) {
        this.resetDeclaringClassAndName(this.cls, newNm);
    }

    final void read(DataInputStream dis, BT_ConstantPool pool) throws BT_ClassFileException, IOException {
        this.flags = dis.readShort();
        BT_Repository.debugRecentlyReadMethodName = this.name = pool.getSimpleNameAt(dis.readUnsignedShort());
        if (this.isStaticInitializer()) {
            this.flags = (short)(this.flags & 0x800 | 8);
        } else {
            int allFlags = this.flags & 0xD3F;
            int accessFlags = allFlags & 7;
            int otherFlags = allFlags & 0x93A;
            if ((this.cls.isInterface() && allFlags != 1025 || this.cls.isClass() && (accessFlags != 0 && accessFlags != 1 && accessFlags != 2 && accessFlags != 4 || this.isAbstract() && otherFlags != 0) || this.isConstructor() && (allFlags & 0xFFFFF7F8) != 0) && BT_Factory.strictVerification) {
                throw new BT_ClassFileException("invalid access flags for method " + this.name);
            }
        }
        String descriptor = pool.getMethodDescriptorAt(dis.readUnsignedShort());
        this.signature = BT_MethodSignature.create(descriptor, this.cls.getRepository());
        this.attributes = BT_AttributeVector.read(dis, pool, this);
        if (this.cls.inProject()) {
            this.code_ = (BT_CodeAttribute)this.attributes.getAttribute("Code");
            if ((this.isNative() || this.isAbstract()) != (this.code_ == null)) {
                throw new BT_ClassFileException("Code attribute misplaced or missing");
            }
        }
    }

    public boolean isVoidMethod() {
        return this.signature.returnType.name.equals("void");
    }

    public BT_CodeAttribute getCode() {
        return this.code_;
    }

    public void setCode(BT_CodeAttribute newCode) {
        if (this.code_ != null) {
            this.attributes.removeElement(this.code_);
            this.code_.setMethod(null);
        }
        this.code_ = newCode;
        if (newCode != null) {
            this.attributes.addElement(newCode);
            newCode.setMethod(this);
        }
    }

    public void removeCode() {
        if (this.code_ != null) {
            this.code_.removeAllInstructions();
            this.setCode(null);
        }
        this.becomeAbstract();
    }

    public void makeCodeSimplyReturn() {
        if (this.code_ != null) {
            this.code_.removeAllInstructions();
        }
        BT_Ins[] ins = new BT_Ins[]{BT_Ins.make(this.signature.returnType.getOpcodeForReturnValue()), BT_Ins.make(this.signature.returnType.getOpcodeForReturn())};
        this.setCode(new BT_CodeAttribute(ins));
        this.code_.maxStack = this.signature.returnType.getSizeForLocal();
    }

    public void makeCodeThrowVerifyError() {
        this.makeCodeThrowError("java.lang.VerifyError");
    }

    public void makeCodeThrowError(String errorClassName) {
        if (this.code_ != null) {
            this.code_.removeAllInstructions();
        }
        String methodName = "<init>";
        BT_MethodSignature signature = BT_MethodSignature.create(this.cls.getRepository().getVoid(), new BT_ClassVector(), this.cls.getRepository());
        BT_Class exceptionClass = this.cls.getRepository().forName(errorClassName);
        BT_Method initMethod = exceptionClass.findMethodOrNull(methodName, signature);
        if (initMethod == null) {
            initMethod = exceptionClass.addStubMethod(methodName, signature);
        }
        BT_Ins[] ins = new BT_Ins[]{new BT_NewIns(187, exceptionClass), BT_Ins.make(89), BT_Ins.make(183, initMethod), BT_Ins.make(191)};
        BT_CodeAttribute code = new BT_CodeAttribute(ins);
        this.setCode(code);
        int i = 0;
        while (i < ins.length) {
            ins[i].dereference(code.ins);
            ++i;
        }
        this.code_.maxStack = signature.returnType.getSizeForLocal();
    }

    protected void dereference() {
        if (this.code_ != null) {
            try {
                this.code_.dereference();
            }
            catch (InternalError e) {
                this.setThrowsVerifyErrorTrue();
                throw e;
            }
            catch (RuntimeException e) {
                this.setThrowsVerifyErrorTrue();
                throw e;
            }
        }
    }

    public BT_ClassVector declaredExceptions() {
        BT_Attribute ea = this.attributes.getAttribute("Exceptions");
        return ea != null ? ((BT_ExceptionsAttribute)ea).declaredExceptions : new BT_ClassVector();
    }

    static void clearPartOfRepository() {
        mainSigCache = null;
    }

    public boolean isAbstract() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isMain() {
        if (mainSigCache == null) {
            mainSigCache = BT_MethodSignature.create("void", "(java.lang.String[])", this.cls.getRepository());
        }
        return this.isStatic() && this.name.equals("main") && this.signature.equals(mainSigCache);
    }

    public boolean hasBackwardBranches() {
        BT_CodeAttribute code = this.getCode();
        return code == null ? false : code.hasBackwardBranches;
    }

    public boolean isSynchronized() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.flags & 0x100) != 0;
    }

    public BT_MethodCallSite addCallSite(BT_MethodRefIns ins, BT_Method caller) {
        if (!this.cls.repository.factory.buildMethodRelationships) {
            return null;
        }
        int n = this.callSites.size() - 1;
        while (n >= 0) {
            if (this.callSites.elementAt((int)n).instruction == ins) {
                return this.callSites.elementAt(n);
            }
            --n;
        }
        BT_MethodCallSite result = this.cls.repository.createMethodCallSite(caller, ins, this);
        this.callSites.addElement(result);
        return result;
    }

    public void removeCallSite(BT_Ins ins) {
        int n = this.callSites.size() - 1;
        while (n >= 0) {
            if (this.callSites.elementAt((int)n).instruction == ins) {
                this.callSites.removeElementAt(n);
            }
            --n;
        }
    }

    public BT_MethodCallSite findCallSite(BT_Ins ins) {
        int n = this.callSites.size() - 1;
        while (n >= 0) {
            if (this.callSites.elementAt((int)n).instruction == ins) {
                return this.callSites.elementAt(n);
            }
            --n;
        }
        return null;
    }

    public void removeCallSite(BT_MethodCallSite cs) {
        this.callSites.removeElement(cs);
    }

    public void becomePublic() {
        if (this.isPrivate() && !this.isStatic() && !this.isConstructor()) {
            return;
        }
        super.becomePublic();
    }

    public void becomePublicWithDescendents() {
        BT_MethodVector kids = this.getKids();
        int i = 0;
        while (i < kids.size()) {
            kids.elementAt(i).becomePublicWithDescendents();
            ++i;
        }
        this.becomePublic();
    }

    public void convertFromInstanceMethodToStatic() {
        boolean wasInstanceMethod = this.isInstanceMethod();
        this.becomeStatic();
        if (!wasInstanceMethod) {
            return;
        }
        String sig = this.signature.toString();
        this.signature = BT_MethodSignature.create("(" + BT_ConstantPool.toInternalName(this.cls) + sig.substring(1), this.cls.getRepository());
        if (this.cls.getRepository().factory.buildMethodRelationships) {
            BT_MethodRelationships.delinkParents(this);
            BT_MethodRelationships.delinkKids(this);
            BT_MethodRelationships.delinkInlawsOfMethod(this);
        }
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public boolean isStaticInitializer() {
        return this.name.equals("<clinit>");
    }

    public boolean isInstanceMethod() {
        return !this.isStaticInitializer() && !this.isConstructor() && !this.isStatic();
    }

    public boolean isClassMethod() {
        return !this.isStaticInitializer() && !this.isConstructor() && this.isStatic();
    }

    public boolean canBeInherited() {
        return !this.isStatic() && !this.isPrivate() && !this.isConstructor() && !this.isStaticInitializer() && !this.isFinal() && !this.cls.isFinal();
    }

    public boolean canInherit() {
        return !this.isStatic() && !this.isPrivate() && !this.isConstructor() && !this.isStaticInitializer();
    }

    public boolean callsNoOtherMethods() {
        if (this.code_ == null) {
            return false;
        }
        return this.code_.callsNoOtherMethods();
    }

    public int getOpcodeForInvoke() {
        if (this.isConstructor()) {
            return 183;
        }
        if (this.isStatic()) {
            return 184;
        }
        if (this.isPrivate()) {
            return 183;
        }
        if (this.cls.isInterface) {
            return 185;
        }
        return 182;
    }

    public void replaceInstructionWith(BT_Ins oldIns, BT_Ins newIns1, BT_Ins newIns2) {
        if (this.code_ == null) {
            return;
        }
        this.code_.replaceInstructionWith(oldIns, newIns1, newIns2);
    }

    final void resolve() {
        this.cls.pool.indexOfUtf8(this.name);
        this.cls.pool.indexOfUtf8(this.signature.toString());
        this.attributes.resolve(this.cls.pool);
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.isStub()) {
            return;
        }
        BT_Repository.debugRecentlyWrittenMethod = this;
        dos.writeShort(this.flags);
        dos.writeShort(pool.indexOfUtf8(this.name));
        dos.writeShort(pool.indexOfUtf8(this.signature.toString()));
        this.attributes.write(dos, pool);
    }

    public void print(PrintStream ps, int printFlags) {
        ps.print("\t" + this.accessString() + this.signature.returnType.name + " " + this.getName() + "(" + this.signature.toExternalArgumentString() + ") ");
        BT_ClassVector exceptions = this.declaredExceptions();
        if (exceptions.size() > 0) {
            ps.print(" throws ");
            int n = 0;
            while (n < exceptions.size()) {
                if (n > 0) {
                    ps.print(", ");
                }
                ps.print(exceptions.elementAt(n).fullName());
                ++n;
            }
            ps.println();
        }
        StringVector sort = new StringVector();
        if ((printFlags & 0x10) == 0 && this.cls.getRepository().factory.buildMethodRelationships) {
            String rel;
            int n = 0;
            while (n < this.parents.size()) {
                rel = this.cls.isInterface == this.parents.elementAt((int)n).cls.isInterface ? "Overrides" : "Implements";
                sort.addElement("\t\t// " + rel + " " + this.parents.elementAt(n).fullName());
                ++n;
            }
            sort.print(ps);
            sort.removeAllElements();
            n = 0;
            while (n < this.kids.size()) {
                rel = this.cls.isInterface == this.kids.elementAt((int)n).cls.isInterface ? "Overridden" : "Implemented";
                sort.addElement("\t\t// " + rel + " by " + this.kids.elementAt(n).fullName());
                ++n;
            }
            sort.print(ps);
            sort.removeAllElements();
            n = 0;
            while (n < this.inlaws.size()) {
                sort.addElement("\t\t// Inlaw " + this.inlaws.elementAt(n).getOtherMethod(this).fullName() + "  cause: " + this.inlaws.elementAt(n).getCls().fullName());
                ++n;
            }
            sort.print(ps);
            sort.removeAllElements();
            n = 0;
            while (n < this.callSites.size()) {
                sort.addElement("\t\t// Called from " + this.callSites.elementAt((int)n).from.fullName());
                ++n;
            }
            sort.print(ps);
            sort.removeAllElements();
        }
        if ((printFlags & 0x10) == 0) {
            int i = 0;
            while (i != this.attributes.size()) {
                BT_Attribute att = this.attributes.elementAt(i);
                if (!att.getName().equals("Code")) {
                    ps.println("\t" + att);
                }
                ++i;
            }
        }
        ps.println("{");
        if ((printFlags & 1) == 0) {
            if (this.code_ != null) {
                this.code_.print(ps, printFlags & 0x18);
            } else {
                ps.println("\t\t// method has no code segment???");
            }
        }
        ps.println("\t}");
    }

    public void print(PrintStream ps) {
        this.print(ps, 0);
    }

    public String fullName() {
        if (this.isConstructor()) {
            return this.cls.name;
        }
        return String.valueOf(this.cls.name) + "." + this.name;
    }

    public String useName() {
        return String.valueOf(this.fullName()) + "(" + this.signature.toExternalArgumentString() + ")";
    }

    public String toString() {
        return this.useName();
    }

    protected void replaceContents(BT_Method other) {
        super.replaceContents(other);
        this.code_ = other.code_;
        if (other.code_ != null) {
            other.code_.setMethod(this);
        }
        this.signature = other.signature;
    }

    public int findLineNumberForBytecode(int bcIndex) {
        BT_LineNumberAttribute lineNumberMap = null;
        int i = 0;
        while (i < this.getCode().attributes.size()) {
            BT_Attribute attr = this.getCode().attributes.elementAt(i);
            if (attr instanceof BT_LineNumberAttribute) {
                lineNumberMap = (BT_LineNumberAttribute)attr;
                BT_LineNumberAttribute.PcRange[] ranges = lineNumberMap.pcRanges;
                if (ranges.length == 1) {
                    return ranges[0].lineNumber;
                }
                int j = 0;
                while (j < ranges.length) {
                    int startPC = ranges[j].startPC;
                    if (bcIndex < startPC) {
                        if (j == 0) {
                            return 0;
                        }
                        return ranges[j - 1].lineNumber;
                    }
                    ++j;
                }
                return ranges[ranges.length - 1].lineNumber;
            }
            ++i;
        }
        return 0;
    }
}

