/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_Item;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_SwitchIns;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_LookupSwitchIns
extends BT_SwitchIns {
    public int[] values;

    public BT_LookupSwitchIns(int opcode, BT_Ins def, int[] values, BT_Ins[] targets) {
        super(opcode, def, targets);
        this.values = values;
    }

    BT_LookupSwitchIns(int opcode, int index, int defIntTarget, int[] values, int[] intTargets) {
        super(opcode, index, defIntTarget, intTargets);
        this.values = values;
    }

    public static BT_LookupSwitchIns make(int opcode, int offset, byte[] data, BT_Item item) {
        int start = (offset / 4 + 1) * 4;
        if (start + 8 > data.length) {
            throw new InternalError("Truncated instruction at " + offset + " of method " + item.fullName());
        }
        int def = offset - 8 + BT_Misc.bytesToInt(data, start);
        int npairs = BT_Misc.bytesToInt(data, start + 4);
        int size = start - offset + 8 + npairs * 8;
        if (start + (npairs + 1) * 8 > data.length) {
            throw new InternalError("Truncated instruction at " + offset + " of method " + item.fullName());
        }
        int[] values = new int[npairs];
        int[] intTargets = new int[npairs];
        int lastValue = 0;
        int m = 0;
        while (m < npairs) {
            int value = BT_Misc.bytesToInt(data, start + 8 + m * 8);
            if (m > 0 && value <= lastValue) {
                throw new InternalError("Invalid lookupswitch instruction at " + offset + " of method " + item.fullName());
            }
            values[m] = value;
            lastValue = value;
            intTargets[m] = offset - 8 + BT_Misc.bytesToInt(data, start + 8 + m * 8 + 4);
            ++m;
        }
        return new BT_LookupSwitchIns(opcode, offset - 8, def, values, intTargets);
    }

    public int size() {
        int start = (this.byteIndex / 4 + 1) * 4;
        int size = start - this.byteIndex + 8 + this.values.length * 8;
        return size;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeByte(this.opcode);
        int start = (this.byteIndex / 4 + 1) * 4;
        int n = this.byteIndex + 1;
        while (n < start) {
            dos.writeByte(0);
            ++n;
        }
        dos.writeInt(this.def.byteIndex - this.byteIndex);
        dos.writeInt(this.values.length);
        n = 0;
        while (n < this.targets.length) {
            dos.writeInt(this.values[n]);
            dos.writeInt(this.targets[n].byteIndex - this.byteIndex);
            ++n;
        }
    }

    public Object clone() {
        BT_Ins[] t = new BT_Ins[this.targets.length];
        int n = 0;
        while (n < t.length) {
            t[n] = this.targets[n];
            ++n;
        }
        int[] v = new int[this.values.length];
        int n2 = 0;
        while (n2 < v.length) {
            v[n2] = this.values[n2];
            ++n2;
        }
        return new BT_LookupSwitchIns(this.opcode, this.def, v, t);
    }

    public String toString() {
        String s = String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode];
        if (this.targets != null) {
            int n = 0;
            while (n < this.values.length) {
                s = String.valueOf(s) + BT_Base.endl() + "\t\t    when value is " + this.values[n] + " goto instruction at " + this.targets[n].byteIndex;
                ++n;
            }
            s = String.valueOf(s) + BT_Base.endl() + "\t\t    else goto instruction at " + this.def.byteIndex;
        }
        return s;
    }

    public String toAssemblerString() {
        StringBuffer s = new StringBuffer(BT_Misc.opcodeName[this.opcode]);
        s.append(" ");
        s.append(this.def.getLabel());
        s.append(" { ");
        int n = 0;
        while (n < this.values.length) {
            s.append(this.values[n]);
            s.append(" ");
            s.append(this.targets[n].getLabel());
            ++n;
        }
        s.append("}");
        return s.toString();
    }
}

