/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_Repository;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class BT_LocalVariableAttribute
extends BT_Attribute {
    public static final String ATTRIBUTE_NAME = "LocalVariableTable";
    public LV[] localVariables;
    private final BT_CodeAttribute inCode;

    public String getName() {
        return ATTRIBUTE_NAME;
    }

    public BT_LocalVariableAttribute(int ne, BT_CodeAttribute container) {
        this.inCode = container;
        this.localVariables = new LV[ne];
    }

    BT_LocalVariableAttribute(byte[] data, BT_ConstantPool pool, BT_CodeAttribute container) throws BT_ClassFileException, IOException {
        this.inCode = container;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        int ne = dis.readUnsignedShort();
        if (data.length != 2 + 10 * ne) {
            throw new BT_ClassFileException("LocalVariableTable attribute length");
        }
        this.localVariables = new LV[ne];
        int ie = 0;
        while (ie < this.localVariables.length) {
            int startPC = dis.readUnsignedShort();
            this.localVariables[ie] = new LV(startPC, startPC + dis.readUnsignedShort(), pool.getUtf8At(dis.readUnsignedShort()), pool.getUtf8At(dis.readUnsignedShort()), dis.readUnsignedShort(), pool.getRepository());
            ++ie;
        }
    }

    void dereference() {
        int ie = 0;
        while (ie < this.localVariables.length) {
            this.localVariables[ie].dereference(this.inCode);
            ++ie;
        }
    }

    public void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
        int ie = 0;
        while (ie < this.localVariables.length) {
            this.localVariables[ie].changeReferencesFromTo(oldIns, newIns);
            ++ie;
        }
    }

    public void resolve(BT_ConstantPool pool) {
        super.resolve(pool);
        int ie = 0;
        while (ie < this.localVariables.length) {
            this.localVariables[ie].resolve(pool);
            ++ie;
        }
    }

    protected int writtenLength() {
        return 8 + this.localVariables.length * 10;
    }

    void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeShort(pool.indexOfUtf8(ATTRIBUTE_NAME));
        dos.writeInt(2 + 10 * this.localVariables.length);
        dos.writeShort(this.localVariables.length);
        int ie = 0;
        while (ie < this.localVariables.length) {
            dos.writeShort(this.localVariables[ie].startIns.byteIndex);
            if (this.localVariables[ie].beyondIns != null) {
                dos.writeShort(this.localVariables[ie].beyondIns.byteIndex - this.localVariables[ie].startIns.byteIndex);
            } else {
                BT_Ins lastIns = this.inCode.ins.elementAt(this.inCode.ins.size() - 1);
                dos.writeShort(lastIns.byteIndex + lastIns.size() - this.localVariables[ie].startIns.byteIndex);
            }
            dos.writeShort(this.localVariables[ie].nameCPIx(pool));
            dos.writeShort(this.localVariables[ie].descriptorCPIx(pool));
            dos.writeShort(this.localVariables[ie].localIndex);
            ++ie;
        }
    }

    public String toString() {
        return "LocalVariableTable size=" + this.localVariables.length;
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(String.valueOf(prefix) + "LocalVariables:");
        int i = 0;
        while (i < this.localVariables.length) {
            ps.println(String.valueOf(prefix) + "  " + this.localVariables[i]);
            ++i;
        }
    }

    public boolean singletonRequired() {
        return false;
    }

    public static final class LV {
        private int startPC;
        public BT_Ins startIns;
        private int beyondPC;
        public BT_Ins beyondIns;
        public String nameS;
        public BT_Class descriptorC;
        public int localIndex;

        public LV(BT_Ins si, BT_Ins bi, String n, BT_Class c, int i) {
            this.startIns = si;
            this.beyondIns = bi;
            this.nameS = n;
            this.descriptorC = c;
            this.localIndex = i;
        }

        LV(int sp, int bp, String n, String descriptorS, int i, BT_Repository repo) {
            this.startPC = sp;
            this.beyondPC = bp;
            this.nameS = n;
            this.descriptorC = repo.forName(BT_ConstantPool.toJavaName(descriptorS));
            this.localIndex = i;
        }

        private void dereference(BT_CodeAttribute container) {
            this.startIns = container.ins.findInstruction(this.startPC);
            if (container.ins.size() > 0) {
                BT_Ins lastIns = container.ins.elementAt(container.ins.size() - 1);
                if (this.beyondPC <= lastIns.byteIndex) {
                    this.beyondIns = container.ins.findInstruction(this.beyondPC);
                }
            }
        }

        private void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
            if (this.startIns == oldIns) {
                this.startIns = newIns;
            }
            if (this.beyondIns == oldIns) {
                this.beyondIns = newIns;
            }
        }

        public int nameCPIx(BT_ConstantPool pool) {
            return pool.indexOfUtf8(this.nameS);
        }

        private int descriptorCPIx(BT_ConstantPool pool) {
            return pool.indexOfUtf8(BT_ConstantPool.toInternalName(this.descriptorC.getName()));
        }

        private void resolve(BT_ConstantPool pool) {
            this.nameCPIx(pool);
            this.descriptorCPIx(pool);
        }

        public String toString() {
            return "ix: " + this.localIndex + " " + this.nameS + " " + this.descriptorC.toString() + " startI: " + this.startIns + " beyondI: " + this.beyondIns;
        }
    }
}

