/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Local;
import com.ibm.jikesbt.BT_LocalVector;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BT_LocalIns
extends BT_Ins {
    public int base1;
    public int base2;
    public int localNr;
    public BT_Local target;
    public boolean wide;

    BT_LocalIns(int op, int localNr) {
        this(op, -1, localNr, -1, -1, false);
    }

    BT_LocalIns(int op, BT_Local l, int base1, int base2) {
        super(op, -1);
        this.base1 = base1;
        this.base2 = base2;
        this.target = l;
        this.localNr = l.localNr;
        this.setOpcode();
    }

    BT_LocalIns(int op, int index, int localNr, int base1, int base2, boolean wide) {
        super(op, index);
        this.base1 = base1;
        this.base2 = base2;
        this.localNr = localNr;
        this.wide = wide;
    }

    public void dereference(BT_InsVector items) {
        this.setTarget(items.locals);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.setTarget(ins.locals);
        this.setOpcode();
    }

    public void incrementLocalsAccessWith(int inc, int start, BT_LocalVector locals) {
        if (this.localNr < start) {
            return;
        }
        this.localNr += inc;
        this.setTarget(locals);
        this.setOpcode();
    }

    private void setOpcode() {
        this.opcode = this.localNr <= 3 ? this.base1 + this.localNr : this.base2;
        this.wide = this.localNr > 255;
    }

    private void setTarget(BT_LocalVector locals) {
        this.target = locals.elementAt(this.localNr);
        if (this.is2Slot()) {
            locals.elementAt(this.localNr + 1);
        }
    }

    public int size() {
        if (this.opcode != this.base2) {
            return 1;
        }
        return this.wide ? 4 : 2;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.opcode != this.base2) {
            dos.writeByte(this.base1 + this.localNr);
        } else if (this.wide) {
            dos.writeByte(196);
            dos.writeByte(this.base2);
            dos.writeShort(this.localNr);
        } else {
            dos.writeByte(this.base2);
            dos.writeByte(this.localNr);
        }
    }

    public String toString() {
        String s = super.toString();
        if (this.opcode == this.base2) {
            s = String.valueOf(s) + " " + this.localNr;
        }
        return s;
    }

    public String toAssemblerString() {
        String name;
        String s = super.toAssemblerString();
        if (this.opcode == this.base2) {
            s = String.valueOf(s) + " " + this.localNr;
        }
        if ((name = BT_CodeAttribute.getLocalName(this.localNr)).length() > 0) {
            s = String.valueOf(s) + "\t// " + name;
        }
        return s;
    }

    public boolean is2Slot() {
        return this.base2 == 22 || this.base2 == 24 || this.base2 == 55 || this.base2 == 57;
    }
}

