/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_Repository;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_LineNumberAttribute
extends BT_Attribute {
    public static final String ATTRIBUTE_NAME = "LineNumberTable";
    public PcRange[] pcRanges;
    private final BT_CodeAttribute inCode;

    public String getName() {
        return ATTRIBUTE_NAME;
    }

    public BT_LineNumberAttribute(int ne, BT_CodeAttribute container) {
        this.inCode = container;
        this.pcRanges = new PcRange[ne];
    }

    BT_LineNumberAttribute(byte[] data, BT_ConstantPool pool, BT_CodeAttribute container) throws BT_ClassFileException, IOException {
        this.inCode = container;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        int ne = dis.readUnsignedShort();
        if (data.length != 2 + 4 * ne) {
            throw new BT_ClassFileException("LineNumberTable attribute length");
        }
        this.pcRanges = new PcRange[ne];
        int ie = 0;
        while (ie < this.pcRanges.length) {
            this.pcRanges[ie] = new PcRange(dis.readUnsignedShort(), dis.readUnsignedShort());
            ++ie;
        }
    }

    void dereference() {
        int ie = 0;
        while (ie < this.pcRanges.length) {
            this.pcRanges[ie].dereference(this.inCode);
            ++ie;
        }
    }

    public void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
        int ie = 0;
        while (ie < this.pcRanges.length) {
            this.pcRanges[ie].changeReferencesFromTo(oldIns, newIns);
            ++ie;
        }
    }

    protected int writtenLength() {
        return 8 + this.pcRanges.length * 4;
    }

    void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        BT_Repository.debugRecentlyWrittenAttribute = this;
        dos.writeShort(pool.indexOfUtf8(ATTRIBUTE_NAME));
        dos.writeInt(2 + 4 * this.pcRanges.length);
        dos.writeShort(this.pcRanges.length);
        int ie = 0;
        while (ie < this.pcRanges.length) {
            if (this.pcRanges[ie].startIns == null) {
                dos.writeShort(0);
            } else {
                dos.writeShort(this.pcRanges[ie].startIns.byteIndex);
            }
            dos.writeShort(this.pcRanges[ie].lineNumber);
            ++ie;
        }
    }

    public String toString() {
        return "LineNumberTable size=" + this.pcRanges.length;
    }

    public boolean singletonRequired() {
        return false;
    }

    public static final class PcRange {
        public int startPC;
        public BT_Ins startIns;
        public int lineNumber;

        public PcRange(BT_Ins si, int ln) {
            this.startIns = si;
            this.lineNumber = ln;
        }

        PcRange(int sp, int ln) {
            this.startPC = sp;
            this.lineNumber = ln;
        }

        private void dereference(BT_CodeAttribute container) {
            this.startIns = container.ins.findInstruction(this.startPC);
        }

        private void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
            if (this.startIns == oldIns) {
                this.startIns = newIns;
            }
        }

        public String toString() {
            return "PR(line: " + this.lineNumber + " startI: " + this.startIns + ")";
        }
    }
}

