/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_JumpIns;

public final class BT_JumpOffsetIns
extends BT_JumpIns {
    public int relativeOffset;

    BT_JumpOffsetIns(int opcode, int offset) {
        this(opcode, -1, offset);
    }

    BT_JumpOffsetIns(int opcode, int byteIndex, int offset) {
        super(opcode, byteIndex);
        this.relativeOffset = offset;
    }

    public BT_JumpOffsetIns(int opcode, int byteIndex, BT_Ins target) {
        super(opcode, byteIndex);
        this.target = target;
        this.relativeOffset = target.byteIndex - byteIndex;
    }

    public boolean optimize(BT_CodeAttribute code, int n, boolean strict) {
        int offset;
        boolean wide;
        if (!strict && code.ins.size() > n + 1 && code.ins.elementAt(n + 1) == this.target) {
            switch (this.opcode) {
                case 167: {
                    return code.removeInstructionAt(n);
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    return code.replaceInstructionsAtWith(1, n, BT_Ins.make(87), BT_Ins.make(87));
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    return code.replaceInstructionsAtWith(1, n, BT_Ins.make(87));
                }
            }
        }
        if (this.opcode == 167 && this.target.opcode == 177) {
            return code.replaceInstructionsAtWith(1, n, BT_Ins.make(177));
        }
        if (this.opcode == 167 && code.ins.size() > n + 1) {
            BT_Ins next = code.ins.elementAt(n + 1);
            if (next.opcode == 167 && ((BT_JumpIns)next).target == this.target) {
                return code.removeInstructionAt(n);
            }
        }
        boolean bl = wide = (short)(offset = this.target.byteIndex - this.byteIndex) != offset;
        if (wide) {
            int negatedOpcode;
            switch (this.opcode) {
                case 159: {
                    negatedOpcode = 160;
                    break;
                }
                case 160: {
                    negatedOpcode = 159;
                    break;
                }
                case 161: {
                    negatedOpcode = 162;
                    break;
                }
                case 162: {
                    negatedOpcode = 161;
                    break;
                }
                case 163: {
                    negatedOpcode = 164;
                    break;
                }
                case 164: {
                    negatedOpcode = 163;
                    break;
                }
                case 165: {
                    negatedOpcode = 166;
                    break;
                }
                case 166: {
                    negatedOpcode = 165;
                    break;
                }
                case 198: {
                    negatedOpcode = 199;
                    break;
                }
                case 199: {
                    negatedOpcode = 198;
                    break;
                }
                case 153: {
                    negatedOpcode = 154;
                    break;
                }
                case 154: {
                    negatedOpcode = 153;
                    break;
                }
                case 155: {
                    negatedOpcode = 156;
                    break;
                }
                case 156: {
                    negatedOpcode = 155;
                    break;
                }
                case 157: {
                    negatedOpcode = 158;
                    break;
                }
                case 158: {
                    negatedOpcode = 157;
                    break;
                }
                default: {
                    negatedOpcode = -1;
                }
            }
            if (negatedOpcode != -1) {
                return code.replaceInstructionsAtWith(1, n, new BT_JumpOffsetIns(negatedOpcode, -1, code.ins.elementAt(n + 1)), BT_Ins.make(200, this.target));
            }
        }
        return false;
    }

    public void dereference(BT_InsVector ins) {
        if (this.target != null) {
            return;
        }
        this.target = ins.findBasicBlock(this.byteIndex + this.relativeOffset);
        if (this.relativeOffset < 0) {
            ins.code.hasBackwardBranches = true;
        }
        switch (this.opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 168: 
            case 198: 
            case 199: {
                ins.findBasicBlock(this.byteIndex + this.size());
            }
        }
    }

    public Object clone() {
        return new BT_JumpOffsetIns(this.opcode, -1, this.target);
    }

    public int size() {
        if (this.target != null) {
            int offset = this.target.byteIndex - this.byteIndex;
            boolean wide = (short)offset != offset;
            switch (this.opcode) {
                case 167: 
                case 200: {
                    this.opcode = wide ? 200 : 167;
                    break;
                }
                case 168: 
                case 201: {
                    this.opcode = wide ? 201 : 168;
                    break;
                }
                default: {
                    if (!wide) break;
                    return super.size() + 3;
                }
            }
        }
        return super.size();
    }
}

