/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_BasicBlockMarkerIns;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BT_JumpIns
extends BT_Ins {
    public BT_Ins target;

    BT_JumpIns(int opcode, int index) {
        super(opcode, index);
    }

    public void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
        if (this.target == oldIns) {
            this.target = newIns;
        }
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        int size = this.size();
        if (this.target.byteIndex == -1) {
            try {
                this.target.byteIndex = Integer.parseInt(((BT_BasicBlockMarkerIns)this.target).getLabel());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int offset = this.target.byteIndex - this.byteIndex;
        switch (this.opcode) {
            case 167: 
            case 168: {
                if (size != 3) {
                    throw new InternalError("unexpected instruction size of " + size + ". Expected=" + 5 + " for " + this);
                }
                dos.writeByte(this.opcode);
                dos.writeShort(offset);
                break;
            }
            case 200: 
            case 201: {
                if (size != 5) {
                    throw new InternalError("unexpected instruction size of " + size + ". Expected=" + 5 + " for " + this);
                }
                dos.writeByte(this.opcode);
                dos.writeInt(offset);
                break;
            }
            default: {
                boolean wide;
                boolean bl = wide = (short)offset != offset;
                if (wide) {
                    if (size != 6) {
                        throw new InternalError("unexpected instruction size of " + size + ". Expected=" + 5 + " for " + this);
                    }
                    dos.writeByte(196);
                    dos.writeByte(this.opcode);
                    dos.writeInt(offset);
                    break;
                }
                if (size != 3) {
                    throw new InternalError("unexpected instruction size of " + size + ". Expected=" + 5 + " for " + this);
                }
                dos.writeByte(this.opcode);
                dos.writeShort(offset);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " " + (this.target != null ? this.target.byteIndex : 0) + "[" + this.target + "]";
    }

    public String toAssemblerString() {
        return String.valueOf(BT_Misc.opcodeName[this.opcode]) + " " + this.target.getLabel();
    }
}

