/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_AttributeVector;
import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Opcodes;

public abstract class BT_Item
extends BT_Base
implements BT_Opcodes {
    public short flags;
    public BT_AttributeVector attributes = new BT_AttributeVector();
    String name;
    public static final short PUBLIC = 1;
    public static final short PRIVATE = 2;
    public static final short PROTECTED = 4;
    public static final short STATIC = 8;
    public static final short FINAL = 16;
    public static final short SYNCHRONIZED = 32;
    public static final short SUPER = 32;
    public static final short VOLATILE = 64;
    public static final short TRANSIENT = 128;
    public static final short NATIVE = 256;
    public static final short INTERFACE = 512;
    public static final short ABSTRACT = 1024;
    public static final short STRICT = 2048;
    protected int modelFlags = 1;
    private static final byte INPROJECT = 1;
    private static final int ISSTUB = 2;
    protected static final int THROWSVERIFYERROR = 4;

    protected BT_Item() {
    }

    public String getName() {
        return this.name;
    }

    public abstract void setName(String var1);

    public abstract void resetName(String var1);

    public abstract String fullName();

    public abstract String useName();

    public abstract String className();

    public void becomePublic() {
        this.flags = (short)(this.flags | 1);
        this.flags = (short)(this.flags & 0xFFFFFFFB);
        this.flags = (short)(this.flags & 0xFFFFFFFD);
    }

    public void becomeProtected() {
        this.flags = (short)(this.flags & 0xFFFFFFFE);
        this.flags = (short)(this.flags | 4);
        this.flags = (short)(this.flags & 0xFFFFFFFD);
    }

    public void becomePrivate() {
        this.flags = (short)(this.flags & 0xFFFFFFFE);
        this.flags = (short)(this.flags & 0xFFFFFFFB);
        this.flags = (short)(this.flags | 2);
    }

    public void becomeDefaultAccess() {
        this.flags = (short)(this.flags & 0xFFFFFFFE);
        this.flags = (short)(this.flags & 0xFFFFFFFB);
        this.flags = (short)(this.flags & 0xFFFFFFFD);
    }

    public void becomeStatic() {
        this.flags = (short)(this.flags | 8);
        this.flags = (short)(this.flags & 0xFFFFFFEF);
    }

    public void becomeAbstract() {
        this.flags = (short)(this.flags | 0x400);
        this.flags = (short)(this.flags & 0xFFFFFEFF);
        this.flags = (short)(this.flags & 0xFFFFF7FF);
        this.flags = (short)(this.flags & 0xFFFFFFDF);
    }

    public void becomeFinal() {
        this.flags = (short)(this.flags | 0x10);
    }

    public boolean isPublic() {
        return (this.flags & 1) != 0;
    }

    public boolean isDefaultAccess() {
        return (this.flags & 7) == 0;
    }

    public boolean isStatic() {
        return (this.flags & 8) != 0;
    }

    public boolean isFinal() {
        return (this.flags & 0x10) != 0;
    }

    public String accessString() {
        StringBuffer s = new StringBuffer();
        if ((this.flags & 1) != 0) {
            s.append("public ");
        }
        if ((this.flags & 2) != 0) {
            s.append("private ");
        }
        if ((this.flags & 4) != 0) {
            s.append("protected ");
        }
        if ((this.flags & 0x400) != 0) {
            s.append("abstract ");
        }
        if ((this.flags & 8) != 0) {
            s.append("static ");
        }
        if ((this.flags & 0x10) != 0) {
            s.append("final ");
        }
        if ((this.flags & 0x80) != 0) {
            s.append("transient ");
        }
        if ((this.flags & 0x40) != 0) {
            s.append("volatile ");
        }
        if ((this.flags & 0x20) != 0) {
            s.append("synchronized ");
        }
        if ((this.flags & 0x100) != 0) {
            s.append("native ");
        }
        return s.toString();
    }

    abstract BT_ConstantPool getPool();

    abstract void resolve();

    protected void replaceContents(BT_Item other) {
        this.flags = other.flags;
        this.attributes = other.attributes;
        this.name = other.name;
    }

    public boolean inProject() {
        return (this.modelFlags & 1) != 0;
    }

    public void setInProjectFalse() {
        this.modelFlags &= 0xFFFFFFFE;
    }

    protected final void setInProject(boolean inProject) {
        if (inProject) {
            this.modelFlags |= 1;
        } else {
            this.setInProjectFalse();
        }
    }

    public boolean isStub() {
        return (this.modelFlags & 2) != 0;
    }

    public void setStub(boolean isStub) {
        this.modelFlags = isStub ? (this.modelFlags |= 2) : (this.modelFlags &= 0xFFFFFFFD);
    }

    public boolean throwsVerifyError() {
        return (this.modelFlags & 4) != 0;
    }

    public void setThrowsVerifyErrorTrue() {
        this.modelFlags |= 4;
    }
}

