/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_ArrayEnumerator;
import com.ibm.jikesbt.BT_BasicBlockMarkerIns;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_LocalVector;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class BT_InsVector
implements Cloneable,
Serializable {
    protected int elementCount;
    protected BT_Ins[] elementData;
    protected int capacityIncrement;
    private static final BT_Ins[] emptyData = new BT_Ins[0];
    private static final int DEFAULT_SIZE = 0;
    public BT_CodeAttribute code;
    public BT_LocalVector locals;

    public BT_InsVector() {
        this(0, 0);
    }

    public BT_InsVector(int capacity) {
        this(capacity, 0);
    }

    public BT_InsVector(int capacity, int capacityIncrement) {
        this.elementCount = 0;
        this.elementData = capacity == 0 ? emptyData : new BT_Ins[capacity];
        this.capacityIncrement = capacityIncrement;
    }

    public void addElement(BT_Ins object) {
        this.insertElementAt(object, this.elementCount);
    }

    public int capacity() {
        return this.elementData.length;
    }

    public Object clone() {
        try {
            BT_InsVector vector = (BT_InsVector)super.clone();
            int length = this.elementData.length;
            vector.elementData = new BT_Ins[length];
            System.arraycopy(this.elementData, 0, vector.elementData, 0, length);
            return vector;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean contains(BT_Ins object) {
        return this.indexOf(object, 0) != -1;
    }

    public void copyInto(BT_Ins[] elements) {
        System.arraycopy(this.elementData, 0, elements, 0, this.elementCount);
    }

    public BT_Ins elementAt(int location) {
        return this.elementData[location];
    }

    public Enumeration elements() {
        return new BT_ArrayEnumerator(this.elementData, this.elementCount);
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.elementData.length < minimumCapacity) {
            this.grow(minimumCapacity);
        }
    }

    public BT_Ins firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    private void grow(int newCapacity) {
        BT_Ins[] newData = new BT_Ins[newCapacity];
        System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    public int indexOf(BT_Ins object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(BT_Ins object, int location) {
        int i = location;
        while (i < this.elementCount) {
            BT_Ins element = this.elementData[i];
            if (element == object) {
                return i;
            }
            if (element != null && element.equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insertElementAt(BT_Ins object, int location) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            if (this.elementCount == this.elementData.length) {
                int newCapacity = (this.capacityIncrement == 0 ? this.elementCount : this.capacityIncrement) + this.elementCount;
                if (newCapacity == 0) {
                    ++newCapacity;
                }
                this.grow(newCapacity);
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy(this.elementData, location, this.elementData, location + 1, count);
            }
            this.elementData[location] = object;
            ++this.elementCount;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public BT_Ins lastElement() {
        try {
            return this.elementData[this.elementCount - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public int lastIndexOf(BT_Ins object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public int lastIndexOf(BT_Ins object, int location) {
        if (location < this.elementCount) {
            int i = location;
            while (i >= 0) {
                BT_Ins element = this.elementData[i];
                if (element == object) {
                    return i;
                }
                if (element != null && element.equals(object)) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public boolean removeElement(BT_Ins object) {
        int index = this.indexOf(object, 0);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    public void removeElementAt(int location) {
        if (location < this.elementCount) {
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy(this.elementData, location + 1, this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void setElementAt(BT_Ins object, int location) {
        if (location < this.elementCount) {
            this.elementData[location] = object;
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void setSize(int length) {
        this.ensureCapacity(length);
        if (this.elementCount > length) {
            int i = length;
            while (i < this.elementCount) {
                this.elementData[i] = null;
                ++i;
            }
        }
        this.elementCount = length;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int length = this.elementCount - 1;
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        int i = 0;
        while (i < length) {
            buffer.append(this.elementData[i]);
            buffer.append(',');
            ++i;
        }
        buffer.append(this.elementData[length]);
        buffer.append(']');
        return buffer.toString();
    }

    public void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }

    public BT_Ins findBasicBlock(int index) {
        int n = this.elementCount - 1;
        while (n >= 0) {
            if (this.elementData[n].byteIndex == index) {
                if (!(this.elementData[n] instanceof BT_BasicBlockMarkerIns)) {
                    BT_BasicBlockMarkerIns bb = new BT_BasicBlockMarkerIns();
                    bb.byteIndex = index;
                    this.insertElementAt(bb, n);
                }
                return this.elementData[n];
            }
            --n;
        }
        if (this.elementCount == 0) {
            throw new NoSuchElementException("empty vector");
        }
        if (index < 0) {
            throw new InternalError("instruction reference out of range");
        }
        String reason = "invalid instruction reference";
        throw new InternalError(reason);
    }

    public BT_Ins findInstruction(int index) {
        int n = this.elementCount - 1;
        while (n >= 0) {
            if (this.elementData[n].byteIndex == index) {
                return this.elementData[n];
            }
            --n;
        }
        if (this.elementCount == 0) {
            throw new NoSuchElementException("empty vector");
        }
        if (index < 0) {
            throw new InternalError("instruction reference out of range");
        }
        String reason = "invalid instruction reference";
        throw new NoSuchElementException(reason);
    }

    public void setAllByteIndexes() {
        int k = 0;
        int offset = 0;
        while (k < this.size()) {
            BT_Ins instr = this.elementAt(k);
            instr.setByteIndex(offset);
            offset += instr.size();
            ++k;
        }
    }

    public BT_Ins[] toArray() {
        BT_Ins[] ins = new BT_Ins[this.size()];
        int i = 0;
        while (i < this.size()) {
            ins[i] = this.elementAt(i);
            ++i;
        }
        return ins;
    }

    public BT_InsVector(BT_CodeAttribute code) {
        this.elementData = new BT_Ins[1];
        this.capacityIncrement = 0;
        this.code = code;
    }
}

