/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Repository;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class BT_InnerClassesAttribute
extends BT_Attribute {
    public static final String ATTRIBUTE_NAME = "InnerClasses";
    public Description[] inners;

    public String getName() {
        return ATTRIBUTE_NAME;
    }

    BT_InnerClassesAttribute(byte[] data, BT_ConstantPool pool) throws BT_ClassFileException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        int nc = dis.readUnsignedShort();
        if (data.length != 2 + 8 * nc) {
            throw new BT_ClassFileException("InnerClasses attribute length");
        }
        this.inners = new Description[nc];
        int ic = 0;
        while (ic < nc) {
            this.inners[ic] = new Description();
            int iix = dis.readUnsignedShort();
            int oix = dis.readUnsignedShort();
            int nix = dis.readUnsignedShort();
            this.inners[ic].flags = dis.readShort();
            if (iix != 0) {
                this.inners[ic].innerClass = pool.getRepository().forName(pool.getClassNameAt(iix, 7));
            }
            if (oix != 0) {
                this.inners[ic].outerClass = pool.getRepository().forName(pool.getClassNameAt(oix, 7));
            }
            if (nix != 0) {
                this.inners[ic].shortName = pool.getUtf8At(nix);
            }
            ++ic;
        }
    }

    public void resolve(BT_ConstantPool pool) {
        super.resolve(pool);
        int ic = 0;
        while (ic < this.inners.length) {
            if (this.inners[ic].innerClass != null) {
                this.inners[ic].innerCPIx(pool);
            }
            if (this.inners[ic].outerClass != null) {
                this.inners[ic].outerCPIx(pool);
            }
            if (this.inners[ic].shortName != null) {
                this.inners[ic].nameCPIx(pool);
            }
            ++ic;
        }
    }

    void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        BT_Repository.debugRecentlyWrittenAttribute = this;
        dos.writeShort(pool.indexOfUtf8(ATTRIBUTE_NAME));
        dos.writeInt(2 + 8 * this.inners.length);
        dos.writeShort(this.inners.length);
        int ic = 0;
        while (ic < this.inners.length) {
            dos.writeShort(this.inners[ic].innerCPIx(pool));
            dos.writeShort(this.inners[ic].outerCPIx(pool));
            dos.writeShort(this.inners[ic].nameCPIx(pool));
            dos.writeShort(this.inners[ic].flags);
            ++ic;
        }
    }

    public String toString() {
        return "InnerClasses size=" + this.inners.length;
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(String.valueOf(prefix) + "InnerClasses:");
        int i = 0;
        while (i < this.inners.length) {
            ps.println(String.valueOf(prefix) + "  " + this.inners[i]);
            ++i;
        }
    }

    public static class Description {
        public BT_Class innerClass;
        public BT_Class outerClass;
        public String shortName;
        public short flags;

        private int innerCPIx(BT_ConstantPool pool) {
            return pool.indexOfClassRef(this.innerClass);
        }

        private int outerCPIx(BT_ConstantPool pool) {
            return pool.indexOfClassRef(this.outerClass);
        }

        private int nameCPIx(BT_ConstantPool pool) {
            return pool.indexOfUtf8(this.shortName);
        }

        public String toString() {
            return "inner: " + this.innerClass + "  outer: " + this.outerClass + "  short: " + this.shortName + "  flags: " + this.flags;
        }
    }
}

