/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_BasicBlockMarkerIns;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassVector;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ExceptionTableEntry;
import com.ibm.jikesbt.BT_Field;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_JumpIns;
import com.ibm.jikesbt.BT_JumpOffsetIns;
import com.ibm.jikesbt.BT_LineNumberAttribute;
import com.ibm.jikesbt.BT_LoadLocalIns;
import com.ibm.jikesbt.BT_LocalVariableAttribute;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_MethodCallSite;
import com.ibm.jikesbt.BT_MethodRefIns;
import com.ibm.jikesbt.BT_MethodSignature;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_Opcodes;

public final class BT_Inliner
extends BT_Base
implements BT_Opcodes {
    private static final boolean TRACE = false;

    public static boolean inline(BT_MethodCallSite cs) {
        return BT_Inliner.inline(cs, cs.instruction.target);
    }

    public static boolean inline(BT_MethodCallSite cs, BT_Method callee) {
        BT_Method caller = cs.from;
        if (caller.isStub() || callee.isStub()) {
            return false;
        }
        if (caller == callee) {
            return false;
        }
        boolean success = BT_Inliner.inline(callee.getCode(), caller, cs.instruction);
        if (success) {
            caller.removeCallSite(cs);
        }
        return success;
    }

    public static boolean inline(BT_CodeAttribute code, BT_Method caller, BT_Ins replacedInstr) {
        int localsInc;
        BT_Ins instr;
        if (code.method == caller) {
            return false;
        }
        BT_CodeAttribute callerCode = caller.getCode();
        BT_InsVector callerIns = callerCode.ins;
        BT_InsVector codeIns = code.ins;
        int callerStartIndex = callerIns.indexOf(replacedInstr);
        if (callerStartIndex == -1) {
            return false;
        }
        if (code.exceptions.size() != 0 && callerCode.computeStackDepth(callerStartIndex) + replacedInstr.getPoppedStackDiff() != 0) {
            return false;
        }
        if (replacedInstr.isInvokeIns()) {
            BT_MethodRefIns call = (BT_MethodRefIns)callerIns.elementAt(callerStartIndex);
            if (call.localsInUse == -1) {
                int localsInUse = callerIns.locals.size();
                int j = 0;
                while (j < callerIns.size()) {
                    instr = callerIns.elementAt(j);
                    if (instr.isInvokeIns()) {
                        ((BT_MethodRefIns)instr).localsInUse = localsInUse;
                    }
                    ++j;
                }
            }
            localsInc = call.localsInUse;
        } else {
            localsInc = replacedInstr.isReturnIns() ? 0 : callerIns.locals.size();
        }
        int callerEndIndex = BT_Inliner.inlineInstructionRange(codeIns, 0, codeIns.size(), callerIns, callerStartIndex, localsInc, false);
        BT_Inliner.inlineAttributes(code, 0, codeIns.size(), callerCode, callerStartIndex, callerEndIndex, localsInc);
        if (code.method.isStatic()) {
            if (BT_Inliner.requiresInitialization(code.method.cls) && !caller.cls.isDerivedFrom(code.method.cls)) {
                callerIns.insertElementAt(BT_Ins.make(87), callerStartIndex);
                BT_Ins ins = BT_Ins.make(178, BT_Inliner.findDummyStaticField(code.method.cls, caller.cls));
                callerIns.insertElementAt(ins, callerStartIndex);
                ins.dereference(callerIns);
            }
        } else if ((replacedInstr.isInvokeVirtualIns() || replacedInstr.isInvokeInterfaceIns() || replacedInstr.isInvokeSpecialIns()) && !BT_Inliner.hasThisReferences(code)) {
            instr = BT_Ins.make(0);
            callerIns.insertElementAt(instr, callerStartIndex);
            callerIns.insertElementAt(BT_Ins.make(191), callerStartIndex);
            callerIns.insertElementAt(BT_Ins.make(1), callerStartIndex);
            callerIns.insertElementAt(new BT_JumpOffsetIns(199, -1, instr), callerStartIndex);
            instr = BT_Ins.make(58, localsInc++);
            instr.dereference(callerIns);
            callerIns.insertElementAt(instr, callerStartIndex);
            callerIns.insertElementAt(BT_Ins.make(89), callerStartIndex);
            if (replacedInstr.isInvokeInterfaceIns()) {
                callerIns.insertElementAt(BT_Ins.make(192, code.method.cls), callerStartIndex);
            }
        } else {
            instr = BT_Ins.make(58, localsInc++);
            instr.dereference(callerIns);
            callerIns.insertElementAt(instr, callerStartIndex);
            if (replacedInstr.isInvokeInterfaceIns()) {
                callerIns.insertElementAt(BT_Ins.make(192, code.method.cls), callerStartIndex);
            }
        }
        BT_Method m = code.method;
        int k = 0;
        while (k < m.signature.types.size()) {
            int opcode = m.signature.types.elementAt(k).getOpcodeForStore();
            instr = BT_Ins.make(opcode, localsInc);
            instr.dereference(callerIns);
            callerIns.insertElementAt(instr, callerStartIndex);
            if (opcode == 55 || opcode == 57) {
                ++localsInc;
            }
            ++k;
            ++localsInc;
        }
        int codeLocalsInUse = codeIns.locals.size();
        int localsInUse = callerIns.locals.size();
        int j = callerStartIndex;
        while (j < callerEndIndex) {
            instr = callerIns.elementAt(j);
            if (instr.isInvokeIns()) {
                BT_MethodRefIns invokeInstr = (BT_MethodRefIns)instr;
                invokeInstr.localsInUse = localsInUse;
            }
            ++j;
        }
        callerCode.changeReferencesFromTo(replacedInstr, callerIns.elementAt(callerStartIndex));
        callerCode.computeInstructionSizes();
        return true;
    }

    public static boolean hasThisReferences(BT_CodeAttribute code) {
        BT_InsVector ins = code.ins;
        int i = 0;
        while (i < ins.size()) {
            BT_Ins instr = ins.elementAt(i);
            if (instr instanceof BT_BasicBlockMarkerIns) {
                return false;
            }
            if (instr instanceof BT_LoadLocalIns) {
                BT_LoadLocalIns loadIns = (BT_LoadLocalIns)instr;
                if (loadIns.localNr == 0) {
                    return true;
                }
            } else if (BT_Misc.opcodeRuntimeExceptions[instr.opcode] != 0) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static boolean inlineJsrs(BT_Method method) {
        BT_InsVector subs = new BT_InsVector();
        boolean anyInlined = false;
        BT_CodeAttribute code = method.getCode();
        if (code != null) {
            BT_InsVector methodIns = code.ins;
            int j = 0;
            while (j < methodIns.size()) {
                BT_Ins instr = methodIns.elementAt(j);
                if (instr.opcode == 168) {
                    BT_JumpIns jsrInstr = (BT_JumpIns)instr;
                    int jsrStartIndex = methodIns.indexOf(jsrInstr.target);
                    int jsrEndIndex = code.findJsrEnd(jsrStartIndex) + 1;
                    if (jsrEndIndex > 0) {
                        if (!subs.contains(jsrInstr.target)) {
                            subs.addElement(jsrInstr.target);
                        }
                        BT_Inliner.inlineJsr(code, j, jsrStartIndex + 2, jsrEndIndex);
                    } else {
                        methodIns.setElementAt(BT_Ins.make(167, methodIns.elementAt(jsrStartIndex + 2)), j);
                    }
                    anyInlined = true;
                    continue;
                }
                ++j;
            }
            if (anyInlined) {
                j = 0;
                while (j < subs.size()) {
                    int jsrStartIndex = methodIns.indexOf(subs.elementAt(j));
                    if (jsrStartIndex != -1) {
                        int jsrEndIndex = code.findJsrEnd(jsrStartIndex) + 1;
                        BT_Inliner.removeAttributes(code, jsrStartIndex, jsrEndIndex);
                        code.removeInstructionsAt(jsrEndIndex - jsrStartIndex, jsrStartIndex);
                    }
                    ++j;
                }
                code.computeInstructionSizes();
            }
        }
        return anyInlined;
    }

    private static void inlineJsr(BT_CodeAttribute code, int toStartIndex, int fromStartIndex, int fromEndIndex) {
        BT_InsVector codeIns = code.ins;
        BT_Ins replacedInstr = codeIns.elementAt(toStartIndex);
        BT_Ins fromStartInstr = codeIns.elementAt(fromStartIndex);
        int toEndIndex = BT_Inliner.inlineInstructionRange(codeIns, fromStartIndex, fromEndIndex, codeIns, toStartIndex, 0, true);
        int offset = codeIns.indexOf(fromStartInstr) - fromStartIndex;
        BT_Inliner.inlineAttributes(code, fromStartIndex + offset, fromEndIndex + offset, code, toStartIndex, toEndIndex, 0);
        code.changeReferencesFromTo(replacedInstr, codeIns.elementAt(toStartIndex));
    }

    public static int inlineInstructionRange(BT_InsVector codeIns, int codeStartIndex, int codeEndIndex, BT_InsVector callerIns, int callerIndex, int localsInc, boolean inlineJsr) {
        BT_Ins instr;
        int length = codeEndIndex - codeStartIndex;
        BT_Ins[] clonedIns = new BT_Ins[length + 1];
        BT_Ins jumpTarget = null;
        int k = 0;
        while (k < length) {
            BT_Ins newInstr;
            instr = codeIns.elementAt(codeStartIndex + k);
            if (inlineJsr ? instr.isRetIns() && instr.byteIndex == -1 : instr.isReturnIns()) {
                if (k == length - 1) {
                    newInstr = BT_Ins.make(0);
                } else {
                    if (jumpTarget == null && !((jumpTarget = callerIns.elementAt(callerIndex + 1)) instanceof BT_BasicBlockMarkerIns)) {
                        clonedIns[length] = jumpTarget = new BT_BasicBlockMarkerIns();
                    }
                    newInstr = BT_Ins.make(167, jumpTarget);
                }
            } else {
                newInstr = (BT_Ins)instr.clone();
                newInstr.incrementLocalsAccessWith(localsInc, 0, callerIns.locals);
                newInstr.dereference(callerIns);
                if (instr instanceof BT_MethodRefIns) {
                    BT_MethodRefIns refInstr = (BT_MethodRefIns)instr;
                    BT_MethodCallSite orgCallsite = refInstr.target.findCallSite(instr);
                    BT_MethodCallSite newCallsite = refInstr.target.findCallSite(newInstr);
                    newCallsite.clonedFrom(orgCallsite);
                }
            }
            clonedIns[k] = newInstr;
            ++k;
        }
        k = codeStartIndex;
        while (k < codeEndIndex) {
            BT_Ins from = codeIns.elementAt(k);
            BT_Ins to = clonedIns[k - codeStartIndex];
            int j = 0;
            while (j < length) {
                clonedIns[j].changeReferencesFromTo(from, to);
                ++j;
            }
            ++k;
        }
        instr = callerIns.elementAt(callerIndex);
        instr.remove();
        callerIns.removeElementAt(callerIndex);
        k = clonedIns[length] == null ? length - 1 : length;
        while (k >= 0) {
            callerIns.insertElementAt(clonedIns[k], callerIndex);
            --k;
        }
        int callerEndIndex = callerIndex + length;
        return callerEndIndex;
    }

    public static void inlineAttributes(BT_CodeAttribute code, int codeStartIndex, int codeEndIndex, BT_CodeAttribute callerCode, int callerStartIndex, int callerEndIndex, int localsInc) {
        BT_InsVector callerIns = callerCode.ins;
        BT_InsVector codeIns = code.ins;
        boolean inSameSourceFile = callerCode.method.cls.getSourceFile().length() != 0 && callerCode.method.cls.getSourceFile() == code.method.cls.getSourceFile();
        int i = 0;
        while (i < code.attributes.size()) {
            int k;
            int startIndex;
            int cloned;
            BT_Attribute calleeAttr;
            BT_Attribute attr = code.attributes.elementAt(i);
            if (attr instanceof BT_LocalVariableAttribute) {
                calleeAttr = (BT_LocalVariableAttribute)attr;
                BT_LocalVariableAttribute.LV[] localVariables = calleeAttr.localVariables;
                BT_LocalVariableAttribute.LV[] clonedVariables = new BT_LocalVariableAttribute.LV[localVariables.length];
                cloned = 0;
                int k2 = 0;
                while (k2 < localVariables.length) {
                    BT_LocalVariableAttribute.LV calleeLV = localVariables[k2];
                    startIndex = codeIns.indexOf(calleeLV.startIns);
                    if (startIndex >= codeStartIndex && startIndex < codeEndIndex) {
                        int localIndex;
                        int endIndex = codeIns.indexOf(calleeLV.beyondIns);
                        if (endIndex == -1 && codeIns.size() + callerStartIndex < callerIns.size()) {
                            endIndex = codeIns.size();
                        }
                        if ((localIndex = calleeLV.localIndex + localsInc) < callerIns.locals.size()) {
                            BT_LocalVariableAttribute.LV callerLV = new BT_LocalVariableAttribute.LV(callerIns.elementAt(startIndex - codeStartIndex + callerStartIndex), endIndex == -1 ? null : callerIns.elementAt(endIndex - codeStartIndex + callerStartIndex), calleeLV.nameS, calleeLV.descriptorC, localIndex);
                            clonedVariables[cloned++] = callerLV;
                        }
                    }
                    ++k2;
                }
                if (cloned > 0) {
                    BT_LocalVariableAttribute callerAttr = null;
                    int k3 = 0;
                    while (k3 < callerCode.attributes.size()) {
                        BT_Attribute a = callerCode.attributes.elementAt(k3);
                        if (a instanceof BT_LocalVariableAttribute) {
                            callerAttr = (BT_LocalVariableAttribute)a;
                            break;
                        }
                        ++k3;
                    }
                    if (callerAttr == null) {
                        callerAttr = new BT_LocalVariableAttribute(0, callerCode);
                        callerCode.attributes.addElement(callerAttr);
                    }
                    int callerLen = callerAttr.localVariables.length;
                    localVariables = new BT_LocalVariableAttribute.LV[callerLen + cloned];
                    k = 0;
                    while (k < callerLen) {
                        localVariables[k] = callerAttr.localVariables[k];
                        ++k;
                    }
                    k = 0;
                    while (k < cloned) {
                        localVariables[callerLen + k] = clonedVariables[k];
                        ++k;
                    }
                    callerAttr.localVariables = localVariables;
                }
            } else if (inSameSourceFile && attr instanceof BT_LineNumberAttribute) {
                calleeAttr = (BT_LineNumberAttribute)attr;
                BT_LineNumberAttribute.PcRange[] pcRanges = ((BT_LineNumberAttribute)calleeAttr).pcRanges;
                BT_LineNumberAttribute.PcRange[] clonedRanges = new BT_LineNumberAttribute.PcRange[pcRanges.length];
                cloned = 0;
                int k4 = 0;
                while (k4 < pcRanges.length) {
                    BT_LineNumberAttribute.PcRange calleePcRange = pcRanges[k4];
                    startIndex = codeIns.indexOf(calleePcRange.startIns);
                    if (startIndex >= codeStartIndex && startIndex < codeEndIndex) {
                        BT_LineNumberAttribute.PcRange callerPcRange = new BT_LineNumberAttribute.PcRange(callerIns.elementAt(startIndex - codeStartIndex + callerStartIndex), calleePcRange.lineNumber);
                        clonedRanges[cloned++] = callerPcRange;
                    }
                    ++k4;
                }
                if (cloned > 0) {
                    BT_LineNumberAttribute callerAttr = null;
                    int k5 = 0;
                    while (k5 < callerCode.attributes.size()) {
                        BT_Attribute a = callerCode.attributes.elementAt(k5);
                        if (a instanceof BT_LineNumberAttribute) {
                            callerAttr = (BT_LineNumberAttribute)a;
                            break;
                        }
                        ++k5;
                    }
                    if (callerAttr == null) {
                        callerAttr = new BT_LineNumberAttribute(0, callerCode);
                        callerCode.attributes.addElement(callerAttr);
                    }
                    int callerLen = callerAttr.pcRanges.length;
                    pcRanges = new BT_LineNumberAttribute.PcRange[callerLen + cloned];
                    k = 0;
                    while (k < callerLen) {
                        pcRanges[k] = callerAttr.pcRanges[k];
                        ++k;
                    }
                    k = 0;
                    while (k < cloned) {
                        pcRanges[callerLen + k] = clonedRanges[k];
                        ++k;
                    }
                    callerAttr.pcRanges = pcRanges;
                }
            }
            ++i;
        }
        int last = 0;
        int k = code.exceptions.size() - 1;
        while (k >= last) {
            BT_ExceptionTableEntry codeEntry = code.exceptions.elementAt(k);
            int startIndex = codeIns.indexOf(codeEntry.startPCTarget);
            if (startIndex >= codeStartIndex && startIndex < codeEndIndex) {
                int endIndex = codeIns.indexOf(codeEntry.endPCTarget);
                int handlerIndex = codeIns.indexOf(codeEntry.handlerTarget);
                if (handlerIndex >= codeStartIndex && handlerIndex < codeEndIndex) {
                    handlerIndex = handlerIndex - codeStartIndex + callerStartIndex;
                }
                BT_ExceptionTableEntry callerEntry = new BT_ExceptionTableEntry(callerIns.elementAt(startIndex - codeStartIndex + callerStartIndex), callerIns.elementAt(endIndex - codeStartIndex + callerStartIndex), callerIns.elementAt(handlerIndex), codeEntry.catchType);
                callerCode.exceptions.insertElementAt(callerEntry, 0);
                if (callerCode == code) {
                    ++last;
                    ++k;
                }
            }
            --k;
        }
    }

    private static void removeAttributes(BT_CodeAttribute code, int codeStartIndex, int codeEndIndex) {
        BT_InsVector codeIns = code.ins;
        int i = code.attributes.size() - 1;
        while (i >= 0) {
            int startIndex;
            int k;
            int length;
            BT_Attribute codeAttr;
            BT_Attribute attr = code.attributes.elementAt(i);
            if (attr instanceof BT_LocalVariableAttribute) {
                codeAttr = (BT_LocalVariableAttribute)attr;
                BT_LocalVariableAttribute.LV[] localVariables = codeAttr.localVariables;
                length = 0;
                k = localVariables.length - 1;
                while (k >= 0) {
                    BT_LocalVariableAttribute.LV calleeLV = localVariables[k];
                    startIndex = codeIns.indexOf(calleeLV.startIns);
                    if (startIndex >= codeStartIndex && startIndex < codeEndIndex) {
                        localVariables[k] = null;
                    } else {
                        ++length;
                    }
                    --k;
                }
                if (length < localVariables.length) {
                    if (length == 0) {
                        code.attributes.removeElementAt(i);
                    } else {
                        codeAttr.localVariables = new BT_LocalVariableAttribute.LV[length];
                        k = localVariables.length - 1;
                        while (k >= 0) {
                            if (localVariables[k] != null) {
                                codeAttr.localVariables[--length] = localVariables[k];
                            }
                            --k;
                        }
                    }
                }
            } else if (attr instanceof BT_LineNumberAttribute) {
                codeAttr = (BT_LineNumberAttribute)attr;
                BT_LineNumberAttribute.PcRange[] pcRanges = ((BT_LineNumberAttribute)codeAttr).pcRanges;
                length = 0;
                k = pcRanges.length - 1;
                while (k >= 0) {
                    BT_LineNumberAttribute.PcRange calleePcRange = pcRanges[k];
                    startIndex = codeIns.indexOf(calleePcRange.startIns);
                    if (startIndex >= codeStartIndex && startIndex < codeEndIndex) {
                        pcRanges[k] = null;
                    } else {
                        ++length;
                    }
                    --k;
                }
                if (length < pcRanges.length) {
                    if (length == 0) {
                        code.attributes.removeElementAt(i);
                    } else {
                        ((BT_LineNumberAttribute)codeAttr).pcRanges = new BT_LineNumberAttribute.PcRange[length];
                        k = pcRanges.length - 1;
                        while (k >= 0) {
                            if (pcRanges[k] != null) {
                                ((BT_LineNumberAttribute)codeAttr).pcRanges[--length] = pcRanges[k];
                            }
                            --k;
                        }
                    }
                }
            }
            --i;
        }
        int k = code.exceptions.size() - 1;
        while (k >= 0) {
            BT_ExceptionTableEntry codeEntry = code.exceptions.elementAt(k);
            int startIndex = codeIns.indexOf(codeEntry.startPCTarget);
            if (startIndex >= codeStartIndex && startIndex < codeEndIndex) {
                code.exceptions.removeElementAt(k);
            }
            --k;
        }
    }

    private static BT_Field findDummyStaticField(BT_Class cls, BT_Class referent) {
        BT_Field f = BT_Inliner.findInheritedStaticField(cls, referent);
        if (f == null) {
            String dummyName = "_";
            while (!((f = cls.findInheritedField(dummyName, cls.getRepository().getInt(), cls)) == null || f.isStatic() && f.cls != cls)) {
                dummyName = String.valueOf(dummyName) + "_";
            }
            f = BT_Field.createField(cls, (short)9, cls.getRepository().getInt(), dummyName);
        }
        if (f.cls != cls) {
            f = cls.addStubField(f.getName(), f.type);
        }
        return f;
    }

    private static BT_Field findInheritedStaticField(BT_Class cls, BT_Class referent) {
        BT_Field f;
        int i = 0;
        while (i < cls.fields.size()) {
            f = cls.fields.elementAt(i);
            if (f.isStatic() && f.isVisibleFrom(referent) && f.getOpcodeForPop() == 87 && !f.isStub() && !f.isFinal()) {
                return f;
            }
            ++i;
        }
        i = 0;
        while (i < cls.parents_.size()) {
            f = BT_Inliner.findInheritedStaticField(cls.parents_.elementAt(i), referent);
            if (f != null && f.isVisibleFrom(referent)) {
                return f;
            }
            ++i;
        }
        return null;
    }

    private static boolean requiresInitialization(BT_Class cls) {
        BT_Method m = cls.findInheritedMethod("<clinit>", BT_MethodSignature.create(cls.getRepository().getVoid(), new BT_ClassVector(), cls.getRepository()), cls);
        return m != null && m.cls != cls.getRepository().findJavaLangObject();
    }
}

