/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Local;
import com.ibm.jikesbt.BT_LocalVector;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_IIncIns
extends BT_Ins {
    public BT_Local target;
    public short constant;
    public boolean wide;
    public int localNr;

    BT_IIncIns(int opcode, int index, int localNr, short constant, BT_InsVector ins) {
        this(opcode, index, localNr, constant, ins, false);
    }

    BT_IIncIns(int opcode, int index, int localNr, short constant, BT_InsVector ins, boolean wide) {
        super(opcode, index);
        this.target = ins.locals.elementAt(localNr);
        this.constant = constant;
        this.localNr = localNr;
        this.wide = wide;
    }

    public BT_IIncIns(int opcode, BT_Local target, short constant) {
        super(opcode, -1);
        this.target = target;
        this.localNr = target.localNr;
        this.constant = constant;
        this.setWide();
    }

    public Object clone() {
        BT_IIncIns i = new BT_IIncIns(this.opcode, this.target, this.constant);
        i.localNr = this.localNr;
        return i;
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.setWide();
    }

    private void setWide() {
        this.wide = this.localNr > 255 || this.constant > 127 || this.constant < -128;
    }

    public int size() {
        return this.wide ? 6 : 3;
    }

    public void incrementLocalsAccessWith(int inc, int start, BT_LocalVector locals) {
        if (this.localNr < start) {
            return;
        }
        this.localNr += inc;
        this.target = locals.elementAt(this.localNr);
        this.setWide();
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.wide) {
            dos.writeByte(196);
            dos.writeByte(this.opcode);
            dos.writeShort(this.localNr);
            dos.writeShort(this.constant);
        } else {
            dos.writeByte(this.opcode);
            dos.writeByte(this.localNr);
            dos.writeByte(this.constant);
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " " + this.localNr + " (" + this.target.localNr + ") " + this.constant;
    }

    public String toAssemblerString() {
        String s = String.valueOf(BT_Misc.opcodeName[this.opcode]) + " " + this.target.localNr + " " + this.constant;
        s = this.constant < 0 ? String.valueOf(s) + " // subtract " + -this.constant + " from " + BT_CodeAttribute.getLocalName(this.target.localNr) : String.valueOf(s) + " // add " + this.constant + " to " + BT_CodeAttribute.getLocalName(this.target.localNr);
        return s;
    }
}

