/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_BasicBlockMarkerIns;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Field;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_JumpOffsetIns;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public class BT_FieldRefIns
extends BT_Ins {
    public BT_Field target;
    public int cpIx;

    public BT_FieldRefIns(int opcode, BT_Field target) {
        super(opcode, -1);
        this.target = target;
    }

    protected BT_FieldRefIns(int opcode, int index, int poolIndex, BT_Method inM) throws BT_ClassFileException {
        super(opcode, index);
        BT_ConstantPool pool = inM.cls.pool;
        BT_Class targC = pool.getRepository().forName(pool.getClassNameAt(poolIndex, 9));
        BT_Class targType = pool.getRepository().forName(pool.getFieldTypeAt(poolIndex));
        String fieldName = pool.getFieldNameAt(poolIndex);
        this.target = BT_FieldRefIns.findTarget(opcode, targC, fieldName, targType, inM);
        if (this.target == null) {
            this.target = targC.addStubField(fieldName, targType);
            pool.getRepository().factory.noteUndeclaredField(this.target, "Instruction " + this + BT_Base.endl() + " -- in method " + inM);
        }
    }

    private static BT_Field findTarget(int opcode, BT_Class targetClass, String fieldName, BT_Class targType, BT_Method referent) {
        if (opcode == 178 || opcode == 179) {
            return targetClass.findFieldOrNull(fieldName, targType);
        }
        BT_Field result = targetClass.findInheritedField(fieldName, targType, referent.cls, true);
        return result;
    }

    public void dereference(BT_InsVector ins) {
        this.target.addAccessor(this, ins.code.method);
    }

    public void remove() {
        this.target.removeAccessor(this);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.cpIx = pool.indexOfFieldRef(this.target);
    }

    public BT_Field getFieldTarget() {
        return this.target;
    }

    public BT_Class getClassTarget() {
        return this.target.cls;
    }

    public BT_Field getTarget() {
        return this.target;
    }

    public void setTarget(BT_Field m) {
        this.target = m;
    }

    public void resetTarget(BT_Field m, BT_InsVector ins) {
        if (m != this.target) {
            this.remove();
            this.target = m;
            this.dereference(ins);
        }
    }

    public boolean isPushConstantIns() {
        return false;
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeByte(this.opcode);
        dos.writeShort(this.cpIx);
        if (this.size() != 3) {
            throw new InternalError("Write/size error " + this);
        }
    }

    public boolean optimize(BT_CodeAttribute code, int n, boolean strict) {
        BT_InsVector ins = code.ins;
        BT_Ins next = ins.size() > n + 1 ? ins.elementAt(n + 1) : null;
        int popOpcode = this.target.getOpcodeForPop();
        if (next != null && this.opcode == 180 && next.opcode == popOpcode && this.hasEquivalentClassReferences(code, n)) {
            next = ins.elementAt(n + 2);
            code.insertInstructionAt(BT_Ins.make(191), n + 2);
            code.insertInstructionAt(BT_Ins.make(1), n + 2);
            return code.replaceInstructionsAtWith(2, n, new BT_JumpOffsetIns(199, -1, next));
        }
        if (next != null && this.opcode == 178 && next.opcode == popOpcode && this.hasEquivalentClassReferences(code, n)) {
            return code.removeInstructionsAt(2, n);
        }
        if (next != null && this.opcode == 178 && next.opcode == 178 && this.target == ((BT_FieldRefIns)next).target) {
            return code.replaceInstructionsAtWith(1, n + 1, BT_Ins.make(this.target.getOpcodeForDup()));
        }
        if (n > 0 && ins.size() > n + 2 && this.opcode == 180 && ins.elementAt((int)(n - 1)).opcode == 42 && ins.elementAt((int)(n + 1)).opcode == 42 && ins.elementAt((int)(n + 2)).opcode == 180) {
            BT_FieldRefIns fri = (BT_FieldRefIns)ins.elementAt(n + 2);
            if (this.target == fri.target) {
                return code.replaceInstructionsAtWith(2, n + 1, BT_Ins.make(this.target.getOpcodeForDup()));
            }
        }
        return false;
    }

    private boolean hasEarlierInitializations(BT_CodeAttribute code, int n) {
        BT_InsVector ins = code.ins;
        int i = n - 1;
        while (i >= 0) {
            BT_Ins instr = ins.elementAt(i);
            if (instr.opcode == this.opcode && ((BT_FieldRefIns)instr).target == this.target) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean hasEquivalentClassReferences(BT_CodeAttribute code, int n) {
        BT_Ins instr;
        BT_InsVector ins = code.ins;
        BT_Class cls = this.target.cls;
        int i = n - 1;
        while (i >= 0) {
            instr = ins.elementAt(i);
            if (instr instanceof BT_BasicBlockMarkerIns) break;
            if (instr.getClassTarget() == cls) {
                return true;
            }
            --i;
        }
        i = n + 1;
        while (i < ins.size()) {
            instr = ins.elementAt(i);
            if (instr instanceof BT_BasicBlockMarkerIns) {
                return false;
            }
            BT_Class target = instr.getClassTarget();
            if (target != null) {
                return target == cls;
            }
            if (BT_Misc.opcodeRuntimeExceptions[instr.opcode] != 0) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public int getStackDiff() {
        String fieldType = this.target.getType();
        boolean wide = fieldType.equals("long") || fieldType.equals("double");
        switch (this.opcode) {
            case 180: {
                return wide ? 1 : 0;
            }
            case 178: {
                return wide ? 2 : 1;
            }
            case 181: {
                return wide ? -3 : -2;
            }
            case 179: {
                return wide ? -2 : -1;
            }
        }
        throw new InternalError("Unsupported opcode " + this.opcode);
    }

    public Object clone() {
        return new BT_FieldRefIns(this.opcode, this.target);
    }

    public String toString() {
        String suf = "  type=" + this.target.type;
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " " + this.target.useName() + suf;
    }

    public String toAssemblerString() {
        String fieldName = this.target.useName();
        return String.valueOf(BT_Misc.opcodeName[this.opcode]) + " " + fieldName + " " + this.target.type;
    }
}

