/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_AccessorVector;
import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_AttributeVector;
import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_ConstantValueAttribute;
import com.ibm.jikesbt.BT_Factory;
import com.ibm.jikesbt.BT_FieldRefIns;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_Member;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;

public class BT_Field
extends BT_Member {
    public BT_Class type;
    public BT_AccessorVector accessors = new BT_AccessorVector();

    private final void initialize(short flags, BT_Class type, String simpleName) {
        this.flags = flags;
        this.type = type;
        this.name = simpleName;
        this.cls.fields.addElement(this);
    }

    public void initializeFrom(Field f) {
        this.name = f.getName();
        this.flags = (short)f.getModifiers();
        this.type = this.cls.getRepository().findClass(BT_ConstantPool.toJavaName(f.getType().getName()));
        if (this.type == null) {
            this.type = new BT_Class(BT_ConstantPool.toJavaName(f.getType().getName()), this.cls.getRepository());
        }
    }

    public BT_Field(BT_Class cls) {
        super(cls);
    }

    public BT_Field(BT_Class cls, short flags, BT_Class type, String simpleName) {
        super(cls);
        this.initialize(flags, type, simpleName);
    }

    public BT_Field(BT_Class cls, short flags, String typeName, String simpleName) {
        this(cls, flags, cls.getRepository().forName(typeName), simpleName);
    }

    public BT_Field(BT_Class cls, String typeName, String simpleName) {
        this(cls, 1, typeName, simpleName);
    }

    public static BT_Field createField(BT_Class inClass, short flags, BT_Class ftype, String simpleName) {
        BT_Field f = inClass.repository.createField(inClass);
        f.initialize(flags, ftype, simpleName);
        return f;
    }

    public void resetDeclaringClassAndName(BT_Class c, String nm) {
        this.name = nm;
        this.cls = c;
    }

    public void resetName(String newName) {
        this.setName(newName);
    }

    public void resetDeclaringClass(BT_Class cls) {
        this.cls = cls;
    }

    public boolean isVolatile() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.flags & 0x80) != 0;
    }

    void read(DataInputStream dis, BT_ConstantPool pool) throws BT_ClassFileException, IOException {
        this.flags = dis.readShort();
        BT_Repository.debugRecentlyReadFieldName = this.name = pool.getSimpleNameAt(dis.readUnsignedShort());
        int allFlags = this.flags & 0xDF;
        int accessFlags = allFlags & 7;
        int otherFlags = allFlags & 0x50;
        if ((this.cls.isInterface() && allFlags != 25 || this.cls.isClass() && (accessFlags != 0 && accessFlags != 1 && accessFlags != 2 && accessFlags != 4 || otherFlags == 80)) && BT_Factory.strictVerification) {
            throw new BT_ClassFileException("invalid access flags for field " + this.name);
        }
        String typeName = pool.getFieldDescriptorAt(dis.readUnsignedShort());
        this.type = pool.getRepository().forName(typeName);
        this.attributes = BT_AttributeVector.read(dis, pool, this);
    }

    final void resolve() {
        this.cls.pool.indexOfUtf8(this.name);
        this.cls.pool.indexOfUtf8(BT_ConstantPool.toInternalName(this.type.name));
        this.attributes.resolve(this.cls.pool);
    }

    public int getOpcodeForPop() {
        if (this.type != null) {
            return this.type.getOpcodeForPop();
        }
        if (this.type.name.equals("long") || this.type.name.equals("double")) {
            return 88;
        }
        return 87;
    }

    public int getOpcodeForDup() {
        if (this.type != null) {
            return this.type.getOpcodeForDup();
        }
        if (this.type.name.equals("long") || this.type.name.equals("double")) {
            return 92;
        }
        return 89;
    }

    public int getOpcodeForDefaultValue() {
        if (this.type.isArray() || !this.type.isBasicTypeClass) {
            return 1;
        }
        if (this.type.name.equals("byte")) {
            return 3;
        }
        if (this.type.name.equals("char")) {
            return 3;
        }
        if (this.type.name.equals("double")) {
            return 14;
        }
        if (this.type.name.equals("float")) {
            return 11;
        }
        if (this.type.name.equals("int")) {
            return 3;
        }
        if (this.type.name.equals("long")) {
            return 9;
        }
        if (this.type.name.equals("boolean")) {
            return 3;
        }
        if (this.type.name.equals("short")) {
            return 3;
        }
        throw new InternalError("Unexpected field type " + this.type.name);
    }

    public void addAccessor(BT_FieldRefIns ins, BT_Method caller) {
        int n = this.accessors.size() - 1;
        while (n >= 0) {
            if (this.accessors.elementAt((int)n).instruction == ins) {
                return;
            }
            --n;
        }
        this.accessors.addElement(this.cls.repository.createAccessor(caller, ins, this));
    }

    public void removeAccessor(BT_Ins ins) {
        int n = this.accessors.size() - 1;
        while (n >= 0) {
            if (this.accessors.elementAt((int)n).instruction == ins) {
                this.accessors.removeElementAt(n);
            }
            --n;
        }
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.isStub()) {
            return;
        }
        BT_Repository.debugRecentlyWrittenField = this;
        dos.writeShort(this.flags);
        dos.writeShort(pool.indexOfUtf8(this.name));
        dos.writeShort(pool.indexOfUtf8(BT_ConstantPool.toInternalName(this.type.name)));
        this.attributes.write(dos, pool);
    }

    public String getType() {
        return this.type.name;
    }

    public String fullName() {
        return String.valueOf(this.cls.name) + "." + this.name;
    }

    public String useName() {
        return this.fullName();
    }

    public String toString() {
        return this.fullName();
    }

    public String longInfo() {
        String s = "Field " + this.accessString() + this.type + " " + this.name;
        BT_Attribute cva = this.attributes.getAttribute("ConstantValue");
        if (cva != null) {
            s = String.valueOf(s) + " = " + (BT_ConstantValueAttribute)cva;
        }
        int n = 0;
        while (n < this.accessors.size()) {
            s = String.valueOf(s) + BT_Base.endl() + "\taccessed from " + this.accessors.elementAt((int)n).from.fullName() + " using a " + BT_Misc.opcodeName[this.accessors.elementAt((int)n).instruction.opcode];
            ++n;
        }
        return s;
    }

    public boolean sigEquals(BT_Field other) {
        return this.name.equals(other.name) && this.type == other.type;
    }

    protected void replaceContents(BT_Field other) {
        super.replaceContents(other);
        this.type = other.type;
    }
}

