/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_FatalRuntimeException;
import com.ibm.jikesbt.BT_Field;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Item;
import com.ibm.jikesbt.BT_JarResource;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;

public class BT_Factory {
    static final char ZIPFILE_SEPARATOR_SLASH = '/';
    static final char UNIX_SEPARATOR_SLASH = '/';
    static final char DOSFILE_SEPARATOR_BACKSLASH = '\\';
    static final boolean CHECK = true;
    public boolean buildMethodRelationships;
    public boolean keepConstantPool;
    public boolean loadMethods;
    public boolean keepBytecodes;
    public boolean readDebugInfo;
    public static boolean fatalIfProjectProblems = true;
    public static boolean exitViaThrowIfFatalError = true;
    public static boolean wantDetailForJbtUser = true;
    public static boolean strictVerification = true;
    private static final String endl_ = System.getProperties().getProperty("line.separator");

    private static final String endl() {
        return endl_;
    }

    public BT_Factory(boolean buildMethodRelationships, boolean loadMethods, boolean keepConstantPool, boolean readDebugInfo, boolean keepBytecodes) {
        this.buildMethodRelationships = buildMethodRelationships;
        this.keepConstantPool = keepConstantPool;
        this.readDebugInfo = readDebugInfo;
        this.loadMethods = loadMethods;
        this.keepBytecodes = keepBytecodes;
    }

    public BT_Factory() {
        this(true, true, false, true, false);
    }

    public boolean isProjectClass(String className, Object file) {
        return !className.startsWith("java.") && !className.startsWith("sunw.") && !className.startsWith("sun.") && !className.startsWith("com.ibm.jikesbt.") && !className.startsWith("com.ibm.javaSpy.") && !className.startsWith("com.ms.");
    }

    public void fatal(String message, Throwable ex) {
        this.printAndLog("");
        this.printAndLog("***** Fatal error: " + message);
        new Throwable().printStackTrace(System.err);
        if (wantDetailForJbtUser) {
            if (ex != null) {
                this.logStream().print(" -- The exception: ");
                ex.printStackTrace(this.logStream());
                this.log("");
            } else if (!exitViaThrowIfFatalError) {
                this.logStream().print(" -- The stack now: ");
                new Throwable("").printStackTrace(this.logStream());
                this.log("");
            }
            BT_Repository.printDebugRecentFields(this.logStream());
        }
        if (exitViaThrowIfFatalError) {
            throw new BT_FatalRuntimeException("Fatal error: " + message);
        }
        System.exit(1099);
    }

    public void fatal(String message) {
        this.fatal(message, null);
    }

    public void noteAnomalyInClass(String msg) {
        this.warning(msg);
    }

    public void noteClassLoaded(BT_Class c, String fromFileName, DataInputStream stream) {
        if (c.inProject()) {
            this.log("  * Loaded " + c.fullKindName() + " " + c + " from " + fromFileName);
        }
    }

    public BT_Class noteClassNotFound(String className, BT_Repository repo) {
        if (fatalIfProjectProblems && this.isProjectClass(className, null)) {
            this.fatal("Could not find class " + className);
        }
        this.warning("Could not find class " + className + " -- will create a stub");
        return repo.createStub(className);
    }

    public void noteClassPathProblem(String entry, String message) {
        this.warning(message);
    }

    public void noteClassReadIOException(String className, String fileName, IOException ex) {
        boolean pc = this.isProjectClass(className, null);
        String m = "I/O error while reading " + (pc ? "project" : "external") + " class " + className + BT_Factory.endl() + " -- From file " + fileName;
        if (fatalIfProjectProblems && pc) {
            this.fatal(m, ex);
        } else {
            this.warning(String.valueOf(m) + BT_Factory.endl() + " -- Will create a stub class and continue");
            if (wantDetailForJbtUser) {
                this.logStream().print(" -- The exception: ");
                ex.printStackTrace(this.logStream());
                BT_Repository.printDebugRecentFields(this.logStream());
            }
        }
    }

    public void noteClassSaved(BT_Class c) {
    }

    public void noteResourceSaved(BT_JarResource resource) {
    }

    public void noteClassVerifyFailure(String className, String fileName, String hint, Throwable ex) {
        if (ex instanceof BT_FatalRuntimeException) {
            throw (BT_FatalRuntimeException)ex;
        }
        boolean pc = this.isProjectClass(className, null);
        String text = "Error verifying " + (pc ? "project" : "external") + " class " + className;
        if (fileName != null) {
            text = String.valueOf(text) + BT_Factory.endl() + " -- From file " + fileName;
        }
        text = String.valueOf(text) + BT_Factory.endl() + " -- " + hint;
        if (fatalIfProjectProblems && pc) {
            this.fatal(text, ex);
        } else {
            this.warning(String.valueOf(text) + BT_Factory.endl() + " -- Will create a stub class and continue");
            if (wantDetailForJbtUser) {
                if (ex != null) {
                    this.logStream().print(" -- The exception: ");
                    ex.printStackTrace(this.logStream());
                } else {
                    new Throwable("The stack:").printStackTrace(this.logStream());
                }
                BT_Repository.printDebugRecentFields(this.logStream());
            }
        }
    }

    public void noteClassWriteIOException(String className, String fileName, IOException ex) {
        String m = "I/O error while writing class " + className + BT_Factory.endl() + " -- to file " + fileName;
        this.fatal(m, ex);
    }

    public void noteIncompatibleClassChangeError(BT_Item user, BT_Item used, String message) {
        this.warning("Incompatible class change between: " + user + " and " + used + BT_Factory.endl() + " -- " + message);
    }

    public void noteExecutionFallsOffEndOfMethod(int depth, BT_CodeAttribute code) {
        String msg = "Execution can flow past the end of " + code.method;
        if (depth != -1) {
            msg = String.valueOf(msg) + " (with stack depth of " + depth + ")";
        }
        this.warning(msg);
    }

    public void noteJumpOutsideMethod(BT_CodeAttribute code, BT_Ins jumpIns) {
        this.fatal("Illegal jump in " + code.method + " at instruction '" + jumpIns + "'");
    }

    public void noteStackNotEmptyAtReturn(int depth, int n, BT_CodeAttribute code) {
        BT_InsVector ins = code.ins;
        BT_Ins in1 = ins.elementAt(n);
        String msg = "Invalid stack depth of " + depth + " at instruction " + in1.byteIndex + " " + in1 + " of " + code.method;
        this.warning(msg);
    }

    public void noteStackUnderflow(int depth, int ix, BT_CodeAttribute code) {
        BT_InsVector ins = code.ins;
        BT_Ins i = ins.elementAt(ix);
        String msg = "Stack underflow of " + depth + " in " + code.method + " at instruction #" + ix + " " + i.byteIndex + " " + i;
        this.warning(msg);
    }

    public void noteStackDepthInconsistent(int ix, BT_CodeAttribute code) {
        BT_InsVector ins = code.ins;
        BT_Ins i = ins.elementAt(ix);
        String msg = "Inconsistent stack depth in " + code.method + " at instruction #" + ix + " " + i;
        this.warning(msg);
    }

    public void noteToJbtUser(String msg, Exception ex) {
        if (wantDetailForJbtUser) {
            this.warning("JikesBT-user: " + msg);
            if (ex == null) {
                ex = new Exception("JikesBT-user stack trace");
            }
            ex.printStackTrace(this.logStream());
            BT_Repository.printDebugRecentFields(this.logStream());
        }
    }

    public void noteUndeclaredField(BT_Field f, String referrer) {
        String msg = String.valueOf(referrer) + BT_Factory.endl() + " -- refers to an undeclared field in a project class";
        if (fatalIfProjectProblems && f.cls.inProject()) {
            this.fatal(msg);
        } else {
            this.warning(String.valueOf(msg) + BT_Factory.endl() + " -- a \"public\" field will be added");
        }
    }

    public void noteUndeclaredMethod(BT_Method m, String referrer) {
        String msg = String.valueOf(referrer) + BT_Factory.endl() + " -- refers to an undeclared method in a " + (m.cls.inProject() ? "project" : "system") + " class";
        if (fatalIfProjectProblems && m.cls.inProject()) {
            this.fatal(msg);
        } else {
            this.warning(String.valueOf(msg) + BT_Factory.endl() + " -- a \"public native\" method will be added");
        }
    }

    public PrintStream logStream() {
        return this.printStream();
    }

    public PrintStream printStream() {
        return System.out;
    }

    public void log(String s) {
        this.logStream().println(s);
    }

    public void print(String s) {
        this.printStream().println(s);
    }

    public void printAndLog(String s) {
        this.print(s);
        if (this.logStream() != this.printStream()) {
            this.log(s);
        }
    }

    public void warning(String s) {
        this.printAndLog("Warning: " + s);
    }

    public void error(String s) {
        this.printAndLog("Error: " + s);
    }
}

