/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ClassVector;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;

public final class BT_ExceptionsAttribute
extends BT_Attribute {
    public static final String ATTRIBUTE_NAME = "Exceptions";
    public BT_ClassVector declaredExceptions;

    public String getName() {
        return ATTRIBUTE_NAME;
    }

    public BT_ExceptionsAttribute(BT_ClassVector de) {
        this.declaredExceptions = de;
    }

    BT_ExceptionsAttribute(byte[] data, BT_ConstantPool pool) throws BT_ClassFileException, IOException {
        if (data.length < 2) {
            throw new BT_ClassFileException("Exceptions attribute length");
        }
        int ne = BT_Misc.bytesToUnsignedShort(data, 0);
        if (data.length != 2 + 2 * ne) {
            throw new BT_ClassFileException("Exceptions attribute length");
        }
        this.declaredExceptions = new BT_ClassVector(ne);
        int ie = 2;
        while (ie < data.length) {
            int index = BT_Misc.bytesToUnsignedShort(data, ie);
            if (index != 0) {
                this.declaredExceptions.addElement(pool.getRepository().forName(pool.getClassNameAt(index, 7)));
            }
            ie += 2;
        }
    }

    public BT_ExceptionsAttribute(Method m, BT_Repository repo) {
        Class<?>[] etypes = m.getExceptionTypes();
        this.declaredExceptions = new BT_ClassVector(etypes.length);
        int n = 0;
        while (n < etypes.length) {
            this.declaredExceptions.addElement(repo.forName(etypes[n].getName()));
            ++n;
        }
    }

    public void resolve(BT_ConstantPool pool) {
        super.resolve(pool);
        int ie = 0;
        while (ie < this.declaredExceptions.size()) {
            pool.indexOfClassRef(this.declaredExceptions.elementAt(ie));
            ++ie;
        }
    }

    void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        BT_Repository.debugRecentlyWrittenAttribute = this;
        dos.writeShort(pool.indexOfUtf8(ATTRIBUTE_NAME));
        dos.writeInt(2 + 2 * this.declaredExceptions.size());
        dos.writeShort(this.declaredExceptions.size());
        int ie = 0;
        while (ie < this.declaredExceptions.size()) {
            dos.writeShort(pool.indexOfClassRef(this.declaredExceptions.elementAt(ie)));
            ++ie;
        }
    }

    public String toString() {
        return "Exceptions size=" + this.declaredExceptions.size();
    }
}

