/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_ExceptionTableEntry
extends BT_Base {
    public int startPC;
    public int endPC;
    public int handlerPC;
    public BT_Ins startPCTarget;
    public BT_Ins endPCTarget;
    public BT_Ins handlerTarget;
    public BT_Class catchType;

    public BT_ExceptionTableEntry(int startPC, int endPC, int handlerPC, String type, BT_Repository repo) {
        this.startPC = startPC;
        this.endPC = endPC;
        this.handlerPC = handlerPC;
        if (!type.equals("<finally>")) {
            this.catchType = repo.forName(type);
        }
    }

    public BT_ExceptionTableEntry(BT_Ins startPCTarget, BT_Ins endPCTarget, BT_Ins handlerTarget, BT_Class catchType) {
        this.startPCTarget = startPCTarget;
        this.endPCTarget = endPCTarget;
        this.handlerTarget = handlerTarget;
        this.catchType = catchType;
    }

    void dereference(BT_InsVector ins, BT_ConstantPool pool) {
        if (this.startPCTarget != null) {
            return;
        }
        this.startPCTarget = ins.findBasicBlock(this.startPC);
        this.endPCTarget = ins.findBasicBlock(this.endPC);
        this.handlerTarget = ins.findBasicBlock(this.handlerPC);
        this.handlerPC = -1;
        this.endPC = -1;
        this.startPC = -1;
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        if (this.catchType != null) {
            pool.indexOfClassRef(this.catchType);
        }
    }

    public void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
        if (this.startPCTarget == oldIns) {
            this.startPCTarget = newIns;
        }
        if (this.endPCTarget == oldIns) {
            this.endPCTarget = newIns;
        }
        if (this.handlerTarget == oldIns) {
            this.handlerTarget = newIns;
        }
    }

    void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeShort(this.startPCTarget.byteIndex);
        dos.writeShort(this.endPCTarget.byteIndex);
        dos.writeShort(this.handlerTarget.byteIndex);
        if (this.catchType != null) {
            dos.writeShort(pool.indexOfClassRef(this.catchType));
        } else {
            dos.writeByte(0);
            dos.writeByte(0);
        }
    }

    public boolean isEmpty() {
        return this.startPCTarget == this.endPCTarget;
    }

    public String toString() {
        if (this.startPCTarget == null) {
            return "[from " + this.startPC + " to before " + this.endPC + " catch(" + this.catchType + ") at " + this.handlerPC + "]";
        }
        if (this.catchType != null) {
            return "[from " + this.startPCTarget.byteIndex + " to before " + this.endPCTarget.byteIndex + " catch(" + this.catchType.name + ") at " + this.handlerTarget.byteIndex + "]";
        }
        return "exception [from " + this.startPCTarget.byteIndex + " to before " + this.endPCTarget.byteIndex + " finally at " + this.handlerTarget.byteIndex + "]";
    }

    public String toAssemblerString() {
        String catchTypeName = "(any)";
        if (this.catchType != null) {
            catchTypeName = this.catchType.name;
        }
        return "exception from " + this.startPCTarget.getLabel() + " to " + this.endPCTarget.getLabel() + " catch " + catchTypeName + " handler " + this.handlerTarget.getLabel();
    }
}

