/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_AnyConstantValue;
import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_ConstantValueAttribute
extends BT_Attribute {
    public static final String ATTRIBUTE_NAME = "ConstantValue";
    private final int dataLength = 2;
    private BT_AnyConstantValue value;

    public String getName() {
        return ATTRIBUTE_NAME;
    }

    BT_ConstantValueAttribute(byte[] data, BT_ConstantPool pool, BT_Class fieldType) throws BT_ClassFileException {
        if (data.length != 2) {
            throw new BT_ClassFileException("ConstantValue attribute length");
        }
        int poolIndex = BT_Misc.bytesToUnsignedShort(data, 0);
        this.value = BT_AnyConstantValue.create(pool, poolIndex, fieldType);
    }

    public int cpIndex(BT_ConstantPool pool) {
        return pool.indexOfItem(this.value);
    }

    public void resolve(BT_ConstantPool pool) {
        super.resolve(pool);
        this.cpIndex(pool);
    }

    void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeShort(pool.indexOfUtf8(ATTRIBUTE_NAME));
        dos.writeInt(2);
        dos.writeShort(this.cpIndex(pool));
    }

    public BT_AnyConstantValue getValue() {
        return this.value;
    }

    public String toString() {
        String val = this.value.toString();
        return val;
    }
}

