/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_ClassFileException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_ConstantPoolItem
extends BT_Base {
    public int index1;
    public int index2;
    public int intValue;
    public long longValue;
    public float floatValue;
    public double doubleValue;
    public String strValue;
    public Object value1;
    public Object value2;
    final byte type_;
    public static final String[] BT_ItemName = new String[]{"??????", "UTF8", "??????", "INTEGER", "FLOAT", "LONG", "DOUBLE", "CLASS", "STRING", "FIELDREF", "METHODREF", "INTERFACEMETHODREF", "NAMEANDTYPE", "<dummy>"};

    BT_ConstantPoolItem(int type) {
        this.type_ = (byte)type;
    }

    public static BT_ConstantPoolItem getDummy() {
        return new BT_ConstantPoolItem(13);
    }

    public String strValue() {
        return this.strValue;
    }

    public byte type() {
        return this.type_;
    }

    void read(DataInputStream dis) throws BT_ClassFileException, IOException {
        switch (this.type_) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.index1 = dis.readUnsignedShort();
                this.index2 = dis.readUnsignedShort();
                break;
            }
            case 7: 
            case 8: {
                this.index1 = dis.readUnsignedShort();
                break;
            }
            case 3: {
                this.intValue = dis.readInt();
                break;
            }
            case 4: {
                this.floatValue = dis.readFloat();
                break;
            }
            case 5: {
                this.longValue = dis.readLong();
                break;
            }
            case 6: {
                this.doubleValue = dis.readDouble();
                break;
            }
            case 1: {
                this.strValue = this.readUTF(dis);
                break;
            }
            default: {
                throw new BT_ClassFileException("unexpected constant pool entry type " + this.type_);
            }
        }
    }

    final String readUTF(DataInputStream dis) throws BT_ClassFileException, IOException {
        return dis.readUTF();
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type_);
        switch (this.type_) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                dos.writeShort(this.index1);
                dos.writeShort(this.index2);
                break;
            }
            case 7: 
            case 8: {
                dos.writeShort(this.index1);
                break;
            }
            case 3: {
                dos.writeInt(this.intValue);
                break;
            }
            case 4: {
                dos.writeFloat(this.floatValue);
                break;
            }
            case 5: {
                dos.writeLong(this.longValue);
                break;
            }
            case 6: {
                dos.writeDouble(this.doubleValue);
                break;
            }
            case 1: {
                dos.writeUTF(this.strValue);
            }
        }
    }

    public String toString() {
        String s;
        try {
            s = String.valueOf(BT_ItemName[this.type_]) + " ";
        }
        catch (Exception e) {
            s = "<unknown type> ";
        }
        switch (this.type_) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                s = String.valueOf(s) + this.index1 + " " + this.index2;
                break;
            }
            case 7: 
            case 8: {
                s = String.valueOf(s) + this.index1;
                break;
            }
            case 3: {
                s = String.valueOf(s) + this.intValue;
                break;
            }
            case 4: {
                s = String.valueOf(s) + this.floatValue;
                break;
            }
            case 5: {
                s = String.valueOf(s) + this.longValue;
                break;
            }
            case 6: {
                s = String.valueOf(s) + this.doubleValue;
                break;
            }
            case 1: {
                s = String.valueOf(s) + this.strValue;
                break;
            }
            case 13: {
                s = String.valueOf(s) + "<spacer for previous long/double constant>";
            }
        }
        return s;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BT_ConstantPoolItem)) {
            return false;
        }
        BT_ConstantPoolItem other = (BT_ConstantPoolItem)o;
        if (this.type_ != other.type_) {
            return false;
        }
        switch (this.type_) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.value1 == other.value1;
            }
            case 12: {
                return this.value1 == other.value1 && this.value2 == other.value2;
            }
            case 3: {
                return this.intValue == other.intValue;
            }
            case 4: {
                return this.floatValue == other.floatValue;
            }
            case 5: {
                return this.longValue == other.longValue;
            }
            case 6: {
                return this.doubleValue == other.doubleValue;
            }
            case 1: {
                return this.strValue == other.strValue || this.strValue.equals(other.strValue);
            }
        }
        return super.equals(o);
    }

    public int hashCode() {
        switch (this.type_) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.value1.hashCode();
            }
            case 12: {
                return this.value1.hashCode() + this.value2.hashCode();
            }
            case 3: {
                return this.intValue;
            }
            case 4: {
                return (int)this.floatValue;
            }
            case 5: {
                return (int)this.longValue;
            }
            case 6: {
                return (int)this.doubleValue;
            }
            case 1: {
                return this.strValue.hashCode();
            }
        }
        return super.hashCode();
    }
}

