/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_AnyConstantValue;
import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_ClassVector;
import com.ibm.jikesbt.BT_ConstantPoolItem;
import com.ibm.jikesbt.BT_ConstantPoolItemVector;
import com.ibm.jikesbt.BT_Field;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;

public class BT_ConstantPool
extends BT_Base {
    public BT_ConstantPoolItemVector items;
    HashMap itemMap = new HashMap(32);
    boolean locked_ = false;
    private static final char JAVA_FILE_SEPARATOR_SLASH = '/';
    private String className;
    private BT_Repository repository;
    private static final Hashtable internalClassNames_ = new Hashtable();
    private static final Hashtable internalNames_ = new Hashtable();
    public static final byte UTF8 = 1;
    public static final byte INTEGER = 3;
    public static final byte FLOAT = 4;
    public static final byte LONG = 5;
    public static final byte DOUBLE = 6;
    public static final byte CLASS = 7;
    public static final byte STRING = 8;
    public static final byte FIELDREF = 9;
    public static final byte METHODREF = 10;
    public static final byte INTERFACEMETHODREF = 11;
    public static final byte NAMEANDTYPE = 12;
    public static final byte DUMMY = 13;

    public BT_Repository getRepository() {
        return this.repository;
    }

    public BT_ConstantPool(BT_Repository repository, String className) {
        this.repository = repository;
        this.className = className;
        this.items = new BT_ConstantPoolItemVector(1);
        this.items.addElement(new BT_ConstantPoolItem(99));
    }

    public BT_ConstantPool(BT_Repository repository) {
        this(repository, "<unknown>");
    }

    public void lock() {
        this.locked_ = true;
    }

    public void unLock() {
        this.locked_ = false;
    }

    public void closure() throws BT_ClassFileException {
        int n = 1;
        while (n < this.items.size()) {
            BT_ConstantPoolItem item = this.items.elementAt(n);
            if (item.type_ == 7) {
                String name = this.getClassNameAt(n, 7);
                BT_Class bT_Class = this.repository.forName(name);
            }
            ++n;
        }
    }

    public byte getEntryTypeAt(int index) throws BT_ClassFileException {
        return this.items.elementAt((int)index).type_;
    }

    public String getSimpleNameAt(int index) throws BT_ClassFileException {
        String name = this.getUtf8At(index);
        return name;
    }

    public String getFieldDescriptorAt(int index) throws BT_ClassFileException {
        return BT_ConstantPool.toFieldDescriptor(this.getUtf8At(index));
    }

    public String getMethodDescriptorAt(int index) throws BT_ClassFileException {
        return BT_ConstantPool.toMethodDescriptor(this.getUtf8At(index));
    }

    public String getClassNameAt(int index, int expectedType) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        if (item.type_ == 7) {
            String className = this.getUtf8At(item.index1);
            if (className.charAt(0) == '[') {
                return BT_ConstantPool.toJavaName(className);
            }
            return className.replace('/', '.');
        }
        if (item.index1 == index) {
            throw new BT_ClassFileException("cannot find class name at index " + index);
        }
        return this.getClassNameAt(item.index1, 7);
    }

    private static boolean isValidIdentifier(String name) {
        int len = name.length();
        int p = 0;
        boolean valid = false;
        block0: while (p < len) {
            char c = name.charAt(p);
            if (!Character.isJavaIdentifierStart(c)) {
                return false;
            }
            valid = true;
            while (++p < len) {
                c = name.charAt(p);
                if (c == '/') {
                    valid = false;
                    ++p;
                    continue block0;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
        }
        return valid;
    }

    private static boolean isValidSimpleName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isJavaIdentifierStart(c) && c != '<') {
            return false;
        }
        int p = 0;
        while (++p < len) {
            c = name.charAt(p);
            if (Character.isJavaIdentifierPart(c) || c == '>') continue;
            return false;
        }
        return true;
    }

    private static String toFieldDescriptor(String name) throws BT_ClassFileException {
        return BT_ConstantPool.toJavaName(name);
    }

    private static String toMethodDescriptor(String name) throws BT_ClassFileException {
        return name;
    }

    public String getNameAndTypeNameAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return this.getSimpleNameAt(item.index1);
    }

    public String getNameAndTypeTypeAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return this.getUtf8At(item.index2);
    }

    public String getMethodNameAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return this.getNameAndTypeNameAt(item.index2);
    }

    public String getMethodTypeAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return BT_ConstantPool.toMethodDescriptor(this.getNameAndTypeTypeAt(item.index2));
    }

    public String getFieldNameAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return this.getNameAndTypeNameAt(item.index2);
    }

    public String getFieldTypeAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return BT_ConstantPool.toFieldDescriptor(this.getNameAndTypeTypeAt(item.index2));
    }

    public String getStringAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return this.getUtf8At(item.index1);
    }

    public float getFloatAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return item.floatValue;
    }

    public int getIntegerAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return item.intValue;
    }

    public long getLongAt(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return item.longValue;
    }

    public double getDoubleAt(int index) throws BT_ClassFileException {
        if (index < 1 || index >= this.items.size()) {
            throw new BT_ClassFileException("invalid DOUBLE cp index " + index);
        }
        BT_ConstantPoolItem item = this.items.elementAt(index);
        if (item.type_ != 6) {
            throw new BT_ClassFileException("expected DOUBLE at cp index " + index);
        }
        return item.doubleValue;
    }

    public String getUtf8At(int index) throws BT_ClassFileException {
        BT_ConstantPoolItem item = this.items.elementAt(index);
        return item.strValue;
    }

    public int indexOfUtf8(String utf8) {
        if (utf8 == null) {
            return 0;
        }
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(1);
        searchItem.strValue = utf8;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfString(String value) {
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(8);
        searchItem.value1 = value;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        searchItem.index1 = this.indexOfUtf8(value);
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfInteger(int value) {
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(3);
        searchItem.intValue = value;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfFloat(float value) {
        int n = 0;
        while (n < this.items.size()) {
            BT_ConstantPoolItem item = this.items.elementAt(n);
            if (item.type_ == 4 && (item.floatValue == value || Float.isNaN(item.floatValue) && Float.isNaN(value))) {
                return n;
            }
            ++n;
        }
        BT_ConstantPoolItem item = new BT_ConstantPoolItem(4);
        item.floatValue = value;
        this.items.addElement(item);
        return this.items.size() - 1;
    }

    public int indexOfDouble(double value) {
        int n = 0;
        while (n < this.items.size()) {
            BT_ConstantPoolItem item = this.items.elementAt(n);
            if (item.type_ == 6 && (item.doubleValue == value || Double.isNaN(item.doubleValue) && Double.isNaN(value))) {
                return n;
            }
            ++n;
        }
        BT_ConstantPoolItem item = new BT_ConstantPoolItem(6);
        item.doubleValue = value;
        this.items.addElement(item);
        this.items.addElement(BT_ConstantPoolItem.getDummy());
        return this.items.size() - 2;
    }

    public int indexOfLong(long value) {
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(5);
        searchItem.longValue = value;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.items.addElement(BT_ConstantPoolItem.getDummy());
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfClassRef(BT_Class cls) {
        if (cls == null) {
            return 0;
        }
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(7);
        searchItem.value1 = cls;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        String internalName = cls.isArray() ? BT_ConstantPool.toInternalName(cls.name) : BT_ConstantPool.toInternalClassName(cls.name);
        searchItem.index1 = this.indexOfUtf8(internalName);
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfNameAndType(String name, String type) {
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(12);
        searchItem.value1 = name;
        searchItem.value2 = type;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        searchItem.index1 = this.indexOfUtf8(name);
        searchItem.index2 = this.indexOfUtf8(type);
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfMethodRef(BT_Method m) {
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(10);
        searchItem.value1 = m;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        searchItem.index1 = this.indexOfClassRef(m.cls);
        searchItem.index2 = this.indexOfNameAndType(m.name, m.signature.toString());
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfInterfaceMethodRef(BT_Method m) {
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(11);
        searchItem.value1 = m;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        searchItem.index1 = this.indexOfClassRef(m.cls);
        searchItem.index2 = this.indexOfNameAndType(m.name, m.signature.toString());
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfFieldRef(BT_Field f) {
        BT_ConstantPoolItem searchItem = new BT_ConstantPoolItem(9);
        searchItem.value1 = f;
        Integer index = (Integer)this.itemMap.get(searchItem);
        if (index != null) {
            return index;
        }
        String signature = BT_ConstantPool.toInternalName(f.type.name);
        searchItem.index1 = this.indexOfClassRef(f.cls);
        searchItem.index2 = this.indexOfNameAndType(f.name, signature);
        int size = this.items.size();
        this.items.addElement(searchItem);
        this.itemMap.put(searchItem, new Integer(size));
        return size;
    }

    public int indexOfItem(BT_AnyConstantValue acv) {
        return acv.findInPool(this);
    }

    void read(DataInputStream dis) throws BT_ClassFileException, IOException {
        int count = dis.readUnsignedShort();
        this.items.ensureCapacity(count + 1);
        int n = 1;
        while (n < count) {
            BT_ConstantPoolItem item = new BT_ConstantPoolItem(dis.readByte());
            item.read(dis);
            this.items.addElement(item);
            if (item.type_ == 5 || item.type_ == 6) {
                this.items.addElement(BT_ConstantPoolItem.getDummy());
                ++n;
            }
            ++n;
        }
        this.verifyItems();
    }

    void verifyItems() throws BT_ClassFileException {
        int n = 1;
        while (n < this.items.size()) {
            BT_ConstantPoolItem item = this.items.elementAt(n);
            switch (item.type_) {
                case 9: {
                    this.getClassNameAt(n, item.type_);
                    this.getFieldNameAt(n);
                    this.getFieldTypeAt(n);
                    break;
                }
                case 10: {
                    this.getClassNameAt(n, item.type_);
                    this.getMethodNameAt(n);
                    this.getMethodTypeAt(n);
                    break;
                }
                case 11: {
                    this.getClassNameAt(n, item.type_);
                    this.getMethodNameAt(n);
                    this.getMethodTypeAt(n);
                    break;
                }
                case 8: {
                    this.getStringAt(n);
                    break;
                }
                case 7: {
                    this.getClassNameAt(n, item.type_);
                    break;
                }
                case 3: {
                    this.getIntegerAt(n);
                    break;
                }
                case 4: {
                    this.getFloatAt(n);
                    break;
                }
                case 5: {
                    this.getLongAt(n);
                    break;
                }
                case 6: {
                    this.getDoubleAt(n);
                    break;
                }
                case 1: {
                    this.getUtf8At(n);
                }
            }
            ++n;
        }
    }

    void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.size());
        int n = 1;
        while (n < this.items.size()) {
            BT_ConstantPoolItem item = this.items.elementAt(n);
            item.write(dos);
            if (item.type_ == 5 || item.type_ == 6) {
                ++n;
            }
            ++n;
        }
    }

    public boolean containsInnerClassNames() throws BT_ClassFileException {
        int n = 1;
        while (n < this.items.size()) {
            BT_ConstantPoolItem item = this.items.elementAt(n);
            if (item.type_ == 7 && this.getClassNameAt(n, 7).indexOf(26) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String toJavaName(String shortName, int index) {
        arrayDimension = 0;
        x = new StringBuffer();
        while (shortName.charAt(index) == '[') {
            ++arrayDimension;
            ++index;
        }
        if (arrayDimension > 255) {
            throw new InternalError("array descriptor exceeds 255 dimensions");
        }
        switch (shortName.charAt(index)) {
            case 'B': {
                x.append("byte");
                ** GOTO lbl60
            }
            case 'C': {
                x.append("char");
                ** GOTO lbl60
            }
            case 'D': {
                x.append("double");
                ** GOTO lbl60
            }
            case 'F': {
                x.append("float");
                ** GOTO lbl60
            }
            case 'I': {
                x.append("int");
                ** GOTO lbl60
            }
            case 'J': {
                x.append("long");
                ** GOTO lbl60
            }
            case 'L': {
                end = shortName.indexOf(59, index);
                i = index + 1;
                while (i < end) {
                    x.append(shortName.charAt(i) != '/' ? shortName.charAt(i) : '.');
                    ++i;
                }
                ** GOTO lbl60
            }
            case 'V': {
                x.append("void");
                ** GOTO lbl60
            }
            case 'S': {
                x.append("short");
                ** GOTO lbl60
            }
            case 'Z': {
                x.append("boolean");
                if (true) ** GOTO lbl60
            }
            default: {
                throw new InternalError("invalid type name");
            }
        }
        do {
            x.append("[]");
lbl60:
            // 11 sources

        } while (arrayDimension-- > 0);
        return x.toString();
    }

    public static String toJavaName(String shortName) {
        return BT_ConstantPool.toJavaName(shortName, 0);
    }

    public static String toInternalClassName(String javaClassName) {
        String result = (String)internalClassNames_.get(javaClassName);
        if (result != null) {
            return result;
        }
        result = javaClassName.replace('.', '/');
        internalClassNames_.put(javaClassName, result);
        return result;
    }

    public static String toInternalName(String javaName) {
        String result = (String)internalNames_.get(javaName);
        if (result != null) {
            return result;
        }
        int index = javaName.indexOf(91);
        String string = result = index > -1 ? javaName.substring(0, index) : javaName;
        result = result.equals("byte") ? "B" : (result.equals("char") ? "C" : (result.equals("double") ? "D" : (result.equals("float") ? "F" : (result.equals("int") ? "I" : (result.equals("long") ? "J" : (result.equals("void") ? "V" : (result.equals("boolean") ? "Z" : (result.equals("short") ? "S" : "L" + result.replace('.', '/') + ";"))))))));
        if (index > -1) {
            StringBuffer s = new StringBuffer();
            int n = (javaName.length() - index) / 2;
            while (n > 0) {
                s.append("[");
                --n;
            }
            s.append(result);
            result = s.toString();
        }
        internalNames_.put(javaName, result);
        return result;
    }

    public static String toInternalName(BT_Class c) {
        return BT_ConstantPool.toInternalName(c.name);
    }

    public static int nextSig(String sig, int index) {
        while (sig.charAt(index) == '[') {
            ++index;
        }
        if (sig.charAt(index) == 'L') {
            while (sig.charAt(index) != ';') {
                ++index;
            }
        }
        return ++index;
    }

    public static BT_ClassVector getArgumentTypes(String intSig, BT_Repository repo) {
        BT_ClassVector v = new BT_ClassVector();
        int i = 1;
        while (intSig.charAt(i) != ')') {
            v.addElement(repo.forName(BT_ConstantPool.toJavaName(intSig, i)));
            i = BT_ConstantPool.nextSig(intSig, i);
        }
        return v;
    }

    public static String getReturnType(String shortName) {
        return BT_ConstantPool.toJavaName(shortName, shortName.indexOf(41) + 1);
    }

    public int size() {
        return this.items.size();
    }

    public BT_ConstantPoolItem elementAt(int n) {
        return this.items.elementAt(n);
    }

    public void print(PrintStream ps) {
        ps.print("Pool:");
        int n = 1;
        while (n < this.items.size()) {
            ps.print("    " + n + " " + this.items.elementAt(n));
            ++n;
        }
        ps.print("");
    }

    public String toString() {
        String result = "Pool: ";
        int n = 1;
        while (n < this.items.size()) {
            result = String.valueOf(result) + BT_Base.endl() + "   " + n + " " + this.items.elementAt(n);
            ++n;
        }
        return String.valueOf(result) + BT_Base.endl();
    }
}

