/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_ConstantWideIns;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_ConstantLongIns
extends BT_ConstantWideIns {
    public long value;

    BT_ConstantLongIns(int op, long value) {
        this(op, -1, value);
    }

    BT_ConstantLongIns(int op, int index, long value) {
        super(op, index);
        this.value = value;
    }

    public void dereference(BT_InsVector items) {
        this.setOpcode();
    }

    private void setOpcode() {
        this.opcode = this.value == 0L ? 9 : (this.value == 1L ? 10 : 20);
    }

    public int size() {
        if (this.opcode == 9 || this.opcode == 10) {
            return 1;
        }
        return 3;
    }

    public boolean optimize(BT_CodeAttribute code, int n, boolean strict) {
        BT_Ins next;
        BT_InsVector ins = code.ins;
        BT_Ins bT_Ins = next = ins.size() > n + 1 ? ins.elementAt(n + 1) : null;
        if (next != null && next instanceof BT_ConstantLongIns && ((BT_ConstantLongIns)next).value == this.value) {
            return code.replaceInstructionsAtWith(1, n + 1, BT_Ins.make(92));
        }
        return super.optimize(code, n, strict);
    }

    protected int constantIndex(BT_ConstantPool pool) {
        return pool.indexOfLong(this.value);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.setOpcode();
        if (this.opcode == 20) {
            this.constantIndex(pool);
        }
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.opcode == 9 || this.opcode == 10) {
            dos.writeByte(this.opcode);
        } else {
            dos.writeByte(20);
            dos.writeShort(this.constantIndex(pool));
            if (this.size() != 3) {
                throw new InternalError("Write/size error " + this);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " (long) " + this.value;
    }

    public String toAssemblerString() {
        return String.valueOf(BT_Misc.opcodeName[this.opcode]) + " (long) " + this.value;
    }

    String appendValueTo(String other) {
        return String.valueOf(other) + this.value;
    }

    public Object clone() {
        return new BT_ConstantLongIns(this.opcode, this.value);
    }
}

