/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantIns;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Factory;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_JumpIns;
import com.ibm.jikesbt.BT_JumpOffsetIns;
import com.ibm.jikesbt.BT_LoadLocalIns;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_StoreLocalIns;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_ConstantIntegerIns
extends BT_ConstantIns {
    public int value;

    BT_ConstantIntegerIns(int op, int value) {
        this(op, -1, value);
    }

    BT_ConstantIntegerIns(int op, int index, int value) {
        super(op, index);
        this.value = value;
    }

    public void dereference(BT_InsVector items) {
        this.setOpcode();
    }

    private void setOpcode() {
        this.opcode = this.value >= -1 && this.value <= 5 ? (int)((byte)(3 + this.value)) : (this.value >= -128 && this.value <= 127 ? 16 : (this.value >= Short.MIN_VALUE && this.value <= Short.MAX_VALUE ? 17 : 18));
    }

    protected int constantIndex(BT_ConstantPool pool) {
        return pool.indexOfInteger(this.value);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.setOpcode();
        if (this.opcode == 18) {
            this.opcode = this.constantIndex(pool) > 255 ? 19 : 18;
        }
    }

    public int getIntValue() {
        return this.value;
    }

    public boolean optimize(BT_CodeAttribute code, int n, boolean strict) {
        BT_Ins next;
        BT_Factory factory = code.method.getDeclaringClass().getRepository().factory;
        BT_InsVector ins = code.ins;
        BT_Ins bT_Ins = next = ins.size() > n + 1 ? ins.elementAt(n + 1) : null;
        if (next != null && next instanceof BT_ConstantIntegerIns && this.value == next.getIntValue()) {
            return code.replaceInstructionsAtWith(1, n + 1, BT_Ins.make(89));
        }
        if (next != null && next.opcode == 116) {
            return code.replaceInstructionsAtWith(2, n, BT_Ins.make(18, -this.getIntValue()));
        }
        if (next != null && this.value == 0) {
            switch (next.opcode) {
                case 104: 
                case 126: {
                    return code.replaceInstructionsAtWith(2, n, BT_Ins.make(87), BT_Ins.make(18, 0));
                }
                case 108: 
                case 112: {
                    factory.noteAnomalyInClass("Division by zero detected at bytecode " + (n + 1) + " of method " + code.method);
                    return false;
                }
                case 96: 
                case 100: 
                case 120: 
                case 122: 
                case 124: 
                case 128: {
                    return code.removeInstructionsAt(2, n);
                }
            }
        }
        if (next != null && this.value == 1) {
            switch (next.opcode) {
                case 112: {
                    return code.replaceInstructionsAtWith(2, n, BT_Ins.make(87), BT_Ins.make(18, 0));
                }
                case 104: 
                case 108: {
                    return code.removeInstructionsAt(2, n);
                }
            }
        }
        if (next != null && this.value == 2) {
            switch (next.opcode) {
                case 104: {
                    return code.replaceInstructionsAtWith(2, n, BT_Ins.make(4), BT_Ins.make(120));
                }
            }
        }
        if (next != null && this.value == 4) {
            switch (next.opcode) {
                case 104: {
                    return code.replaceInstructionsAtWith(2, n, BT_Ins.make(5), BT_Ins.make(120));
                }
            }
        }
        if (next != null && this.value == 8) {
            switch (next.opcode) {
                case 104: {
                    return code.replaceInstructionsAtWith(2, n, BT_Ins.make(6), BT_Ins.make(120));
                }
            }
        }
        if (ins.size() > n + 2 && next instanceof BT_ConstantIntegerIns) {
            switch (ins.elementAt((int)(n + 2)).opcode) {
                case 96: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value + next.getIntValue()));
                }
                case 100: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value - next.getIntValue()));
                }
                case 104: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value * next.getIntValue()));
                }
                case 108: {
                    int nextValue = next.getIntValue();
                    if (nextValue == 0) {
                        factory.noteAnomalyInClass("Division by zero detected at bytecode " + (n + 1) + " of method " + code.method);
                        return false;
                    }
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value / nextValue));
                }
                case 112: {
                    int nextValue = next.getIntValue();
                    if (nextValue == 0) {
                        factory.noteAnomalyInClass("Division by zero detected at bytecode " + (n + 1) + " of method " + code.method);
                        return false;
                    }
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value % nextValue));
                }
                case 120: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value << next.getIntValue()));
                }
                case 122: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value >> next.getIntValue()));
                }
                case 124: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value >>> next.getIntValue()));
                }
                case 126: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value & next.getIntValue()));
                }
                case 128: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value | next.getIntValue()));
                }
                case 130: {
                    return code.replaceInstructionsAtWith(3, n, BT_Ins.make(18, this.value ^ next.getIntValue()));
                }
            }
        }
        if (ins.size() > n + 3 && next instanceof BT_LoadLocalIns && ins.elementAt(n + 2) instanceof BT_StoreLocalIns && ins.elementAt((int)(n + 3)).opcode == 87) {
            code.removeInstructionsAt(1, n + 3);
            return code.removeInstructionsAt(1, n);
        }
        if (next != null && next instanceof BT_JumpIns) {
            if (next.opcode == 153 && this.value == 0 || next.opcode == 154 && this.value != 0) {
                return code.replaceInstructionsAtWith(2, n, new BT_JumpOffsetIns(167, -1, ((BT_JumpIns)next).target));
            }
            if (next.opcode == 153 && this.value != 0 || next.opcode == 154 && this.value == 0) {
                return code.removeInstructionsAt(2, n);
            }
        }
        return super.optimize(code, n, strict);
    }

    public String toString() {
        if (this.value > 5) {
            return String.valueOf(super.toString()) + " " + this.value;
        }
        return super.toString();
    }

    public String toAssemblerString() {
        if (this.value > 5) {
            return String.valueOf(super.toAssemblerString()) + " " + this.value;
        }
        return super.toAssemblerString();
    }

    public int size() {
        switch (this.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 17: {
                return 3;
            }
            case 18: {
                return 2;
            }
            case 19: {
                return 3;
            }
        }
        throw new InternalError("unexpected " + BT_Misc.opcodeName[this.opcode]);
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.value >= -1 && this.value <= 5) {
            dos.writeByte(3 + this.value);
        } else if (this.value >= -128 && this.value <= 127) {
            dos.writeByte(16);
            dos.writeByte(this.value);
        } else if (this.value >= Short.MIN_VALUE && this.value <= Short.MAX_VALUE) {
            dos.writeByte(17);
            dos.writeShort(this.value);
        } else {
            super.write(dos, pool);
        }
    }

    String appendValueTo(String other) {
        return String.valueOf(other) + this.value;
    }

    public Object clone() {
        return new BT_ConstantIntegerIns(this.opcode, this.value);
    }
}

