/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_ConstantIns;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_ConstantFloatIns
extends BT_ConstantIns {
    public float value;

    BT_ConstantFloatIns(int op, float value) {
        this(op, -1, value);
    }

    BT_ConstantFloatIns(int op, int index, float value) {
        super(op, index);
        this.value = value;
    }

    public void dereference(BT_InsVector items) {
        this.setOpcode();
    }

    private void setOpcode() {
        this.opcode = this.value == 0.0f ? (new Float(this.value).equals(new Float(0.0f)) ? 11 : 18) : (this.value == 1.0f ? 12 : (this.value == 2.0f ? 13 : 18));
    }

    protected int constantIndex(BT_ConstantPool pool) {
        return pool.indexOfFloat(this.value);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.setOpcode();
        if (this.opcode == 18) {
            this.opcode = this.constantIndex(pool) > 255 ? 19 : 18;
        }
    }

    public int size() {
        switch (this.opcode) {
            case 11: 
            case 12: 
            case 13: {
                return 1;
            }
            case 18: {
                return 2;
            }
            case 19: {
                return 3;
            }
        }
        throw new InternalError("unexpected " + BT_Misc.opcodeName[this.opcode]);
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.opcode != 18 && this.opcode != 19) {
            dos.writeByte(this.opcode);
        } else {
            super.write(dos, pool);
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " (float) " + this.value;
    }

    public String toAssemblerString() {
        return String.valueOf(BT_Misc.opcodeName[this.opcode]) + " (float) " + this.value;
    }

    String appendValueTo(String other) {
        return String.valueOf(other) + this.value;
    }

    public Object clone() {
        return new BT_ConstantFloatIns(this.opcode, this.value);
    }
}

