/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_CodeAttribute;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_ConstantWideIns;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Misc;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BT_ConstantDoubleIns
extends BT_ConstantWideIns {
    public double value;

    BT_ConstantDoubleIns(int op, double value) {
        this(op, -1, value);
    }

    BT_ConstantDoubleIns(int op, int index, double value) {
        super(op, index);
        this.value = value;
    }

    public void dereference(BT_InsVector items) {
        this.setOpcode();
    }

    private void setOpcode() {
        this.opcode = this.value == 0.0 ? (new Double(this.value).equals(new Double(0.0)) ? 14 : 20) : (this.value == 1.0 ? 15 : 20);
    }

    public int size() {
        if (this.opcode == 14 || this.opcode == 15) {
            return 1;
        }
        return 3;
    }

    public boolean optimize(BT_CodeAttribute code, int n, boolean strict) {
        BT_InsVector ins = code.ins;
        BT_Ins next = ins.elementAt(n + 1);
        if (ins.size() > n + 1 && next instanceof BT_ConstantDoubleIns && ((BT_ConstantDoubleIns)next).value == this.value) {
            return code.replaceInstructionsAtWith(1, n + 1, BT_Ins.make(92));
        }
        return super.optimize(code, n, strict);
    }

    protected int constantIndex(BT_ConstantPool pool) {
        return pool.indexOfDouble(this.value);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        this.setOpcode();
        if (this.opcode == 20) {
            this.constantIndex(pool);
        }
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.opcode == 14 || this.opcode == 15) {
            dos.writeByte(this.opcode);
        } else {
            dos.writeByte(20);
            dos.writeShort(this.constantIndex(pool));
            if (this.size() != 3) {
                throw new InternalError("Write/size error " + this);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " (double) " + this.value;
    }

    public String toAssemblerString() {
        return String.valueOf(BT_Misc.opcodeName[this.opcode]) + " (double) " + this.value;
    }

    String appendValueTo(String other) {
        return String.valueOf(other) + this.value;
    }

    public Object clone() {
        return new BT_ConstantDoubleIns(this.opcode, this.value);
    }
}

