/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Attribute;
import com.ibm.jikesbt.BT_AttributeContainer;
import com.ibm.jikesbt.BT_Base;
import com.ibm.jikesbt.BT_BasicBlockMarkerIns;
import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ClassFileException;
import com.ibm.jikesbt.BT_CodeVisitor;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_ExceptionTableEntry;
import com.ibm.jikesbt.BT_ExceptionTableEntryVector;
import com.ibm.jikesbt.BT_Factory;
import com.ibm.jikesbt.BT_FieldRefIns;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_InvokeSpecialIns;
import com.ibm.jikesbt.BT_JumpIns;
import com.ibm.jikesbt.BT_JumpOffsetIns;
import com.ibm.jikesbt.BT_Local;
import com.ibm.jikesbt.BT_LocalVariableAttribute;
import com.ibm.jikesbt.BT_LocalVector;
import com.ibm.jikesbt.BT_Member;
import com.ibm.jikesbt.BT_Method;
import com.ibm.jikesbt.BT_MethodRefIns;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_Opcodes;
import com.ibm.jikesbt.BT_Repository;
import com.ibm.jikesbt.BT_StoreLocalIns;
import com.ibm.jikesbt.BT_SwitchIns;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public final class BT_CodeAttribute
extends BT_AttributeContainer
implements BT_Opcodes {
    private static final boolean TRACE = false;
    public static final String ATTRIBUTE_NAME = "Code";
    static BT_CodeAttribute currentCodeAttribute;
    public BT_ExceptionTableEntryVector exceptions = new BT_ExceptionTableEntryVector();
    public BT_InsVector ins;
    public int maxStack = -1;
    public int maxLocals;
    public boolean hasBackwardBranches;
    protected int codeLen;
    public BT_Method method;
    public byte[] bytecodes;
    public static final int REACHABLE_CODE = -1;
    public static final int REACHABLE_BASIC_BLOCK = -2;
    private static BufferedReader sourceLineReader;
    private static String lastSourceFile;
    private static int lastLineNumber;
    private static int lastSourceLineNumberRead;
    private static final String hline_ = "-----------------------------------------------------------------";

    public String getName() {
        return ATTRIBUTE_NAME;
    }

    protected BT_CodeAttribute(byte[] data, BT_Method m) throws BT_ClassFileException, IOException {
        super(m);
        this.method = m;
        if (data.length < 8) {
            throw new BT_ClassFileException("Code attribute length");
        }
        this.maxStack = BT_Misc.bytesToUnsignedShort(data, 0);
        this.maxLocals = BT_Misc.bytesToUnsignedShort(data, 2);
        this.codeLen = BT_Misc.bytesToInt(data, 4);
        if (this.codeLen == 0) {
            throw new BT_ClassFileException("Code empty bytecode array");
        }
        if (this.codeLen > 65536) {
            throw new BT_ClassFileException("Code bytecode array too long");
        }
        this.bytecodes = data;
        if (data.length < 10 + this.codeLen) {
            throw new BT_ClassFileException("Code attribute length");
        }
        int nrExceptions = BT_Misc.bytesToUnsignedShort(data, 8 + this.codeLen);
        int next = this.initExceptionTable(data, 10 + this.codeLen, nrExceptions, m.getDeclaringClass().getRepository());
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data, next, data.length - next));
        this.readAttributes(dis, this.method.cls.pool);
        if (dis.available() > 0) {
            throw new BT_ClassFileException("Code attribute length");
        }
    }

    public BT_CodeAttribute(BT_Ins[] instrs) {
        super(null);
        this.ins = new BT_InsVector(this);
        this.ins.locals = new BT_LocalVector(this);
        int n = 0;
        int offset = 0;
        while (n < instrs.length) {
            instrs[n].setByteIndex(offset);
            offset += instrs[n].size();
            this.ins.addElement(instrs[n]);
            ++n;
        }
        this.bytecodes = null;
    }

    public void setMethod(BT_Method m) {
        this.method = m;
        this.initLocals();
    }

    public void initLocals() {
        int localNr = 0;
        if (this.method != null) {
            if ((this.method.flags & 8) == 0) {
                ++localNr;
            }
            int nargs = this.method.signature.types.size();
            int n = 0;
            while (n < nargs) {
                localNr += this.method.signature.types.elementAt(n).getSizeForLocal();
                ++n;
            }
            if (localNr > 0) {
                this.ins.locals.elementAt(localNr - 1);
            }
        }
    }

    public void lateDereference() {
        this.dereference();
    }

    void dereference() {
        if (this.method.getDeclaringClass().repository.factory.loadMethods) {
            this.ins = new BT_InsVector(this);
            this.ins.locals = new BT_LocalVector(this);
            this.initLocals();
            this.hasBackwardBranches = false;
            if (this.bytecodes == null) {
                return;
            }
            BT_Ins in1 = null;
            int offset = 0;
            try {
                while (offset < this.codeLen) {
                    in1 = BT_Ins.make(this.bytecodes, offset + 8, this.ins, this.method);
                    in1.setByteIndex(offset);
                    if ((offset += in1.size()) > this.codeLen) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    this.ins.addElement(in1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.method.setThrowsVerifyErrorTrue();
                throw new InternalError("bytecode incomplete in method " + this.method.fullName());
            }
            catch (BT_ClassFileException e) {
                this.method.setThrowsVerifyErrorTrue();
                throw new InternalError(String.valueOf(e.getMessage()) + " for " + this.method.fullName());
            }
            this.dereferenceInstructions();
            int n = 0;
            while (n < this.exceptions.size()) {
                this.exceptions.elementAt(n).dereference(this.ins, this.method.cls.pool);
                ++n;
            }
            super.dereference();
            this.computeInstructionSizes();
            if (this.ins.locals.size() > this.maxLocals) {
                this.method.cls.setThrowsVerifyErrorTrue();
                throw new InternalError("incorrect max locals for " + this.method.getName());
            }
        }
        if (!this.method.getDeclaringClass().repository.factory.keepBytecodes) {
            this.bytecodes = null;
        }
    }

    public void dereferenceInstructions() {
        int n = 0;
        while (n < this.ins.size()) {
            this.ins.elementAt(n).dereference(this.ins);
            ++n;
        }
    }

    public int computeInstructionSizes() {
        int offset = 0;
        int k = 0;
        while (k < this.ins.size()) {
            BT_Ins in1 = this.ins.elementAt(k);
            in1.setByteIndex(offset);
            offset += in1.size();
            ++k;
        }
        return offset;
    }

    public int bytecodeSize() {
        if (this.ins == null || this.ins.isEmpty()) {
            return 0;
        }
        BT_Ins last = this.ins.lastElement();
        return last.byteIndex + last.size();
    }

    private int initExceptionTable(byte[] data, int offset, int nrExceptions, BT_Repository repo) throws BT_ClassFileException {
        int end = offset + 8 * nrExceptions;
        if (data.length < end) {
            throw new BT_ClassFileException("Code attribute length");
        }
        int n = offset;
        while (n < end) {
            int startPC = BT_Misc.bytesToUnsignedShort(data, n);
            int endPC = BT_Misc.bytesToUnsignedShort(data, n + 2);
            int handlerPC = BT_Misc.bytesToUnsignedShort(data, n + 4);
            if (endPC <= startPC) {
                throw new BT_ClassFileException("Code contains invalid exception handler");
            }
            int index = BT_Misc.bytesToUnsignedShort(data, n + 6);
            String catchName = index == 0 ? "<finally>" : this.method.cls.pool.getClassNameAt(index, 7);
            this.exceptions.addElement(new BT_ExceptionTableEntry(startPC, endPC, handlerPC, catchName, repo));
            n += 8;
        }
        return end;
    }

    public void setExceptionHandler(int startInsNr, int endInsNr, int handlerInsNr, BT_Class catchType) {
        int startPC = this.ins.elementAt((int)startInsNr).byteIndex;
        int endPC = this.ins.elementAt((int)endInsNr).byteIndex;
        int handlerPC = this.ins.elementAt((int)handlerInsNr).byteIndex;
        this.exceptions.addElement(new BT_ExceptionTableEntry(this.ins.findBasicBlock(startPC), this.ins.findBasicBlock(endPC), this.ins.findBasicBlock(handlerPC), catchType));
    }

    public void changeReferencesFromTo(BT_Ins oldIns, BT_Ins newIns) {
        int k = 0;
        while (k < this.ins.size()) {
            this.ins.elementAt(k).changeReferencesFromTo(oldIns, newIns);
            ++k;
        }
        int n = 0;
        while (n < this.exceptions.size()) {
            this.exceptions.elementAt(n).changeReferencesFromTo(oldIns, newIns);
            ++n;
        }
        super.changeReferencesFromTo(oldIns, newIns);
    }

    public void changeReferencesAtTo(int howMany, int n, BT_Ins newIns) {
        int k = n;
        while (k < n + howMany) {
            this.changeReferencesFromTo(this.ins.elementAt(k), newIns);
            ++k;
        }
    }

    public boolean callsNoOtherMethods() {
        int k = 0;
        while (k < this.ins.size()) {
            if (this.ins.elementAt(k).isInvokeIns()) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public BT_Ins previousInstruction(BT_Ins in1) {
        int n = 1;
        while (n < this.ins.size()) {
            if (in1 == this.ins.elementAt(n)) {
                return this.ins.elementAt(n - 1);
            }
            ++n;
        }
        return null;
    }

    public BT_Ins nextInstruction(BT_Ins in1) {
        int n = 0;
        while (n < this.ins.size() - 1) {
            if (in1 == this.ins.elementAt(n)) {
                return this.ins.elementAt(n + 1);
            }
            ++n;
        }
        return null;
    }

    public void removeInstruction(BT_Ins in1) {
        int n = 0;
        while (n < this.ins.size()) {
            if (in1 == this.ins.elementAt(n)) {
                this.removeInstructionsAt(1, n);
                break;
            }
            ++n;
        }
        this.maxStack = -1;
    }

    public void replaceInstructionWith(BT_Ins oldIns, BT_Ins newIns) {
        int n = 0;
        while (n < this.ins.size()) {
            if (oldIns == this.ins.elementAt(n)) {
                this.replaceInstructionsAtWith(1, n, newIns);
                break;
            }
            ++n;
        }
        this.maxStack = -1;
    }

    public void replaceInstructionWith(BT_Ins oldIns, BT_Ins newIns1, BT_Ins newIns2) {
        int n = 0;
        while (n < this.ins.size()) {
            if (oldIns == this.ins.elementAt(n)) {
                this.replaceInstructionsAtWith(1, n, newIns1, newIns2);
                break;
            }
            ++n;
        }
        this.maxStack = -1;
    }

    public boolean removeInstructionAt(int n) {
        return this.removeInstructionsAt(1, n);
    }

    public boolean insertInstructionAt(BT_Ins in1, int n) {
        this.ins.insertElementAt(in1, n);
        in1.dereference(this.ins);
        this.maxStack = -1;
        return true;
    }

    public void insertInstruction(BT_Ins in1) {
        this.insertInstructionAt(in1, this.ins.size());
    }

    public boolean removeInstructionsAt(int howMany, int iin) {
        BT_Ins newRef = iin + howMany == this.ins.size() ? this.ins.elementAt(this.ins.size() - 1) : this.ins.elementAt(iin + howMany);
        this.changeReferencesAtTo(howMany, iin, newRef);
        int k = 0;
        while (k < howMany) {
            this.ins.elementAt(iin).remove();
            this.ins.removeElementAt(iin);
            ++k;
        }
        this.maxStack = -1;
        return true;
    }

    public void removeAllInstructions() {
        int k = 0;
        while (k < this.ins.size()) {
            this.ins.elementAt(k).remove();
            ++k;
        }
        this.ins.removeAllElements();
        this.maxStack = -1;
    }

    public boolean replaceInstructionsAtWith(int howMany, int n, BT_Ins in1) {
        in1.dereference(this.ins);
        this.ins.insertElementAt(in1, n + howMany);
        this.changeReferencesAtTo(howMany, n, this.ins.elementAt(n + howMany));
        int k = 0;
        while (k < howMany) {
            this.ins.elementAt(n).remove();
            this.ins.removeElementAt(n);
            ++k;
        }
        this.maxStack = -1;
        return true;
    }

    public void incrementLocalsAccessWith(int inc) {
        int start = 0;
        if (!this.method.isStatic()) {
            ++start;
        }
        int n = 0;
        while (n < this.method.signature.types.size()) {
            start += this.method.signature.types.elementAt(n).getSizeForLocal();
            ++n;
        }
        int size = this.ins.locals.size();
        int k = 0;
        while (k < inc) {
            this.ins.locals.addElement(new BT_Local(size + k));
            ++k;
        }
        k = 0;
        while (k < this.ins.size()) {
            this.ins.elementAt(k).incrementLocalsAccessWith(inc, start, this.ins.locals);
            ++k;
        }
    }

    private void incrementLocalsAndParametersAccessWith(int inc) {
        int size = this.ins.locals.size();
        int k = 0;
        while (k < inc) {
            this.ins.locals.addElement(new BT_Local(size + k));
            ++k;
        }
        k = 0;
        while (k < this.ins.size()) {
            this.ins.elementAt(k).incrementLocalsAccessWith(inc, 0, this.ins.locals);
            ++k;
        }
    }

    public boolean replaceInstructionsAtWith(int howMany, int n, BT_Ins in1, BT_Ins in2) {
        in1.dereference(this.ins);
        in2.dereference(this.ins);
        this.ins.insertElementAt(in2, n + howMany);
        this.ins.insertElementAt(in1, n + howMany);
        this.changeReferencesAtTo(howMany, n, this.ins.elementAt(n + howMany));
        int k = 0;
        while (k < howMany) {
            this.ins.elementAt(n).remove();
            this.ins.removeElementAt(n);
            ++k;
        }
        this.maxStack = -1;
        return true;
    }

    public void insertInstructionsAt(BT_InsVector newIns, int n) {
        int k = newIns.size() - 1;
        while (k >= 0) {
            BT_Ins in1 = newIns.elementAt(k);
            in1.dereference(this.ins);
            this.ins.insertElementAt(in1, n);
            --k;
        }
        this.maxStack = -1;
    }

    public void insertInstructionsAt(BT_Ins[] newIns, int n) {
        int k = newIns.length - 1;
        while (k >= 0) {
            BT_Ins in1 = newIns[k];
            in1.dereference(this.ins);
            this.ins.insertElementAt(in1, n);
            --k;
        }
        this.maxStack = -1;
    }

    public boolean optimize(boolean strict) {
        boolean result = false;
        int n = this.ins.size() - 1;
        while (n >= 0) {
            if (this.ins.elementAt(n).optimize(this, n, strict)) {
                result = true;
                if ((n += 2) > this.ins.size()) {
                    n = this.ins.size();
                }
            }
            --n;
        }
        if (result) {
            this.method.updateReferences();
        }
        return result;
    }

    public boolean isUnconditionalTo(int n) {
        if (n > this.ins.size()) {
            n = this.ins.size();
        }
        int i = 0;
        while (i < n) {
            switch (this.ins.elementAt((int)i).opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: 
                case 198: 
                case 199: 
                case 200: 
                case 201: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public BT_Class findTypeForLocal(int localNr) {
        if (localNr == 0 && !this.method.isStatic()) {
            return this.method.cls;
        }
        int l = this.method.isStatic() ? 0 : 1;
        int n = 0;
        while (n < this.method.signature.types.size()) {
            BT_Class c = this.method.signature.types.elementAt(n);
            if (localNr == l) {
                return c;
            }
            if (c.name.equals("long") || c.name.equals("double")) {
                ++l;
            }
            ++n;
            ++l;
        }
        int sl = -1;
        int k = 0;
        while (k < this.ins.size()) {
            if (this.ins.elementAt(k) instanceof BT_StoreLocalIns && ((BT_StoreLocalIns)this.ins.elementAt((int)k)).target.localNr == localNr) {
                if (sl != -1) {
                    return null;
                }
                sl = k;
            }
            ++k;
        }
        if (sl != -1 && this.ins.elementAt(sl - 1) instanceof BT_InvokeSpecialIns) {
            BT_InvokeSpecialIns isi = (BT_InvokeSpecialIns)this.ins.elementAt(sl - 1);
            if (isi.target.name.equals("<init>")) {
                return isi.target.cls;
            }
        }
        return null;
    }

    private void initByteIndex() {
        int k = 0;
        while (k < this.ins.size()) {
            this.ins.elementAt((int)k).byteIndex = k;
            ++k;
        }
    }

    private void markReachableBasicBlocks() {
        int k;
        if (this.ins.size() != 0) {
            k = 0;
            while (k < this.ins.size()) {
                BT_Ins in1 = this.ins.elementAt(k);
                if (in1.byteIndex == -1) {
                    if (in1 instanceof BT_JumpIns) {
                        if (((BT_JumpIns)in1).target instanceof BT_BasicBlockMarkerIns) {
                            ((BT_JumpIns)in1).target.byteIndex = -2;
                        }
                    } else if (in1 instanceof BT_SwitchIns) {
                        BT_SwitchIns s = (BT_SwitchIns)in1;
                        if (s.def instanceof BT_BasicBlockMarkerIns) {
                            s.def.byteIndex = -2;
                        }
                        int m = 0;
                        while (m < s.targets.length) {
                            if (s.targets[m] instanceof BT_BasicBlockMarkerIns) {
                                s.targets[m].byteIndex = -2;
                            }
                            ++m;
                        }
                    }
                }
                ++k;
            }
        }
        k = 0;
        while (k < this.exceptions.size()) {
            BT_ExceptionTableEntry e = this.exceptions.elementAt(k);
            if (!e.isEmpty()) {
                BT_Ins t = this.exceptions.elementAt((int)k).handlerTarget;
                if (t instanceof BT_BasicBlockMarkerIns) {
                    t.byteIndex = -2;
                }
                if ((t = this.exceptions.elementAt((int)k).startPCTarget) instanceof BT_BasicBlockMarkerIns) {
                    t.byteIndex = -2;
                }
                if ((t = this.exceptions.elementAt((int)k).endPCTarget) instanceof BT_BasicBlockMarkerIns) {
                    t.byteIndex = -2;
                }
            }
            ++k;
        }
    }

    public void visitReachableCode(BT_CodeVisitor cv) {
        if (this.ins.size() != 0) {
            this.initByteIndex();
            cv.setUp(this);
            this.visitReachableCode(cv, 0, -1);
        }
        int k = 0;
        while (k < this.exceptions.size()) {
            BT_ExceptionTableEntry e = this.exceptions.elementAt(k);
            if (!e.isEmpty()) {
                BT_Ins t = e.handlerTarget;
                this.visitReachableCode(cv, t.byteIndex, -1);
            }
            ++k;
        }
        cv.tearDown();
    }

    private boolean visitReachableCode(BT_CodeVisitor cv, int iin, int prev_iin) {
        boolean retSubroutine = false;
        do {
            BT_Ins instr = null;
            try {
                instr = this.ins.elementAt(iin);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.method.getDeclaringClass().getRepository().factory.noteJumpOutsideMethod(this, this.ins.elementAt(prev_iin));
            }
            if (cv.isVisited(iin, prev_iin)) {
                return retSubroutine;
            }
            cv.visit(iin, prev_iin);
            if (instr.isRetIns()) {
                return true;
            }
            if (instr.isAThrowIns()) {
                return retSubroutine;
            }
            if (instr.isReturnIns()) {
                return retSubroutine;
            }
            if (instr instanceof BT_SwitchIns) {
                BT_SwitchIns s = (BT_SwitchIns)instr;
                retSubroutine |= this.visitReachableCode(cv, s.def.byteIndex, iin);
                int k = 0;
                while (k < s.targets.length) {
                    retSubroutine |= this.visitReachableCode(cv, s.targets[k].byteIndex, iin);
                    ++k;
                }
                return retSubroutine;
            }
            boolean nextReachable = false;
            if (instr instanceof BT_JumpIns) {
                int ti = ((BT_JumpIns)instr).target.byteIndex;
                if (instr.opcode == 167 || instr.opcode == 200) {
                    try {
                        if (cv.isVisited(ti, iin)) {
                            return retSubroutine || cv.isSubroutineReturning(ti);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.method.getDeclaringClass().getRepository().factory.noteJumpOutsideMethod(this, instr);
                    }
                    prev_iin = iin;
                    iin = ti;
                } else {
                    nextReachable = true;
                    if (instr.opcode == 168 || instr.opcode == 201) {
                        if (cv.isVisited(ti, iin)) {
                            if (!cv.isSubroutineReturning(ti)) {
                                return retSubroutine;
                            }
                        } else {
                            cv.subroutineAnalysisStart(ti, iin);
                            boolean returning = this.visitReachableCode(cv, ti, iin);
                            cv.subroutineAnalysisEnd(ti, iin, returning);
                            if (!returning) {
                                return retSubroutine;
                            }
                        }
                    } else {
                        retSubroutine |= this.visitReachableCode(cv, ti, iin);
                    }
                }
            } else {
                nextReachable = true;
            }
            if (!nextReachable) continue;
            prev_iin = iin++;
        } while (iin != this.ins.size());
        this.method.getDeclaringClass().getRepository().factory.noteExecutionFallsOffEndOfMethod(-1, this);
        return retSubroutine;
    }

    public void markReachableCode() {
        if (this.ins.size() != 0) {
            this.initByteIndex();
            this.markReachableCode(0);
        }
        int k = 0;
        while (k < this.exceptions.size()) {
            BT_ExceptionTableEntry e = this.exceptions.elementAt(k);
            if (!e.isEmpty()) {
                BT_Ins t = e.handlerTarget;
                this.markReachableCode(t.byteIndex);
            }
            ++k;
        }
        this.markReachableBasicBlocks();
    }

    private void markReachableCode(int iin) {
        if (iin < 0) {
            return;
        }
        do {
            BT_Ins in1 = this.ins.elementAt(iin);
            if (in1.byteIndex < 0) {
                return;
            }
            in1.byteIndex = -1;
            if (in1.isAThrowIns() || in1.isRetIns()) {
                return;
            }
            if (in1.isReturnIns()) {
                return;
            }
            if (in1 instanceof BT_SwitchIns) {
                BT_SwitchIns s = (BT_SwitchIns)in1;
                this.markReachableCode(s.def.byteIndex);
                int k = 0;
                while (k < s.targets.length) {
                    int targetIndex = s.targets[k].byteIndex;
                    this.markReachableCode(targetIndex);
                    ++k;
                }
                return;
            }
            ++iin;
            if (!(in1 instanceof BT_JumpIns)) continue;
            int ti = ((BT_JumpIns)in1).target.byteIndex;
            if (in1.opcode == 167) {
                if (ti < 0) {
                    return;
                }
                iin = ti;
                continue;
            }
            this.markReachableCode(ti);
        } while (iin != this.ins.size());
    }

    public int computeMaxStackDepth() {
        final int[] max = new int[1];
        BT_CodeVisitor cv = new BT_CodeVisitor(){
            int[] stackDepth;
            Stack subroutineStack;
            Collection subroutineCollection;

            public void setUp(BT_CodeAttribute codeAttribute) {
                super.setUp(codeAttribute);
                this.stackDepth = new int[codeAttribute.ins.size()];
                this.subroutineStack = new Stack();
                this.subroutineCollection = new Vector();
            }

            private int getStackDepth(int iin, int prev_iin) {
                if (prev_iin == -1) {
                    if (iin == 0) {
                        return 0;
                    }
                    return 1;
                }
                boolean jsrReturn = false;
                if (prev_iin == iin - 1) {
                    BT_Ins instr = this.code.ins.elementAt(prev_iin);
                    int prev_opcode = instr.opcode;
                    if (prev_opcode == 168 || prev_opcode == 201) {
                        jsrReturn = !(instr instanceof BT_JumpIns) || ((BT_JumpIns)instr).target != this.code.ins.elementAt(iin);
                    }
                }
                if (jsrReturn) {
                    return this.getReturnStackSize(((BT_JumpOffsetIns)this.code.ins.elementAt((int)prev_iin)).target.byteIndex);
                }
                return this.stackDepth[prev_iin] + this.code.ins.elementAt(prev_iin).getStackDiff();
            }

            public void visit(int iin, int prev_iin) {
                super.visit(iin, prev_iin);
                this.stackDepth[iin] = this.getStackDepth(iin, prev_iin);
                if (this.stackDepth[iin] + this.code.ins.elementAt(iin).getPoppedStackDiff() < 0) {
                    BT_CodeAttribute.this.method.getDeclaringClass().getRepository().factory.noteStackUnderflow(this.stackDepth[iin], iin, this.code);
                }
                if (this.code.ins.elementAt(iin).isRetIns()) {
                    if (this.subroutineStack.isEmpty()) {
                        BT_CodeAttribute.this.method.getDeclaringClass().getRepository().factory.noteStackUnderflow(this.stackDepth[iin], iin, this.code);
                    } else {
                        ((Subroutine)this.subroutineStack.peek()).setDepthOnRet(this.stackDepth[iin]);
                    }
                }
            }

            private int getReturnStackSize(int firstIns) {
                Iterator iter = this.subroutineCollection.iterator();
                while (iter.hasNext()) {
                    Subroutine sub = (Subroutine)iter.next();
                    if (sub.getFirstIns() != firstIns) continue;
                    return sub.getDepthOnRet();
                }
                return -1;
            }

            public void tearDown() {
                int mmax = 0;
                if (this.stackDepth != null) {
                    int i = 0;
                    while (i < this.stackDepth.length) {
                        if (this.stackDepth[i] > mmax) {
                            mmax = this.stackDepth[i];
                        }
                        ++i;
                    }
                }
                max[0] = mmax;
                this.stackDepth = null;
                this.subroutineStack = null;
                this.subroutineCollection = null;
                super.tearDown();
            }

            public boolean isVisited(int iin, int prev_iin) {
                if (super.isVisited(iin, prev_iin)) {
                    if (this.stackDepth[iin] != this.getStackDepth(iin, prev_iin)) {
                        BT_CodeAttribute.this.method.getDeclaringClass().getRepository().factory.noteStackDepthInconsistent(iin, this.code);
                    }
                    return true;
                }
                return false;
            }

            public void subroutineAnalysisStart(int firstIns, int jsrIns) {
                super.subroutineAnalysisStart(firstIns, jsrIns);
                Subroutine sub = new Subroutine(firstIns);
                this.subroutineStack.push(sub);
                this.subroutineCollection.add(sub);
            }

            public void subroutineAnalysisEnd(int firstIns, int jsrIns, boolean returning) {
                this.subroutineStack.pop();
                super.subroutineAnalysisEnd(firstIns, jsrIns, returning);
            }

            class Subroutine {
                private int firstIns;
                private int depth = -1;

                Subroutine(int firstIns) {
                    this.firstIns = firstIns;
                }

                void setDepthOnRet(int retDepth) {
                    if (this.depth == -1) {
                        this.depth = retDepth;
                    } else if (this.depth != retDepth) {
                        (this).BT_CodeAttribute.this.method.getDeclaringClass().getRepository().factory.noteStackUnderflow(retDepth, this.firstIns, code);
                    }
                }

                int getDepthOnRet() {
                    return this.depth;
                }

                int getFirstIns() {
                    return this.firstIns;
                }
            }
        };
        this.visitReachableCode(cv);
        this.ins.setAllByteIndexes();
        return max[0];
    }

    public int computeStackDepth(int instIndex) {
        int k;
        int depth = 0;
        if (this.ins.size() != 0) {
            k = 0;
            while (k < this.ins.size()) {
                this.ins.elementAt((int)k).byteIndex = k;
                ++k;
            }
            depth = this.computeStackDepth(0, instIndex, 0);
        }
        k = 0;
        while (depth == -1 && k < this.exceptions.size()) {
            BT_Ins t = this.exceptions.elementAt((int)k).handlerTarget;
            depth = this.computeStackDepth(t.byteIndex, instIndex, 1);
            ++k;
        }
        this.ins.setAllByteIndexes();
        return depth;
    }

    private int computeStackDepth(int iin, int istop, int depth) {
        int targetDepth = -1;
        if (iin < 0) {
            return -1;
        }
        do {
            if (iin == istop || iin >= this.ins.size()) {
                return depth;
            }
            BT_Ins in1 = this.ins.elementAt(iin);
            if (in1.byteIndex < 0) {
                return -1;
            }
            in1.byteIndex = -1 - depth;
            depth += in1.getStackDiff();
            if (in1.isAThrowIns() || in1.isRetIns() || in1.isReturnIns()) {
                return -1;
            }
            if (in1 instanceof BT_SwitchIns) {
                BT_SwitchIns s = (BT_SwitchIns)in1;
                targetDepth = this.computeStackDepth(s.def.byteIndex, istop, depth);
                int k = 0;
                while (targetDepth == -1 && k < s.targets.length) {
                    targetDepth = this.computeStackDepth(s.targets[k].byteIndex, istop, depth);
                    ++k;
                }
                return targetDepth;
            }
            ++iin;
            if (!(in1 instanceof BT_JumpIns)) continue;
            int ti = ((BT_JumpIns)in1).target.byteIndex;
            if (in1.opcode == 167) {
                if (ti < 0) {
                    return -1;
                }
                iin = ti;
                continue;
            }
            if (in1.opcode == 168) {
                targetDepth = this.computeStackDepth(ti, istop, depth);
                --depth;
                continue;
            }
            targetDepth = this.computeStackDepth(ti, istop, depth);
        } while (targetDepth == -1);
        return targetDepth;
    }

    public int findJsrEnd(int instIndex) {
        int k = 0;
        while (k < this.ins.size()) {
            this.ins.elementAt((int)k).byteIndex = k;
            ++k;
        }
        int end = this.findJsrEnd(instIndex, -1);
        return end;
    }

    private int findJsrEnd(int iin, int end) {
        if (iin == -1) {
            return end;
        }
        while (true) {
            BT_Ins in1 = this.ins.elementAt(iin);
            if (in1.byteIndex == -1) {
                return end;
            }
            in1.byteIndex = -1;
            if (in1.isRetIns()) {
                return iin > end ? iin : end;
            }
            if (in1.isAThrowIns() || in1.isReturnIns()) {
                return end;
            }
            if (in1 instanceof BT_SwitchIns) {
                BT_SwitchIns s = (BT_SwitchIns)in1;
                end = this.findJsrEnd(s.def.byteIndex, end);
                int k = 0;
                while (k < s.targets.length) {
                    end = this.findJsrEnd(s.targets[k].byteIndex, end);
                    ++k;
                }
                return end;
            }
            ++iin;
            if (!(in1 instanceof BT_JumpIns)) continue;
            int ti = ((BT_JumpIns)in1).target.byteIndex;
            if (in1.opcode == 167) {
                if (ti == -1) {
                    return end;
                }
                iin = ti;
                continue;
            }
            if (in1.opcode == 168) continue;
            end = this.findJsrEnd(ti, end);
        }
    }

    public void resolveWithoutContainingAttrs(BT_ConstantPool pool) {
        int n = 0;
        int offset = 0;
        while (n < this.ins.size()) {
            BT_Ins in1 = this.ins.elementAt(n);
            in1.setByteIndex(offset);
            in1.resolve(this.ins, pool);
            offset += in1.size();
            ++n;
        }
        this.exceptions.removeEmptyRanges();
        n = 0;
        while (n < this.exceptions.size()) {
            this.exceptions.elementAt(n).resolve(this.ins, pool);
            ++n;
        }
        this.maxLocals = this.ins.locals.size();
        try {
            if (this.maxStack == -1) {
                this.maxStack = this.computeMaxStackDepth();
            }
        }
        catch (InternalError n2) {
        }
        catch (ArrayIndexOutOfBoundsException n2) {
            // empty catch block
        }
        int i = 0;
        while (i < this.attributes.size()) {
            BT_Attribute attr = this.attributes.elementAt(i);
            if (attr instanceof BT_LocalVariableAttribute) {
                BT_LocalVariableAttribute localVarAttr = (BT_LocalVariableAttribute)attr;
                BT_LocalVariableAttribute.LV[] localVariables = localVarAttr.localVariables;
                int count = 0;
                int j = 0;
                while (j < localVariables.length) {
                    BT_LocalVariableAttribute.LV lv = localVariables[j];
                    if (lv.localIndex < this.maxLocals && lv.startIns != lv.beyondIns) {
                        ++count;
                    } else {
                        localVariables[j] = null;
                    }
                    ++j;
                }
                if (count < localVariables.length) {
                    BT_LocalVariableAttribute.LV[] newLocalVariables = new BT_LocalVariableAttribute.LV[count];
                    count = 0;
                    int j2 = 0;
                    while (j2 < localVariables.length) {
                        if (localVariables[j2] != null) {
                            newLocalVariables[count++] = localVariables[j2];
                        }
                        ++j2;
                    }
                    localVarAttr.localVariables = newLocalVariables;
                }
            }
            ++i;
        }
    }

    public void resolve(BT_ConstantPool pool) {
        this.resolveWithoutContainingAttrs(pool);
        super.resolve(pool);
    }

    public void verify() throws BT_ClassFileException {
        this.computeMaxStackDepth();
        int n = 0;
        while (n < this.ins.size()) {
            BT_Ins i = this.ins.elementAt(n);
            if (i instanceof BT_FieldRefIns) {
                this.checkAccess(i.getFieldTarget());
            } else if (i instanceof BT_MethodRefIns) {
                this.checkAccess(i.getMethodTarget());
            }
            ++n;
        }
    }

    private void checkAccess(BT_Member member) throws BT_ClassFileException {
        BT_Class memberClass = member.cls;
        BT_Class userClass = this.method.cls;
        if (!BT_Factory.strictVerification || memberClass == userClass || memberClass.isPublic() && member.isPublic()) {
            return;
        }
        if (member.isPrivate()) {
            throw new BT_ClassFileException("Method " + this.method + " accesses a private member in another class: " + member);
        }
        boolean samePackage = false;
        int i = memberClass.getName().lastIndexOf(46);
        int j = userClass.getName().lastIndexOf(46);
        if (i < 0) {
            samePackage = j < 0;
        } else {
            boolean bl = samePackage = j == i && memberClass.getName().substring(0, i).equals(userClass.getName().substring(0, i));
        }
        if (samePackage) {
            return;
        }
        if (memberClass.isPublic() && member.isProtected()) {
            BT_Class c = userClass.getSuperClass();
            while (c != null) {
                if (c == memberClass) {
                    return;
                }
                c = c.getSuperClass();
            }
        }
        if (!memberClass.isPublic()) {
            throw new BT_ClassFileException("Method " + this.method + " accesses a member of a non-public class " + member);
        }
        throw new BT_ClassFileException("Method " + this.method + " accesses a non-public member " + member);
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        if (this.ins == null) {
            if (this.bytecodes == null) {
                BT_Base.fatal("Method does not contain dereferenced bytecode instructions, nor the original bytecodes: " + this.method);
            } else if (this.method.getDeclaringClass().pool == null) {
                BT_Base.fatal("Method contains the original bytecodes, but the declaring class' constantpool has disappeared: " + this.method);
            }
            dos.writeShort(pool.indexOfUtf8(ATTRIBUTE_NAME));
            dos.writeInt(this.bytecodes.length);
            dos.write(this.bytecodes, 0, this.bytecodes.length);
            return;
        }
        BT_Repository.debugRecentlyWrittenAttribute = this;
        int codeLen = 0;
        int n = 0;
        while (n < this.ins.size()) {
            BT_Ins in1 = this.ins.elementAt(n);
            in1.setByteIndex(codeLen);
            codeLen += in1.size();
            ++n;
        }
        dos.writeShort(pool.indexOfUtf8(ATTRIBUTE_NAME));
        dos.writeInt(8 + codeLen + 2 + this.exceptions.size() * 8 + this.writtenLengthOfAttributes());
        dos.writeShort(this.maxStack);
        dos.writeShort(this.maxLocals);
        dos.writeInt(codeLen);
        try {
            n = 0;
            while (n < this.ins.size()) {
                this.ins.elementAt(n).write(dos, pool);
                ++n;
            }
        }
        catch (InternalError e) {
            this.method.print(System.err);
            BT_Base.fatal("Internal error " + e + " -- while writing " + this.method);
        }
        dos.writeShort(this.exceptions.size());
        n = 0;
        while (n < this.exceptions.size()) {
            this.exceptions.elementAt(n).write(dos, pool);
            ++n;
        }
        this.writeAttributes(dos, pool);
    }

    public void print(PrintStream ps, int printFlag) {
        boolean offset;
        sourceLineReader = null;
        this.ins.setAllByteIndexes();
        if ((printFlag & 0x10) == 0) {
            this.computeMaxStackDepth();
            ps.println("\tmaxStack=" + this.maxStack + ", maxLocals=" + this.maxLocals);
        }
        int n = 0;
        int nLabels = 0;
        boolean offset2 = false;
        while (n < this.ins.size()) {
            BT_Ins in1 = this.ins.elementAt(n);
            try {
                ((BT_BasicBlockMarkerIns)in1).setLabel("label_" + nLabels++);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        if ((printFlag & 8) != 0) {
            n = 0;
            while (n < this.ins.size()) {
                BT_Ins in1 = this.ins.elementAt(n);
                int save = in1.byteIndex;
                in1.setByteIndex(0);
                ps.println("\t" + in1);
                in1.setByteIndex(save);
                ++n;
            }
        } else if ((printFlag & 0x10) != 0) {
            currentCodeAttribute = this;
            lastLineNumber = 0;
            n = 0;
            offset = false;
            while (n < this.ins.size()) {
                BT_Ins in1 = this.ins.elementAt(n);
                if (in1 instanceof BT_BasicBlockMarkerIns) {
                    this.printSourceLineNumber(ps, in1);
                    ps.println("\t" + in1.toAssemblerString());
                } else {
                    ps.println("\t\t" + in1.toAssemblerString());
                    this.printSourceLineNumber(ps, in1);
                }
                ++n;
            }
        } else {
            n = 0;
            offset = false;
            while (n < this.ins.size()) {
                BT_Ins in1 = this.ins.elementAt(n);
                ps.println("\t\t" + n + "\t" + in1);
                ++n;
            }
        }
        n = 0;
        while (n < this.exceptions.size()) {
            if ((printFlag & 0x10) != 0) {
                ps.println("\t\t" + this.exceptions.elementAt(n).toAssemblerString());
            } else {
                ps.println("\t\t" + this.exceptions.elementAt(n));
            }
            ++n;
        }
    }

    public static String getLocalName(int localNumber) {
        try {
            int i = 0;
            while (i < BT_CodeAttribute.currentCodeAttribute.attributes.size()) {
                BT_Attribute attr = BT_CodeAttribute.currentCodeAttribute.attributes.elementAt(i);
                if (attr instanceof BT_LocalVariableAttribute) {
                    BT_LocalVariableAttribute localVarAttr = (BT_LocalVariableAttribute)attr;
                    BT_LocalVariableAttribute.LV[] localVariables = localVarAttr.localVariables;
                    if (localVariables.length > 0) {
                        int j = 0;
                        while (j < localVariables.length) {
                            BT_LocalVariableAttribute.LV lv = localVariables[j];
                            if (lv.localIndex == localNumber) {
                                return lv.nameS;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void printSourceLineNumber(PrintStream ps, BT_Ins in1) {
        int lineNumber = this.method.findLineNumberForBytecode(in1.byteIndex);
        String sourceFile = this.method.getDeclaringClass().getSourceFile();
        if (lineNumber != lastLineNumber) {
            ps.println();
            ps.println("\t\t// " + sourceFile + ": " + lineNumber);
            lastLineNumber = lineNumber;
            if (sourceLineReader == null || !sourceFile.equals(lastSourceFile)) {
                lastSourceFile = sourceFile;
                lastSourceLineNumberRead = 1;
                String dir = String.valueOf(BT_Repository.getSourcePath()) + File.separatorChar;
                dir = String.valueOf(dir) + this.method.getDeclaringClass().packageName().replace('.', File.separatorChar) + File.separatorChar;
                try {
                    sourceLineReader = new BufferedReader(new FileReader(String.valueOf(dir) + sourceFile));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (sourceLineReader != null) {
                try {
                    String line = sourceLineReader.readLine();
                    while (line != null && lastSourceLineNumberRead++ < lineNumber) {
                        line = sourceLineReader.readLine();
                    }
                    if (line != null) {
                        ps.println("\t\t// " + line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void print(PrintStream ps) {
        this.print(ps, 0);
    }

    public String toStringWithMethod() {
        return "in " + (this.method == null ? "no method" : this.method.toString()) + " with " + this.ins.size() + " instructions";
    }

    public String toString() {
        return "<BT_CodeAttribute with " + this.ins.size() + " instructions>";
    }
}

