/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Class;
import com.ibm.jikesbt.BT_ConstantPool;
import com.ibm.jikesbt.BT_Ins;
import com.ibm.jikesbt.BT_InsVector;
import com.ibm.jikesbt.BT_Misc;
import com.ibm.jikesbt.BT_Repository;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BT_ClassRefIns
extends BT_Ins {
    public BT_Class target;

    BT_ClassRefIns(int opcode, BT_Class target) {
        super(opcode, -1);
        this.target = target;
    }

    BT_ClassRefIns(int opcode, String className, BT_Repository repo) {
        this(opcode, -1, repo.forName((String)className).name, repo);
    }

    BT_ClassRefIns(int opcode, int index, String className, BT_Repository repo) {
        super(opcode, index);
        this.target = repo.forName(className);
    }

    public void resolve(BT_InsVector ins, BT_ConstantPool pool) {
        pool.indexOfClassRef(this.target);
    }

    public BT_Class getClassTarget() {
        return this.target;
    }

    public BT_Class getTarget() {
        return this.target;
    }

    public void setTarget(BT_Class m) {
        this.target = m;
    }

    public void resetTarget(BT_Class m, BT_InsVector ins) {
        if (m != this.target) {
            this.remove();
            this.target = m;
            this.dereference(ins);
        }
    }

    public void replaceTarget(BT_Class oldTarget, BT_Class newTarget) {
        if (this.target == oldTarget) {
            this.target = newTarget;
        } else if (this.target.arrayType == oldTarget) {
            this.target = oldTarget.getRepository().forName(String.valueOf(newTarget.name) + this.target.name.substring(this.target.name.indexOf(91)));
        }
    }

    public void write(DataOutputStream dos, BT_ConstantPool pool) throws IOException {
        dos.writeByte(this.opcode);
        dos.writeShort(pool.indexOfClassRef(this.target));
        if (this.size() != 3) {
            throw new InternalError("Write/size error " + this);
        }
    }

    public String toString() {
        return String.valueOf(this.byteIndex) + "\t" + BT_Misc.opcodeName[this.opcode] + " " + this.target.name;
    }

    public String toAssemblerString() {
        return String.valueOf(BT_Misc.opcodeName[this.opcode]) + " " + this.target.name;
    }
}

