/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jikesbt;

import com.ibm.jikesbt.BT_Base;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BT_ClassPathEntry
extends BT_Base {
    protected String entryCanonicalName_;
    protected File entryFile_;
    protected ZipFile zipFile_;
    protected Vector zipFileDirectory_;

    protected BT_ClassPathEntry() {
    }

    protected BT_ClassPathEntry(File file) throws IOException {
        this.entryFile_ = file;
        this.entryCanonicalName_ = this.entryFile_.getCanonicalPath();
        if (this.entryFile_.isFile()) {
            this.zipFile_ = new ZipFile(this.entryFile_);
            this.zipFileDirectory_ = new Vector();
            Enumeration<? extends ZipEntry> e = this.zipFile_.entries();
            while (e.hasMoreElements()) {
                this.zipFileDirectory_.addElement(e.nextElement());
            }
        } else {
            this.zipFile_ = null;
            this.zipFileDirectory_ = null;
        }
    }

    protected BT_ClassPathLocation findFile(final String fileName) {
        if (this.zipFileDirectory_ == null) {
            final File f = new File(this.entryFile_, fileName);
            if (f.exists()) {
                return new BT_ClassPathLocation(){

                    public InputStream getInputStream() throws IOException {
                        return new FileInputStream(f);
                    }

                    public Object getFileObject() {
                        return f;
                    }

                    public String getName() {
                        return fileName;
                    }
                };
            }
        } else {
            int k = 0;
            while (k < this.zipFileDirectory_.size()) {
                final ZipEntry ze = (ZipEntry)this.zipFileDirectory_.elementAt(k);
                String entryName = ze.getName();
                if (entryName.equals(fileName)) {
                    return new BT_ClassPathLocation(){

                        public InputStream getInputStream() throws IOException {
                            return BT_ClassPathEntry.this.getZipFile().getInputStream(ze);
                        }

                        public Object getFileObject() {
                            return BT_ClassPathEntry.this.zipFile_;
                        }

                        public String getName() {
                            return fileName;
                        }
                    };
                }
                ++k;
            }
        }
        return null;
    }

    public String getEntryCanonicalName() {
        return this.entryCanonicalName_;
    }

    protected ZipFile getZipFile() {
        return this.zipFile_;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        BT_ClassPathEntry other = (BT_ClassPathEntry)o;
        return this.entryCanonicalName_.equals(other.entryCanonicalName_);
    }

    public String toString() {
        String s = "Class Path Entry: ";
        s = this.zipFile_ != null ? String.valueOf(s) + "zip file " : String.valueOf(s) + "directory ";
        return String.valueOf(s) + this.entryCanonicalName_;
    }

    public abstract class BT_ClassPathLocation {
        public BT_ClassPathEntry getClassPathEntry() {
            return BT_ClassPathEntry.this;
        }

        public abstract InputStream getInputStream() throws IOException;

        public abstract Object getFileObject();

        public abstract String getName();
    }
}

